/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.util.List;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class AttributeNameValidator {
    static final int MAXIMUM = 30;

    public static boolean validateAttributeName(String string, List<? extends AttributeType> list, Context context, boolean bl) {
        boolean bl2 = true;
        if (string.length() != 0) {
            if (!StringUtils.isDoubleQuotedString(string) && !AttributeNameValidator.isNameValidNonQuoted(string, bl)) {
                return false;
            }
            if (!AttributeNameValidator.isNameValid(string = !StringUtils.isDoubleQuotedString(string) ? string.toUpperCase() : StringUtils.trimDoubleQuotes(string), bl)) {
                return false;
            }
            if (!AttributeNameValidator.isNameUnique(string, list, bl)) {
                return false;
            }
            if (!AttributeNameValidator.isNameLengthValidInDB(context, string, bl)) {
                return false;
            }
        }
        return bl2;
    }

    public static boolean isNameValidNonQuoted(String string, boolean bl) {
        if (StringUtils.isValidNonQuotedDBObjectName(string)) {
            return true;
        }
        if (bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("NAME_ERROR_NAME_UNQUOTED_INVALID"), (String)UtilsLrb.get("NAME_ERROR_TITLE"), null);
        }
        return false;
    }

    public static boolean isNameValid(String string, boolean bl) {
        if (StringUtils.isDoubleQuotedString(string) && bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("NAME_ERROR_NAME_INVALID"), (String)UtilsLrb.get("NAME_ERROR_TITLE"), null);
            return false;
        }
        if (WorkflowUtils.validateDBObjectName(string)) {
            return true;
        }
        if (bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("NAME_ERROR_NAME_INVALID"), (String)UtilsLrb.get("NAME_ERROR_TITLE"), null);
        }
        return false;
    }

    public static boolean isNameLengthValidInDB(Context context, String string, boolean bl) {
        boolean bl2 = false;
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        bl2 = StringUtils.checkStringDBLengthMax(string, connectionFolder, 30);
        if (!bl2 && bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("NAME_ERROR_NAME_INVALID"), (String)UtilsLrb.get("NAME_ERROR_TITLE"), null);
        }
        return bl2;
    }

    public static boolean isNameUnique(String string, List<? extends AttributeType> list, boolean bl) {
        if (list == null) {
            return true;
        }
        for (AttributeType attributeType : list) {
            if (attributeType.getAlias() != null && attributeType.getAlias().compareTo(string) == 0) {
                if (bl) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("NAME_ERROR_NAME_DUPLICATE"), (String)UtilsLrb.get("NAME_ERROR_TITLE"), null);
                }
                return false;
            }
            if (attributeType.getName().compareTo(string) != 0 || attributeType.getAlias() != null && attributeType.getAlias().length() != 0) continue;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("NAME_ERROR_NAME_DUPLICATE"), (String)UtilsLrb.get("NAME_ERROR_TITLE"), null);
            return false;
        }
        return true;
    }
}

