/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.profit;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.profit.ProfitTabState;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ProfitDetailPanel
extends DialogDisplayer {
    private List<ProfitTabState.ProfitData> _data;
    private ProfitTabState _state;
    private String testResult;
    private DataMinerTable ProfitDetailTable;
    private JScrollPane jScrollPane1;

    public ProfitDetailPanel(String string, ProfitTabState profitTabState, List<ProfitTabState.ProfitData> list) {
        this.testResult = string;
        this._state = profitTabState;
        this._data = list;
        this.initComponents();
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    @Override
    public void initUI() {
    }

    @Override
    public void initRes() {
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.ProfitDetailTable = new DataMinerTable();
        this.setPreferredSize(new Dimension(475, 400));
        this.ProfitDetailTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView((Component)((Object)this.ProfitDetailTable));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 580, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 378, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    protected String getDialogTitle() {
        return TestViewerLrb.get("PROFIT_DETAIL_DIALOG") + this.testResult;
    }

    @Override
    protected String getHelpTopic() {
        return "profit_detail";
    }

    @Override
    protected int getDialogButtonMask() {
        return 5;
    }

    public class ProfitDetailModel
    extends GenericBaseTableModel {
        private static final int POPULATION = 0;
        private static final int PROFIT = 1;
        private static final int ROI = 2;
        private static final int PERCENTAGE_RECORDS_CUMULATIVE = 3;
        private static final int TARGET_DENSITY_CUMULATIVE = 4;
        private List<ProfitTabState.ProfitData> _profitData = null;
        private String[] _columnNames = new String[]{StringUtils.stripMnemonic((String)TestViewerLrb.get("POPULATION")), StringUtils.stripMnemonic((String)TestViewerLrb.get("PROFIT")), StringUtils.stripMnemonic((String)TestViewerLrb.get("ROI")), StringUtils.stripMnemonic((String)TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE")), StringUtils.stripMnemonic((String)TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE"))};

        public ProfitDetailModel() {
            this(null);
        }

        public ProfitDetailModel(List<ProfitTabState.ProfitData> list) {
            this.setColumnIdentifiers(this._columnNames);
            this._profitData = list;
            this.setRowCount(this._profitData.size() - 1);
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            if (this._profitData == null) {
                if (n2 == 0) {
                    return CommonLrb.get("COMMON_LOADING");
                }
                return null;
            }
            int n3 = n + 1;
            int n4 = this._profitData.size();
            double d = this._profitData.get((int)(n4 - 1))._targetCum + this._profitData.get((int)(n4 - 1))._nonTargetCum;
            double d2 = this._profitData.get((int)n3)._targetCum;
            double d3 = this._profitData.get((int)n3)._nonTargetCum;
            if (n2 == 0) {
                return this._profitData.get((int)n3)._quantile;
            }
            if (n2 == 1) {
                double d4 = ProfitDetailPanel.this._state.getInc_revenue() * d2;
                double d5 = ProfitDetailPanel.this._state.getInc_cost() * (d2 + d3);
                double d6 = -1.0 * ProfitDetailPanel.this._state.getStartup_cost() + (d4 - d5) * ProfitDetailPanel.this._state.getPopulation() / d;
                return d6;
            }
            if (n2 == 2) {
                double d7 = ProfitDetailPanel.this._state.getInc_revenue() * d2;
                double d8 = ProfitDetailPanel.this._state.getInc_cost() * (d2 + d3);
                double d9 = (d7 - d8) / d8 * 100.0;
                return d9;
            }
            if (n2 == 3) {
                return this._profitData.get((int)n3)._percentRecordsCum;
            }
            if (n2 == 4) {
                return this._profitData.get((int)n3)._targetDensityCum;
            }
            return "Undefined";
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        protected Object doInBackground() throws Exception {
            try {
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return this._success;
        }

        @Override
        protected void done() {
            block6: {
                super.done();
                try {
                    if (this._success && this._ex == null) {
                        ProfitDetailPanel.this.ProfitDetailTable.setModel((TableModel)((Object)new ProfitDetailModel(ProfitDetailPanel.this._data)));
                        ProfitDetailPanel.this.ProfitDetailTable.setShowToolTips(true);
                        ProfitDetailPanel.this.ProfitDetailTable.setSorted(true);
                        ProfitDetailPanel.this.ProfitDetailTable.setUpdateSelectionOnSort(true);
                        ProfitDetailPanel.this.ProfitDetailTable.setRowSelectionAllowed(true);
                        ProfitDetailPanel.this.ProfitDetailTable.setColumnSelectionAllowed(false);
                        ProfitDetailPanel.this.ProfitDetailTable.setAutoResizeMode(0);
                        ProfitDetailPanel.this.ProfitDetailTable.autoSizeColumnsToFit();
                        NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
                        TableColumn tableColumn = ProfitDetailPanel.this.ProfitDetailTable.getColumnModel().getColumn(3);
                        tableColumn.setCellRenderer(numberCellRenderer);
                        tableColumn = ProfitDetailPanel.this.ProfitDetailTable.getColumnModel().getColumn(4);
                        tableColumn.setCellRenderer(numberCellRenderer);
                        tableColumn = ProfitDetailPanel.this.ProfitDetailTable.getColumnModel().getColumn(1);
                        tableColumn.setCellRenderer(numberCellRenderer);
                        tableColumn = ProfitDetailPanel.this.ProfitDetailTable.getColumnModel().getColumn(2);
                        tableColumn.setCellRenderer(numberCellRenderer);
                        break block6;
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                        break block6;
                    }
                    MessageDialog.error((Component)Ide.getMainWindow(), null, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                }
            }
        }
    }
}

