/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.AbstractHiddenNode;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.javatools.icons.OracleIcons;

public class TestCompareNode
extends AbstractHiddenNode {
    private List<TestResult> _testResults;
    private SharedTestEditorState _sharedState;
    private boolean _showTestMetrics = false;
    private boolean _showConfusionMatrix = false;
    private boolean _showLiftProfit = false;
    private boolean _showROC = false;
    private String parentNodeId;

    public TestCompareNode() {
        this.getAttributes().set(ElementAttributes.CLOSEABLE);
    }

    public void setTestResults(List<TestResult> list) {
        this._testResults = list;
        for (TestResult testResult : list) {
            if (!(testResult instanceof ClassTestResult)) continue;
            if (((ClassTestResult)testResult).isROCResult()) {
                this._showROC = true;
            }
            if (((ClassTestResult)testResult).isAccuracyMetricsResult()) {
                this._showTestMetrics = true;
            }
            if (((ClassTestResult)testResult).isConfusionMatrixResult()) {
                this._showConfusionMatrix = true;
            }
            if (!((ClassTestResult)testResult).isLiftProfitResult()) continue;
            this._showLiftProfit = true;
        }
    }

    public List<TestResult> getTestResults() {
        return this._testResults;
    }

    public boolean isDirty() {
        return false;
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        NodeFactory.uncache((URL)this.getURL());
    }

    @Override
    public Icon getIcon() {
        if (_icon == null) {
            _icon = OracleIcons.getIcon((String)"compare.png");
        }
        return _icon;
    }

    public SharedTestEditorState getSharedTestEditorState() {
        if (this._sharedState == null) {
            this._sharedState = new SharedTestEditorState((Node)this);
        }
        return this._sharedState;
    }

    public boolean isShowTestMetrics() {
        return this._showTestMetrics;
    }

    public boolean isShowConfusionMatrix() {
        return this._showConfusionMatrix;
    }

    public boolean isShowLiftProfit() {
        return this._showLiftProfit;
    }

    public boolean isShowROC() {
        return this._showROC;
    }

    public boolean isPartitionedResult() {
        return true;
    }

    public String getParentNodeId() {
        return this.parentNodeId;
    }

    public void setParentNodeId(String string) {
        this.parentNodeId = string;
    }
}

