/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.structure;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataNode;
import oracle.dmt.dataminer.navigator.PhysicalDataNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.wflownodes.DataProfileNavNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.teditor.structure.ColumnDataRow;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.ConnectionProperties;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;

public class StructureViewState {
    private Context _context;
    private String _connectionName;
    private Node _node;
    private String _cacheTableName;
    private String _cacheSchemaName;
    private boolean _loadFromNode = true;
    private boolean _loadFromSQL = false;
    private String _sqlExpression;
    private List<String> jsonColumns;
    private static String _sql = " SELECT COLUMN_NAME,\n  DATA_TYPE        ,\n  DATA_LENGTH      ,\n  DATA_PRECISION   ,\n  DATA_SCALE ,\n  COLUMN_ID \n   FROM all_tab_columns\n  WHERE TABLE_NAME = ? AND \n  OWNER = ? \n ORDER BY COLUMN_ID ASC";

    public List<String> getJsonColumns() {
        return this.jsonColumns;
    }

    public StructureViewState(Context context) {
        assert (context != null) : "Context cannot be passed into constructore as a null.";
        this._context = context;
        this.initTable();
    }

    public StructureViewState(Context context, boolean bl) {
        assert (context != null) : "Context cannot be passed into constructore as a null.";
        this._context = context;
        this._loadFromNode = bl;
        if (this._loadFromNode) {
            this.initTable();
        }
    }

    public StructureViewState(String string, String string2, String string3) {
        this._context = null;
        this._loadFromNode = false;
        this._connectionName = string;
        this._cacheTableName = string3;
        this._cacheSchemaName = string2;
    }

    public StructureViewState(Context context, String string) {
        assert (context != null) : "Context cannot be passed into constructore as a null.";
        this._context = context;
        this._loadFromNode = false;
        this._loadFromSQL = true;
        this._sqlExpression = string;
    }

    private void initTable() {
        this._node = this._context.getNode();
        assert (this._node != null) : "Tree Node is not null";
        assert (this._node instanceof DataNode) : "Node is not of type DataNode";
        PhysicalDataNode physicalDataNode = null;
        if (this._node instanceof DataNode) {
            DataNode dataNode = (DataNode)this._node;
            this._cacheTableName = dataNode.getCacheTableName();
            this._cacheSchemaName = dataNode.getCacheSchemaName();
            if ((this._cacheTableName == null || this._cacheTableName.length() == 0) && this._node instanceof PhysicalDataNode) {
                physicalDataNode = (PhysicalDataNode)this._node.getData();
                this._cacheTableName = physicalDataNode.getTableName();
                this._cacheSchemaName = physicalDataNode.getUserName();
            }
        }
    }

    public String getSchema() {
        return this._cacheSchemaName;
    }

    public String getName() {
        return this._cacheTableName;
    }

    public void setTableName(String string, String string2) {
        this._cacheSchemaName = string;
        this._cacheTableName = string2;
    }

    public void setSqlExpression(String string) {
        this._sqlExpression = string;
    }

    public String getSqlExpression() {
        return this._sqlExpression;
    }

    public List<ColumnDataRow> load() throws SQLException {
        if (this._loadFromSQL) {
            if (this._sqlExpression != null) {
                return this.getMetaData();
            }
        } else {
            if (this._node == null) {
                return this.reload();
            }
            DataNode dataNode = (DataNode)this._node;
            this._cacheTableName = dataNode.getCacheTableName();
            this._cacheSchemaName = dataNode.getCacheSchemaName();
            if (this._cacheTableName == null || this._cacheTableName.length() == 0) {
                Object object = this._node.getData();
                if (object instanceof DataProfileNavNode) {
                    String string = ((DataProfileNavNode)object).getStatsTableName();
                    StringBuilder stringBuilder = new StringBuilder("SELECT * FROM (");
                    stringBuilder.append(string);
                    stringBuilder.append(")");
                    this.setSqlExpression(stringBuilder.toString());
                    return this.getMetaData();
                }
                return this.getMetaData();
            }
            return this.reload();
        }
        return new ArrayList<ColumnDataRow>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ColumnDataRow> reload() throws SQLException {
        List<ColumnDataRow> list = null;
        if (this._loadFromSQL) {
            if (this._sqlExpression != null) {
                list = this.getMetaData();
            }
        } else {
            SQLHelper sQLHelper = new SQLHelper();
            list = new ArrayList<ColumnDataRow>();
            boolean bl = false;
            try {
                Object object;
                if (this._context != null) {
                    object = ConnectionFolder.getConnectionFolder(this._context).getDbVersion();
                    bl = ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_2, object, true);
                    sQLHelper.conn = ConnectionFolder.getConnection(this._context);
                } else {
                    sQLHelper.conn = ConnectionFolder.getConnection(this._connectionName);
                }
                if (bl) {
                    this.jsonColumns = DatabaseMetadataUtils.getJSONColumns(sQLHelper.conn, this._cacheTableName, this._cacheSchemaName);
                    sQLHelper.conn = this._context != null ? ConnectionFolder.getConnection(this._context) : ConnectionFolder.getConnection(this._connectionName);
                } else {
                    this.jsonColumns = null;
                }
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(_sql);
                sQLHelper.pstmt.setString(1, this._cacheTableName);
                sQLHelper.pstmt.setString(2, this._cacheSchemaName);
                sQLHelper.pstmt.setFetchSize(1000);
                sQLHelper.pstmt.execute();
                object = null;
                String string = null;
                sQLHelper.rs = sQLHelper.pstmt.getResultSet();
                while (sQLHelper.rs.next()) {
                    String string2 = sQLHelper.rs.getString("COLUMN_NAME");
                    String string3 = sQLHelper.rs.getString("DATA_TYPE");
                    if (this.jsonColumns != null && this.jsonColumns.contains(string2)) {
                        string = "JSON";
                    }
                    Integer n = sQLHelper.rs.getInt("DATA_LENGTH");
                    Integer n2 = sQLHelper.rs.getInt("DATA_PRECISION");
                    Integer n3 = sQLHelper.rs.getInt("DATA_SCALE");
                    Integer n4 = sQLHelper.rs.getInt("COLUMN_ID");
                    object = new ColumnDataRow(string2, string3, string, n, n2, n3, n4);
                    list.add((ColumnDataRow)object);
                }
            }
            finally {
                sQLHelper.close();
            }
        }
        return list;
    }

    private String getStackedSQL() {
        DataNode dataNode = (DataNode)this._node;
        WorkflowNode workflowNode = (WorkflowNode)dataNode.getParent().getAncestor(WorkflowNode.class);
        WorkflowModel workflowModel = workflowNode.getWorkflowModel();
        if (workflowModel == null) {
            return null;
        }
        DataNodeType dataNodeType = (DataNodeType)dataNode.getRepositoryData();
        AbstractDataNode abstractDataNode = (AbstractDataNode)workflowModel.findNodeByMetadataId(dataNodeType.getId());
        if (abstractDataNode == null) {
            return null;
        }
        return abstractDataNode.getStackedSQL(workflowModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ColumnDataRow> getMetaData() throws SQLException {
        ArrayList<ColumnDataRow> arrayList = new ArrayList<ColumnDataRow>();
        String string = null;
        string = this._sqlExpression != null ? this._sqlExpression : this.getStackedSQL();
        if (string == null) {
            return arrayList;
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT * FROM ( ");
        stringBuilder.append(string);
        stringBuilder.append(")");
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this._context != null ? ConnectionFolder.getConnection(this._context, ConnectionProperties.ALTER_SESSION_FIXES) : ConnectionFolder.getConnection(this._connectionName, ConnectionProperties.ALTER_SESSION_FIXES);
            OracleConnection oracleConnection = (OracleConnection)sQLHelper.conn;
            Array array = oracleConnection.createOracleArray("ODMR_OBJECT_VALUES", (Object)new String[0]);
            Array array2 = oracleConnection.createOracleArray("ODMR_OBJECT_NAMES", (Object)new String[0]);
            Array array3 = oracleConnection.createOracleArray("ODMR_OBJECT_IDS", (Object)new String[0]);
            Array array4 = oracleConnection.createOracleArray("ODMR_OBJECT_IDS", (Object)new String[0]);
            Array array5 = oracleConnection.createOracleArray("ODMR_OBJECT_IDS", (Object)new String[0]);
            sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall("{call ODMR_UTIL.DESCRIBE_SQL_EXPRESSION(?,?,?,?,?,?)}");
            sQLHelper.cstmt.setCharacterStream(1, (Reader)new StringReader(stringBuilder.toString()), stringBuilder.length());
            sQLHelper.cstmt.setArray(2, array);
            sQLHelper.cstmt.setArray(3, array2);
            sQLHelper.cstmt.setArray(4, array3);
            sQLHelper.cstmt.setArray(5, array4);
            sQLHelper.cstmt.setArray(6, array5);
            sQLHelper.cstmt.registerOutParameter(2, 2003, "ODMR_OBJECT_VALUES");
            sQLHelper.cstmt.registerOutParameter(3, 2003, "ODMR_OBJECT_NAMES");
            sQLHelper.cstmt.registerOutParameter(4, 2003, "ODMR_OBJECT_IDS");
            sQLHelper.cstmt.registerOutParameter(5, 2003, "ODMR_OBJECT_IDS");
            sQLHelper.cstmt.registerOutParameter(6, 2003, "ODMR_OBJECT_IDS");
            sQLHelper.cstmt.execute();
            Array array6 = sQLHelper.cstmt.getArray(2);
            String[] stringArray = (String[])array6.getArray();
            Array array7 = sQLHelper.cstmt.getArray(3);
            String[] stringArray2 = (String[])array7.getArray();
            Array array8 = sQLHelper.cstmt.getArray(4);
            BigDecimal[] bigDecimalArray = (BigDecimal[])array8.getArray();
            Array array9 = sQLHelper.cstmt.getArray(5);
            BigDecimal[] bigDecimalArray2 = (BigDecimal[])array9.getArray();
            Array array10 = sQLHelper.cstmt.getArray(6);
            BigDecimal[] bigDecimalArray3 = (BigDecimal[])array10.getArray();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = stringArray2[i];
                int n = bigDecimalArray[i].intValue();
                int n2 = bigDecimalArray2[i].intValue();
                int n3 = bigDecimalArray3[i].intValue();
                ColumnDataRow columnDataRow = new ColumnDataRow(string2, string3, n, n2, n3, null);
                arrayList.add(columnDataRow);
            }
        }
        return arrayList;
    }
}

