/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.teditor.graph.AbstractDialog;
import oracle.dmt.dataminer.teditor.graph.CategoricalBinningWorker;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BinningSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.BinningType;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericBaseTableModel;

class GroupByValuesDialog
extends AbstractDialog {
    private BinningSettingsType binningSettings;
    private AttributeType binnedAttribute;
    private boolean dialogOk;
    private Context context;
    ValuesTableModel tableModel = null;
    private JButton btnCancel;
    private JButton btnHelp;
    private JButton btnOk;
    private JPanel contentPanel;
    private JLabel lblNote;

    public GroupByValuesDialog(Dialog dialog, Context context, boolean bl, BinningSettingsType binningSettingsType, AttributeType attributeType) {
        super(dialog, bl);
        this.context = context;
        this.binningSettings = binningSettingsType;
        this.binnedAttribute = attributeType;
        this.dialogOk = false;
        this.initComponents();
        this.setLocationRelativeTo(dialog);
        this.initUI();
    }

    private void initComponents() {
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.contentPanel = new JPanel();
        this.lblNote = new JLabel();
        this.btnHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.btnCancel.setText("Cancel");
        this.btnOk.setText("OK");
        GroupLayout groupLayout = new GroupLayout(this.contentPanel);
        this.contentPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 368, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 170, Short.MAX_VALUE));
        this.lblNote.setText("Note: Ignored values will be combined into \"Other\"");
        this.btnHelp.setText("Help");
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.btnHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnCancel)).addComponent(this.contentPanel, -1, -1, Short.MAX_VALUE).addComponent(this.lblNote, -1, 368, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.contentPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNote, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk).addComponent(this.btnHelp)).addContainerGap()));
        this.pack();
    }

    private void initUI() {
        this.contentPanel.setLayout(new BorderLayout());
        this.setTitle(GraphLrb.get("BIN_LOV_DLG_TITLE"));
        this.lblNote.setText(GraphLrb.get("BIN_LOV_NOTE"));
        try {
            ArrayList<TableRowItem> arrayList = new ArrayList();
            Vector<NameValuePair> vector = CategoricalBinningWorker.getDefaultBins(this.context, this.binnedAttribute, true);
            arrayList = this.getBinItems(vector, false);
            final DataMinerTablePanel dataMinerTablePanel = new DataMinerTablePanel();
            JButton jButton = new JButton(GraphLrb.get("BIN_LOV_ALL"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GroupByValuesDialog.this.tableModel.selectAll();
                }
            });
            JButton jButton2 = new JButton(GraphLrb.get("BIN_LOV_NONE"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GroupByValuesDialog.this.tableModel.selectNone();
                }
            });
            JButton jButton3 = new JButton(GraphLrb.get("BIN_LOV_DEFAULT"));
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ArrayList<TableRowItem> arrayList = new ArrayList();
                    Vector<Object> vector = new Vector();
                    try {
                        vector = CategoricalBinningWorker.getDefaultBins(GroupByValuesDialog.this.context, GroupByValuesDialog.this.binnedAttribute, true);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(GroupByValuesDialog.class.getName()).log(Level.SEVERE, null, exception);
                    }
                    arrayList = GroupByValuesDialog.this.getBinItems(vector, true);
                    GroupByValuesDialog.this.tableModel = new ValuesTableModel(arrayList);
                    dataMinerTablePanel.getTable().setModel((TableModel)((Object)GroupByValuesDialog.this.tableModel));
                    dataMinerTablePanel.getTable().getColumnModel().getColumn(0).setCellRenderer(new ValueRowRenderer());
                    dataMinerTablePanel.getTable().getColumnModel().getColumn(0).setCellEditor(new ValueRowEditor());
                }
            });
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GroupByValuesDialog.this.btnOkActionPerformed();
                }
            });
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GroupByValuesDialog.this.btnCancelActionPerformed();
                }
            });
            this.btnHelp.setText(CommonLrb.get("COMMON_HELP"));
            this.btnHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HelpSystem.getHelpSystem().showHelp(new HelpInfo("graph_node_select_values_display", 0));
                }
            });
            dataMinerTablePanel.addControlBarComponents(jButton, jButton2, jButton3);
            this.tableModel = new ValuesTableModel(arrayList);
            dataMinerTablePanel.setup((TableModel)((Object)this.tableModel), GraphLrb.get("BIN_LOV_VALUES"), 0, true);
            dataMinerTablePanel.getTable().getColumnModel().getColumn(0).setCellRenderer(new ValueRowRenderer());
            dataMinerTablePanel.getTable().getColumnModel().getColumn(0).setCellEditor(new ValueRowEditor());
            this.contentPanel.add(dataMinerTablePanel);
        }
        catch (Exception exception) {
            Logger.getLogger(GroupByValuesDialog.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    private List<TableRowItem> getBinItems(Vector<NameValuePair> vector, boolean bl) {
        ArrayList<TableRowItem> arrayList = new ArrayList<TableRowItem>();
        boolean bl2 = this.binningSettings.getStringFilterValues().isEmpty() || bl;
        List list = this.binningSettings.getStringFilterValues();
        for (int i = 0; i < vector.size() - 1; ++i) {
            NameValuePair nameValuePair = vector.get(i);
            String string = nameValuePair.getName();
            boolean bl3 = false;
            bl3 = bl2 ? i < 10 : list.contains(string);
            TableRowItem tableRowItem = new TableRowItem(string, bl3);
            arrayList.add(tableRowItem);
        }
        return arrayList;
    }

    @Override
    protected void btnCancelActionPerformed() {
        super.btnOkActionPerformed();
        this.setVisible(false);
    }

    @Override
    protected void btnOkActionPerformed() {
        this.dialogOk = true;
        if (this.tableModel.getSelected().size() == 0) {
            MessageDialog.error((Component)this, (Object)CommonLrb.get("NO_SELECTION_MULTI"), (String)CommonLrb.get("NO_SELECTION_TITLE"), null);
            return;
        }
        this.binningSettings.getStringFilterValues().clear();
        this.binningSettings.getStringFilterValues().addAll(this.tableModel.getSelected());
        this.binningSettings.setNumericBinCount(null);
        this.binningSettings.setCustomBinning(null);
        this.binningSettings.setBinningKind(BinningType.TOP_N);
        super.btnOkActionPerformed();
        this.setVisible(false);
    }

    private static class TableRowItem {
        private String value;
        private Boolean selected;

        public TableRowItem(String string, Boolean bl) {
            this.value = string;
            this.selected = bl;
        }

        public String getValue() {
            return this.value;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public String toString() {
            return this.value;
        }
    }

    private static class ValuesTableModel
    extends GenericBaseTableModel {
        List<TableRowItem> data = null;
        public static final int ATTRIBUTE_NAME = 0;
        private static final int COLUMN_COUNT = 1;
        private String[] columnNames = new String[]{"Value"};

        public ValuesTableModel() {
            this.setColumnIdentifiers(this.columnNames);
        }

        public ValuesTableModel(List<TableRowItem> list) {
            this.data = list;
            this.setColumnIdentifiers(this.columnNames);
        }

        public List<String> getSelected() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TableRowItem tableRowItem : this.data) {
                if (!tableRowItem.isSelected()) continue;
                arrayList.add(tableRowItem.getValue());
            }
            return arrayList;
        }

        public void selectAll() {
            for (TableRowItem tableRowItem : this.data) {
                tableRowItem.setSelected(true);
            }
            this.fireTableDataChanged();
        }

        public void selectNone() {
            for (TableRowItem tableRowItem : this.data) {
                tableRowItem.setSelected(false);
            }
            this.fireTableDataChanged();
        }

        public void setSelected(int n, boolean bl) {
            this.data.get(n).setSelected(bl);
            this.fireTableRowsUpdated(n, n);
        }

        public boolean isSelected(int n) {
            return this.data.get(n).isSelected();
        }

        public void setValueAt(Object object, int n, int n2) {
            TableRowItem tableRowItem = this.data.get(n);
            TableRowItem tableRowItem2 = (TableRowItem)object;
            tableRowItem.setSelected(tableRowItem2.isSelected());
        }

        public Object getValueAt(int n, int n2) {
            return this.data.get(n);
        }

        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }

    private static class ValueRowEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JCheckBox component = new JCheckBox();
        private TableRowItem currentValue;

        public ValueRowEditor() {
            this.component.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentValue = (TableRowItem)object;
            TableRowItem tableRowItem = (TableRowItem)object;
            this.component.setSelected(tableRowItem.isSelected());
            this.component.setText(tableRowItem.getValue());
            return this.component;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            this.currentValue.setSelected(jCheckBox.isSelected());
            this.fireEditingStopped();
        }
    }

    private static class ValueRowRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TableRowItem tableRowItem = (TableRowItem)object;
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setText(tableRowItem.getValue());
            this.setSelected(tableRowItem.isSelected());
            return this;
        }
    }
}

