/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.navigator.DataNode;
import oracle.dmt.dataminer.navigator.DataProfilePhysicalNode;
import oracle.dmt.dataminer.teditor.AbstractDataEditor;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.data.DataSourceViewOption;
import oracle.dmt.dataminer.teditor.data.DataViewerPanel;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModel;
import oracle.dmt.dataminer.teditor.data.ODMrSortColumnPicker;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQueryPreferences;
import oracle.dmt.dataminer.workflow.parallelquery.ViewDataParallelPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;

public class DataEditor
extends AbstractDataEditor
implements Controller {
    private static final Logger theLogger = Logger.getLogger(DataEditor.class.getName());
    final JButton parallelViewDialog = new JButton();
    private Toolbar _toolBar;
    private JComboBox _datasourceComboBox;
    private JLabel _datasourcelabel;
    private JButton _sortButton = new JButton();
    private JButton _refreshButton = new JButton();
    private JLabel filterLabel;
    private JTextField filter;
    private static final String DEFAULT_FILTER_TEXT = DataLrb.get("DATA_VIEWER_FILTER_WHERE_CLAUSE");
    private ODMrSortColumnPicker _sortPanel;
    private String _APPLYSORT = DataLrb.get("DATA_VIEWER_DATAED_APPLYSORT");
    private BlockingComponent overLayPanel = null;

    public BlockingComponent getOverLayPanel() {
        return this.overLayPanel;
    }

    public DataEditor() throws Exception {
        this._context = this.getContext();
        this.createActions();
        this.filterLabel = new JLabel();
        this.filter = new JTextField(DEFAULT_FILTER_TEXT);
        this.filter.setForeground(this.filter.getDisabledTextColor());
        ResourceUtils.resLabel((JLabel)this.filterLabel, (Component)this.filter, (String)DataLrb.get("DATA_VIEWER_FILTER_LABEL"));
        this.filterLabel.getAccessibleContext().setAccessibleDescription(DataLrb.get("DATA_VIEWER_FILTER_LABEL_ADA"));
        this.filterLabel.setToolTipText(DataLrb.get("DATA_VIEWER_FILTER_LABEL_ADA"));
        this.filter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n' && DataEditor.this._gui != null) {
                    ((DataViewerPanel)DataEditor.this._gui).getTableData().setWhere(DataEditor.this.filter.getText());
                    ((DataViewerPanel)DataEditor.this._gui).sort2();
                }
            }
        });
        this.filter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (DataEditor.this.filter.getText().trim().toUpperCase().equals(DEFAULT_FILTER_TEXT.toUpperCase())) {
                    DataEditor.this.filter.setText("");
                    DataEditor.this.filter.setForeground(DataEditor.this.filter.getCaretColor());
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ODMrResultSetTableModel oDMrResultSetTableModel;
                if (DataEditor.this.filter.getText().equals("")) {
                    DataEditor.this.filter.setText(DEFAULT_FILTER_TEXT);
                    DataEditor.this.filter.setForeground(DataEditor.this.filter.getDisabledTextColor());
                    if (DataEditor.this._gui != null) {
                        ((DataViewerPanel)DataEditor.this._gui).getTableData().setWhere("");
                        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                        if (editor != null && editor.getContext() != null && editor instanceof DataEditor) {
                            ((DataViewerPanel)DataEditor.this._gui).sort2();
                        }
                    }
                } else if (!DataEditor.this.filter.getText().trim().toUpperCase().equals(DEFAULT_FILTER_TEXT.toUpperCase()) && DataEditor.this._gui != null && (oDMrResultSetTableModel = ((DataViewerPanel)DataEditor.this._gui).getTableData().getMdl()) != null && !oDMrResultSetTableModel.isErrorCondition()) {
                    ((DataViewerPanel)DataEditor.this._gui).getTableData().setWhere(DataEditor.this.filter.getText());
                    Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                    if (editor != null && editor.getContext() != null && editor instanceof DataEditor) {
                        ((DataViewerPanel)DataEditor.this._gui).sort2();
                    }
                }
            }
        });
    }

    public void initialize() {
        this._context = this.getContext();
    }

    @Override
    public void open() {
        super.open();
        this.updateParallelViewBtnTitle();
    }

    @Override
    public void editorShown() {
        super.editorShown();
        this.updateParallelViewBtnTitle();
    }

    @Override
    public void close() {
        super.close();
        ((DataViewerPanel)this._gui).close();
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this._gui != null) {
            if (this.isCacheTableAvailable()) {
                String string = GraphUtils.getSampleTableName(this.getContext());
                if (string != null && !string.equals("")) {
                    ((DataViewerPanel)this._gui).getState().setCacheTableName(string);
                    this._datasourceComboBox.setSelectedItem((Object)DataSourceViewOption.CACHE);
                    this._datasourceComboBox.setEnabled(true);
                }
            } else if (this.showCombo()) {
                this._datasourceComboBox.setSelectedItem((Object)DataSourceViewOption.ACTUAL);
                this._datasourceComboBox.setEnabled(false);
            }
        }
    }

    @Override
    public ContextMenuListener getContextMenuListener() {
        return null;
    }

    @Override
    public Component getGUI() {
        try {
            if (this._gui == null) {
                this._gui = new DataViewerPanel(this, this.getContext());
                if (this.overLayPanel == null) {
                    this.overLayPanel = new BlockingComponent((JComponent)this._gui);
                    this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
                    this.overLayPanel.setMessage(BlockingComponent.Message.LOADING);
                    ((DataViewerPanel)this._gui).setBlockingComponent(this.overLayPanel);
                }
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return this.overLayPanel.getBlockingComponent();
    }

    public HelpInfo getHelpInfo() {
        assert (this._gui != null) : "getHelpInfo can not be called if _gui has not been loaded.";
        return ((DataViewerPanel)this._gui).getHelpInfo();
    }

    public Toolbar getToolbar() {
        return this._toolBar;
    }

    private boolean showCombo() {
        Node node = this._context.getNode();
        return !(node instanceof DataProfilePhysicalNode);
    }

    private boolean isCacheTableAvailable() {
        DataNode dataNode;
        boolean bl = false;
        Node node = this._context.getNode();
        if (node instanceof DataNode && (dataNode = (DataNode)node).getCacheTableName().length() > 0) {
            bl = true;
        }
        return bl;
    }

    public Component getFixedTopMargin() {
        if (this._toolBar == null) {
            this._toolBar = new Toolbar();
            this._refreshButton.setIcon(OracleIcons.getIcon((String)"refresh.png"));
            this._refreshButton.getAccessibleContext().setAccessibleDescription(DataLrb.get("DATA_VIEWER_REFRESH_BUTTON_ADA"));
            this._refreshButton.setToolTipText(DataLrb.get("DATA_VIEWER_REFRESH_BUTTON_ADA"));
            this._refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((DataViewerPanel)DataEditor.this._gui).getTableData().isOperationInprogress();
                    if (!bl) {
                        DataEditor.this.applySort();
                    }
                }
            });
            this._toolBar.add((Component)this._refreshButton);
            this._toolBar.addSeparator();
            if (this.showCombo()) {
                this._datasourcelabel = new JLabel();
                this._datasourceComboBox = new JComboBox();
                ResourceUtils.resLabel((JLabel)this._datasourcelabel, (Component)this._datasourceComboBox, (String)DataLrb.get("DATA_VIEWER_DATASOURCE_SELECTION_LABEL"));
                this._datasourcelabel.getAccessibleContext().setAccessibleDescription(DataLrb.get("DATA_VIEWER_DATASOURCE_SELECTION_LABEL_ADA"));
                this._datasourceComboBox.setToolTipText(DataLrb.get("DATA_VIEWER_DATASOURCE_SELECTION_LABEL_ADA"));
                this._toolBar.add((Component)this._datasourcelabel);
                this._datasourceComboBox.setModel(new DefaultComboBoxModel<DataSourceViewOption>(DataSourceViewOption.values()));
                if (this.isCacheTableAvailable()) {
                    this._datasourceComboBox.setSelectedItem((Object)DataSourceViewOption.CACHE);
                    this._datasourceComboBox.setEnabled(true);
                } else {
                    this._datasourceComboBox.setSelectedItem((Object)DataSourceViewOption.ACTUAL);
                    this._datasourceComboBox.setEnabled(false);
                }
                this._toolBar.add((Component)this._datasourceComboBox);
                this._toolBar.addSeparator();
                this._datasourceComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DataEditor.this._datasourceComboBox_actionPerformed(actionEvent);
                    }
                });
            }
            ResourceUtils.resButton((AbstractButton)this._sortButton, (String)DataLrb.get("DATA_VIEWER_SORT_BUTTON"));
            this._sortButton.getAccessibleContext().setAccessibleDescription(DataLrb.get("DATA_VIEWER_SORT_BUTTON_ADA"));
            this._sortButton.setToolTipText(DataLrb.get("DATA_VIEWER_SORT_BUTTON_ADA"));
            this._sortButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((DataViewerPanel)DataEditor.this._gui).getTableData().isOperationInprogress();
                    if (!bl) {
                        DataEditor.this.initSortPanel();
                        DataEditor.this.sortData();
                    }
                }
            });
            this.updateParallelViewBtnTitle();
            this.parallelViewDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final ViewDataParallelPanel viewDataParallelPanel = new ViewDataParallelPanel(DataLrb.get("DATA_VIEWER_PARALLEL_DIALOG_TITLE"));
                    viewDataParallelPanel.setHandler(new DialogDisplayer.DialogHandler(){

                        @Override
                        public boolean doWork() {
                            viewDataParallelPanel.updatePreferences();
                            DataEditor.this.updateParallelViewBtnTitle();
                            return true;
                        }
                    });
                    viewDataParallelPanel.showAsDialog();
                }
            });
            this._toolBar.add((Component)this._sortButton);
            this._toolBar.addSeparator();
            this._toolBar.add((Component)this.parallelViewDialog);
            this._toolBar.addSeparator();
            this._toolBar.add((Component)this.filterLabel);
            this._toolBar.add((Component)this.filter);
            this.filter.setSize(200, 0);
        }
        return this._toolBar;
    }

    @Override
    public void updateParallelViewBtnTitle() {
        String string = parallelQueryPreferences.getViewDataProperty(ViewDataParallelPanel.VIEW_KEY, ParallelQueryPreferences.PROPERTY.IS_PARALLEL);
        if (string == null || !Boolean.parseBoolean(string)) {
            this.parallelViewDialog.setText(DataLrb.get("DATA_VIEWER_PARALLEL_OFF"));
        } else {
            this.parallelViewDialog.setText(DataLrb.get("DATA_VIEWER_PARALLEL_ON"));
        }
        if (this._gui != null && ((DataViewerPanel)this._gui).getState() != null) {
            String string2 = ((DataViewerPanel)this._gui).getState().getQuery();
            if (string2 == null) {
                string2 = "SELECT '" + DataLrb.get("DATA_VIEWER_ACTUAL_NO_QUERY_AVAILABLE") + "' as MESSAGE FROM DUAL";
            }
            if (((DataViewerPanel)this._gui).getState().getResultSetModel() != null) {
                ((DataViewerPanel)this._gui).getState().getResultSetModel().setSql(string2);
            }
        }
    }

    private void _datasourceComboBox_actionPerformed(ActionEvent actionEvent) {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        DataSourceViewOption dataSourceViewOption = (DataSourceViewOption)((Object)this._datasourceComboBox.getSelectedItem());
        try {
            ((DataViewerPanel)this._gui).setDataSourceViewOption(dataSourceViewOption);
        }
        catch (Exception exception) {
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
            }
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), null);
        }
        boolean bl = ((DataViewerPanel)this._gui).getTableData().isOperationInprogress();
        if (!bl) {
            ((DataViewerPanel)this._gui).reloadUI();
        }
    }

    private void createActions() {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    void updateToolbar() {
        View.updateToolbarActions((Toolbar)this._toolBar);
    }

    private void initSortPanel() {
        if (this._sortPanel != null && !this._sortPanel.isFromListEmpty()) {
            return;
        }
        this._sortPanel = new ODMrSortColumnPicker();
        int n = ((DataViewerPanel)this._gui).getTableData().getColumnCount();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i <= n; ++i) {
            String string = ((DataViewerPanel)this._gui).getTableData().getColumnDBName(i - 1);
            if (string == null) continue;
            arrayList.add(string);
        }
        this._sortPanel.init(arrayList.toArray(new String[arrayList.size()]));
    }

    private void sortData() {
        Object[] objectArray = new Object[]{this._APPLYSORT, DataLrb.get("DATA_VIEWER_DATAED_CANCEL")};
        JOptionPane jOptionPane = new JOptionPane(null, -1, 0, null, objectArray, objectArray[0]);
        jOptionPane.add(this._sortPanel);
        ArrayList arrayList = this._sortPanel.getToList();
        ArrayList arrayList2 = this._sortPanel.getFromList();
        JDialog jDialog = jOptionPane.createDialog((Component)Ide.getMainWindow(), DataLrb.get("DATA_VIEWER_DATAED_SORT_TITLE"));
        jDialog.setSize(new Dimension(500, 400));
        jDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
        jDialog.setVisible(true);
        if (jOptionPane.getValue() != null && jOptionPane.getValue().equals(this._APPLYSORT)) {
            this.applySort();
        } else {
            this._sortPanel.setToList(arrayList);
            this._sortPanel.setFromList(arrayList2);
        }
    }

    private void applySort() {
        if (this._sortPanel != null) {
            ((DataViewerPanel)this._gui).getTableData().setOrderBy(this._sortPanel.getOrderBy());
        }
        ((DataViewerPanel)this._gui).getTableData().setWhere(this.filter.getText().trim().toUpperCase().equals(DEFAULT_FILTER_TEXT.toUpperCase()) ? "" : this.filter.getText());
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        ((DataViewerPanel)this._gui).sort2();
    }
}

