/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.ai;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.dmt.dataminer.teditor.AbstractDataEditor;
import oracle.dmt.dataminer.teditor.ai.AIViewerPanel;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.help.HelpInfo;
import oracle.javatools.ui.BlockingComponent;

public class AIEditor
extends AbstractDataEditor {
    private static final Logger LOGGER = Logger.getLogger(AIEditor.class.getName());
    private BlockingComponent overLayPanel = null;

    public AIEditor() {
        this._context = this.getContext();
    }

    public void initialize() {
        this._context = this.getContext();
    }

    @Override
    public void refresh() {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        super.refresh();
        if (this._gui != null) {
            ((AIViewerPanel)this._gui).reload();
        }
    }

    @Override
    public ContextMenuListener getContextMenuListener() {
        return null;
    }

    @Override
    public Component getGUI() {
        try {
            if (this._gui == null) {
                this._gui = new AIViewerPanel(this, this.getContext());
                if (this.overLayPanel == null) {
                    this.overLayPanel = new BlockingComponent((JComponent)this._gui);
                    this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
                    this.overLayPanel.setMessage(BlockingComponent.Message.LOADING);
                    ((AIViewerPanel)this._gui).setBlockingComponent(this.overLayPanel);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return this.overLayPanel.getBlockingComponent();
    }

    public HelpInfo getHelpInfo() {
        assert (this._gui != null) : "getHelpInfo can not be called if _gui has not been loaded.";
        return ((AIViewerPanel)this._gui).getHelpInfo();
    }
}

