/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.server.ServerConstantsLrb;
import oracle.dmt.dataminer.server.model.MiningAlgorithmOptions;
import oracle.dmt.dataminer.server.model.MiningDetailsModelType;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.utils.comparator.ToStringComparator;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;

public enum MiningDetailsOutputType {
    RULES(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_RULES")),
    ITEM_SETS(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_ITEM_SETS")),
    FULL_TREE(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_FULL_TREE")),
    FULL_TREE_XML(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_FULL_TREE_XML")),
    GLOBAL_DETAILS(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_GLOBAL_DETAILS")),
    LEAF_NODES(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_LEAF_NODES")),
    COEFFICIENTS(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_COEFFICIENTS")),
    ROW_DIAGNOSTICS(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_ROW_DIAGNOSTICS")),
    PAIR_PROBABILITIES(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_PAIR_PROB")),
    ATTRIBUTE_HISTOGRAMS(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_ATTRIBUTE_HISTOGRAMS")),
    COMPONENTS(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_COMPONENTS")),
    PROJECTIONS(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_PROJECTIONS")),
    FEATURES_TRANSACTIONAL(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_NMF_TRANSACTIONAL")),
    EIGENVALUES(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_EIGENVALUES")),
    SINGULAR_VALUES(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_SINGULAR_VALUES")),
    CENTROID(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_CENTROID")),
    SCORING_SIGNATURE(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_MODEL_SIGNATURE")),
    STATISTICS(ServerConstantsLrb.get("MODEL_DETAILS_OUTPUT_TYPE_STATISTICS"));

    private final String translation;
    private static final Map<String, MiningDetailsOutputType> stringToEnum;

    private MiningDetailsOutputType(String string2) {
        this.translation = string2;
    }

    public static MiningDetailsOutputType fromString(String string) {
        return stringToEnum.get(string);
    }

    public String toString() {
        return this.translation;
    }

    public static Vector<MiningDetailsOutputType> getMiningDetailsOutputType(MiningDetailsModelType miningDetailsModelType) {
        Vector<MiningDetailsOutputType> vector = new Vector<MiningDetailsOutputType>();
        if (miningDetailsModelType.equals((Object)MiningDetailsModelType.ANOMALY_DETECTION) || miningDetailsModelType.equals((Object)MiningDetailsModelType.SVM_CLASSIFICATION) || miningDetailsModelType.equals((Object)MiningDetailsModelType.SVM_REGRESSION)) {
            vector.add(COEFFICIENTS);
        } else if (miningDetailsModelType.equals((Object)MiningDetailsModelType.DECISION_TREE)) {
            vector.add(FULL_TREE);
            vector.add(FULL_TREE_XML);
            vector.add(LEAF_NODES);
        } else if (miningDetailsModelType.equals((Object)MiningDetailsModelType.GLM_CLASSIFICATION) || miningDetailsModelType.equals((Object)MiningDetailsModelType.GLM_REGRESSION)) {
            vector.add(STATISTICS);
            vector.add(ROW_DIAGNOSTICS);
            vector.add(GLOBAL_DETAILS);
        } else if (miningDetailsModelType.equals((Object)MiningDetailsModelType.ASSOCIATION)) {
            vector.add(RULES);
            vector.add(ITEM_SETS);
            vector.add(GLOBAL_DETAILS);
        } else if (miningDetailsModelType.equals((Object)MiningDetailsModelType.CLUSTERING)) {
            vector.add(FULL_TREE);
            vector.add(RULES);
            vector.add(ATTRIBUTE_HISTOGRAMS);
        } else if (miningDetailsModelType.equals((Object)MiningDetailsModelType.FEATURE_EXTRACTION)) {
            vector.add(FEATURES_TRANSACTIONAL);
        } else if (miningDetailsModelType.equals((Object)MiningDetailsModelType.SCORING_MODELS)) {
            vector.add(SCORING_SIGNATURE);
        } else if (miningDetailsModelType.equals((Object)MiningDetailsModelType.EM_CLUSTERING)) {
            vector.add(FULL_TREE);
            vector.add(RULES);
            vector.add(COMPONENTS);
            vector.add(PROJECTIONS);
            vector.add(GLOBAL_DETAILS);
            vector.add(ATTRIBUTE_HISTOGRAMS);
        }
        Collections.sort(vector, ToStringComparator.getComparator());
        return vector;
    }

    public static MiningDetailsOutputType getPreferredOutputTypeForModelDetailsNode(MiningFunctions miningFunctions, MiningAlgorithmOptions miningAlgorithmOptions) {
        MiningDetailsOutputType miningDetailsOutputType = null;
        if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SUPPORT_VECTOR_MACHINE)) {
            miningDetailsOutputType = COEFFICIENTS;
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.NAIVE_BAYES)) {
            miningDetailsOutputType = PAIR_PROBABILITIES;
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.DECISION_TREE)) {
            miningDetailsOutputType = FULL_TREE;
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.GENERALIZED_LINEAR_MODEL)) {
            miningDetailsOutputType = STATISTICS;
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.APRIORI)) {
            miningDetailsOutputType = RULES;
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.KMEANS) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.EXPECTATION_MAXIMIZATION) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.OCLUSTER) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.ALL) && miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            miningDetailsOutputType = FULL_TREE;
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.NON_NEGATIVE_MATRIX_FACTORIZATION) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.PRINCIPAL_COMPONENT_ANALYSIS) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SINGULAR_VALUE_DECOMP) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.ALL) && miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION)) {
            miningDetailsOutputType = FEATURES_TRANSACTIONAL;
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.ALL) && (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION) || miningFunctions.equals((Object)MiningFunctions.REGRESSION))) {
            miningDetailsOutputType = SCORING_SIGNATURE;
        }
        return miningDetailsOutputType;
    }

    public static Vector<MiningDetailsOutputType> getMiningDetailsOutputType(MiningFunctions miningFunctions, MiningAlgorithmOptions miningAlgorithmOptions) {
        Vector<MiningDetailsOutputType> vector = new Vector<MiningDetailsOutputType>();
        if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SUPPORT_VECTOR_MACHINE) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.ALL) && miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION)) {
            vector.add(COEFFICIENTS);
            vector.add(SCORING_SIGNATURE);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.NAIVE_BAYES)) {
            vector.add(PAIR_PROBABILITIES);
            vector.add(SCORING_SIGNATURE);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.DECISION_TREE)) {
            vector.add(FULL_TREE);
            vector.add(FULL_TREE_XML);
            vector.add(LEAF_NODES);
            vector.add(SCORING_SIGNATURE);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.GENERALIZED_LINEAR_MODEL)) {
            vector.add(STATISTICS);
            vector.add(ROW_DIAGNOSTICS);
            vector.add(SCORING_SIGNATURE);
            vector.add(GLOBAL_DETAILS);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.APRIORI)) {
            vector.add(RULES);
            vector.add(ITEM_SETS);
            vector.add(GLOBAL_DETAILS);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.KMEANS) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.OCLUSTER) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.ALL) && miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            vector.add(FULL_TREE);
            vector.add(RULES);
            vector.add(CENTROID);
            vector.add(ATTRIBUTE_HISTOGRAMS);
            vector.add(SCORING_SIGNATURE);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.EXPECTATION_MAXIMIZATION)) {
            vector.add(FULL_TREE);
            vector.add(RULES);
            vector.add(CENTROID);
            vector.add(COMPONENTS);
            vector.add(PROJECTIONS);
            vector.add(ATTRIBUTE_HISTOGRAMS);
            vector.add(GLOBAL_DETAILS);
            vector.add(SCORING_SIGNATURE);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.NON_NEGATIVE_MATRIX_FACTORIZATION) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.ALL) && miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION)) {
            vector.add(FEATURES_TRANSACTIONAL);
            vector.add(SCORING_SIGNATURE);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.PRINCIPAL_COMPONENT_ANALYSIS)) {
            vector.add(FEATURES_TRANSACTIONAL);
            vector.add(SCORING_SIGNATURE);
            vector.add(GLOBAL_DETAILS);
            vector.add(PROJECTIONS);
            vector.add(EIGENVALUES);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SINGULAR_VALUE_DECOMP)) {
            vector.add(FEATURES_TRANSACTIONAL);
            vector.add(SCORING_SIGNATURE);
            vector.add(GLOBAL_DETAILS);
            vector.add(PROJECTIONS);
            vector.add(SINGULAR_VALUES);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.ALL) && (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION) || miningFunctions.equals((Object)MiningFunctions.REGRESSION) || miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION) || miningFunctions.equals((Object)MiningFunctions.CLUSTERING) || miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION))) {
            vector.add(SCORING_SIGNATURE);
        }
        Collections.sort(vector, ToStringComparator.getComparator());
        return vector;
    }

    public static MiningDetailsOutputType getMiningDetailsOutputType(ModelDetailType modelDetailType) {
        MiningDetailsOutputType miningDetailsOutputType = null;
        if (modelDetailType == null) {
            return null;
        }
        miningDetailsOutputType = modelDetailType.equals((Object)ModelDetailType.AD_COEFFICIENTS) ? COEFFICIENTS : (modelDetailType.equals((Object)ModelDetailType.AR_FREQUENT_ITEM_SETS_TRANSACTIONAL_VERSION) ? ITEM_SETS : (modelDetailType.equals((Object)ModelDetailType.AR_RULES_STRING_VERSION) ? RULES : (modelDetailType.equals((Object)ModelDetailType.CLUSTER_ATTRIBUTE_HISTOGRAMS) ? ATTRIBUTE_HISTOGRAMS : (modelDetailType.equals((Object)ModelDetailType.CLUSTER_DETAILS) ? FULL_TREE : (modelDetailType.equals((Object)ModelDetailType.CLUSTER_RULES) ? RULES : (modelDetailType.equals((Object)ModelDetailType.CENTROIDS) ? CENTROID : (modelDetailType.equals((Object)ModelDetailType.EM_COMPONENTS) ? COMPONENTS : (modelDetailType.equals((Object)ModelDetailType.EM_PROJECTIONS) ? PROJECTIONS : (modelDetailType.equals((Object)ModelDetailType.DT_FULL_TREE) ? FULL_TREE : (modelDetailType.equals((Object)ModelDetailType.DT_FULL_TREE_XML_VERSION) ? FULL_TREE_XML : (modelDetailType.equals((Object)ModelDetailType.DT_LEAF_NODES_ONLY) ? LEAF_NODES : (modelDetailType.equals((Object)ModelDetailType.GLMC_COEFFICIENTS_AND_STATISTICS) ? STATISTICS : (modelDetailType.equals((Object)ModelDetailType.GLMC_ROW_DIAGNOSTICS) ? ROW_DIAGNOSTICS : (modelDetailType.equals((Object)ModelDetailType.GLMR_COEFFICIENTS_AND_STATISTICS) ? STATISTICS : (modelDetailType.equals((Object)ModelDetailType.GLMR_ROW_DIAGNOSTICS) ? ROW_DIAGNOSTICS : (modelDetailType.equals((Object)ModelDetailType.MODEL_SIGNATURE) ? SCORING_SIGNATURE : (modelDetailType.equals((Object)ModelDetailType.NB_PAIR_PROBABILITIES) ? PAIR_PROBABILITIES : (modelDetailType.equals((Object)ModelDetailType.NMF_DETAILS_TRANSACTIONAL_VERSION) ? FEATURES_TRANSACTIONAL : (modelDetailType.equals((Object)ModelDetailType.PCA_EIGENVALUES) ? EIGENVALUES : (modelDetailType.equals((Object)ModelDetailType.SVD_SINGULAR_VALUES) ? SINGULAR_VALUES : (modelDetailType.equals((Object)ModelDetailType.FEATURE_PROJECTIONS) ? PROJECTIONS : (modelDetailType.equals((Object)ModelDetailType.SVMC_COEFFICIENTS) ? COEFFICIENTS : (modelDetailType.equals((Object)ModelDetailType.SVMR_COEFFICIENTS) ? COEFFICIENTS : (modelDetailType.equals((Object)ModelDetailType.GLOBAL_DETAILS) ? GLOBAL_DETAILS : null))))))))))))))))))))))));
        return miningDetailsOutputType;
    }

    public static List<MiningAlgorithmType> getMiningAlgorithms(ModelDetailType modelDetailType) {
        ArrayList<MiningAlgorithmType> arrayList = new ArrayList<MiningAlgorithmType>();
        Object var2_2 = null;
        if (modelDetailType == null) {
            return arrayList;
        }
        if (modelDetailType.equals((Object)ModelDetailType.AD_COEFFICIENTS)) {
            arrayList.add(MiningAlgorithmType.SUPPORT_VECTOR_MACHINES);
        } else if (modelDetailType.equals((Object)ModelDetailType.AR_FREQUENT_ITEM_SETS_DM_ITEM_VERSION) || modelDetailType.equals((Object)ModelDetailType.AR_FREQUENT_ITEM_SETS_TRANSACTIONAL_VERSION) || modelDetailType.equals((Object)ModelDetailType.AR_RULES_DM_PREDICATE_VERSION) || modelDetailType.equals((Object)ModelDetailType.AR_RULES_STRING_VERSION)) {
            arrayList.add(MiningAlgorithmType.APRIORI_ASSOCIATION_RULES);
        } else if (modelDetailType.equals((Object)ModelDetailType.CLUSTER_ALL) || modelDetailType.equals((Object)ModelDetailType.CLUSTER_ATTRIBUTE_HISTOGRAMS) || modelDetailType.equals((Object)ModelDetailType.CLUSTER_DETAILS) || modelDetailType.equals((Object)ModelDetailType.CLUSTER_RULES) || modelDetailType.equals((Object)ModelDetailType.CENTROIDS)) {
            arrayList.add(MiningAlgorithmType.KMEANS);
            arrayList.add(MiningAlgorithmType.EXPECTATION_MAXIMIZATION);
            arrayList.add(MiningAlgorithmType.O_CLUSTER);
        } else if (modelDetailType.equals((Object)ModelDetailType.EM_COMPONENTS) || modelDetailType.equals((Object)ModelDetailType.EM_PROJECTIONS)) {
            arrayList.add(MiningAlgorithmType.EXPECTATION_MAXIMIZATION);
        } else if (modelDetailType.equals((Object)ModelDetailType.DT_FULL_TREE) || modelDetailType.equals((Object)ModelDetailType.DT_FULL_TREE_XML_VERSION) || modelDetailType.equals((Object)ModelDetailType.DT_LEAF_NODES_ONLY) || modelDetailType.equals((Object)ModelDetailType.DT_LEAF_NODES_ONLY_PROFILE_VERSION)) {
            arrayList.add(MiningAlgorithmType.DECISION_TREE);
        } else if (modelDetailType.equals((Object)ModelDetailType.GLMC_COEFFICIENTS_AND_STATISTICS) || modelDetailType.equals((Object)ModelDetailType.GLMC_ROW_DIAGNOSTICS) || modelDetailType.equals((Object)ModelDetailType.GLMR_COEFFICIENTS_AND_STATISTICS) || modelDetailType.equals((Object)ModelDetailType.GLMR_ROW_DIAGNOSTICS)) {
            arrayList.add(MiningAlgorithmType.GENERALIZED_LINEAR_MODEL);
        } else if (modelDetailType.equals((Object)ModelDetailType.MODEL_SIGNATURE)) {
            arrayList.add(MiningAlgorithmType.DECISION_TREE);
            arrayList.add(MiningAlgorithmType.SUPPORT_VECTOR_MACHINES);
            arrayList.add(MiningAlgorithmType.EXPECTATION_MAXIMIZATION);
            arrayList.add(MiningAlgorithmType.KMEANS);
            arrayList.add(MiningAlgorithmType.O_CLUSTER);
            arrayList.add(MiningAlgorithmType.GENERALIZED_LINEAR_MODEL);
            arrayList.add(MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR);
            arrayList.add(MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS);
            arrayList.add(MiningAlgorithmType.SINGULAR_VALUE_DECOMP);
            arrayList.add(MiningAlgorithmType.NAIVE_BAYES);
        } else if (modelDetailType.equals((Object)ModelDetailType.NB_PAIR_PROBABILITIES)) {
            arrayList.add(MiningAlgorithmType.NAIVE_BAYES);
        } else if (modelDetailType.equals((Object)ModelDetailType.NMF_DETAILS_TRANSACTIONAL_VERSION)) {
            arrayList.add(MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR);
            arrayList.add(MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS);
            arrayList.add(MiningAlgorithmType.SINGULAR_VALUE_DECOMP);
        } else if (modelDetailType.equals((Object)ModelDetailType.PCA_EIGENVALUES)) {
            arrayList.add(MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS);
        } else if (modelDetailType.equals((Object)ModelDetailType.SVD_SINGULAR_VALUES)) {
            arrayList.add(MiningAlgorithmType.SINGULAR_VALUE_DECOMP);
        } else if (modelDetailType.equals((Object)ModelDetailType.SVMC_COEFFICIENTS) || modelDetailType.equals((Object)ModelDetailType.SVMR_COEFFICIENTS)) {
            arrayList.add(MiningAlgorithmType.SUPPORT_VECTOR_MACHINES);
        } else if (modelDetailType.equals((Object)ModelDetailType.GLOBAL_DETAILS)) {
            arrayList.add(MiningAlgorithmType.GENERALIZED_LINEAR_MODEL);
            arrayList.add(MiningAlgorithmType.EXPECTATION_MAXIMIZATION);
            arrayList.add(MiningAlgorithmType.APRIORI_ASSOCIATION_RULES);
        }
        return arrayList;
    }

    public static ModelDetailType getMiningDetailType(MiningDetailsOutputType miningDetailsOutputType, MiningAlgorithmOptions miningAlgorithmOptions, MiningFunctions miningFunctions) {
        ModelDetailType modelDetailType = null;
        if (miningDetailsOutputType.equals((Object)ATTRIBUTE_HISTOGRAMS)) {
            modelDetailType = ModelDetailType.CLUSTER_ATTRIBUTE_HISTOGRAMS;
        } else if (miningDetailsOutputType.equals((Object)RULES) && miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            modelDetailType = ModelDetailType.CLUSTER_RULES;
        } else if (miningDetailsOutputType.equals((Object)FULL_TREE) && miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            modelDetailType = ModelDetailType.CLUSTER_DETAILS;
        } else if (miningDetailsOutputType.equals((Object)CENTROID) && miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            modelDetailType = ModelDetailType.CENTROIDS;
        } else if (miningDetailsOutputType.equals((Object)COMPONENTS)) {
            modelDetailType = ModelDetailType.EM_COMPONENTS;
        } else if (miningDetailsOutputType.equals((Object)PROJECTIONS) && miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.EXPECTATION_MAXIMIZATION)) {
            modelDetailType = ModelDetailType.EM_PROJECTIONS;
        } else if (miningDetailsOutputType.equals((Object)PROJECTIONS) && (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.PRINCIPAL_COMPONENT_ANALYSIS) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SINGULAR_VALUE_DECOMP))) {
            modelDetailType = ModelDetailType.FEATURE_PROJECTIONS;
        } else if (miningDetailsOutputType.equals((Object)COEFFICIENTS) && miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SUPPORT_VECTOR_MACHINE)) {
            if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
                modelDetailType = ModelDetailType.SVMC_COEFFICIENTS;
            } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
                modelDetailType = ModelDetailType.SVMC_COEFFICIENTS;
            } else if (miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION)) {
                modelDetailType = ModelDetailType.SVMC_COEFFICIENTS;
            }
        } else if (miningDetailsOutputType.equals((Object)FEATURES_TRANSACTIONAL)) {
            modelDetailType = ModelDetailType.NMF_DETAILS_TRANSACTIONAL_VERSION;
        } else if (miningDetailsOutputType.equals((Object)SINGULAR_VALUES)) {
            modelDetailType = ModelDetailType.SVD_SINGULAR_VALUES;
        } else if (miningDetailsOutputType.equals((Object)EIGENVALUES)) {
            modelDetailType = ModelDetailType.PCA_EIGENVALUES;
        } else if (miningDetailsOutputType.equals((Object)FULL_TREE) && miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.DECISION_TREE)) {
            modelDetailType = ModelDetailType.DT_FULL_TREE;
        } else if (miningDetailsOutputType.equals((Object)FULL_TREE_XML) && miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.DECISION_TREE)) {
            modelDetailType = ModelDetailType.DT_FULL_TREE_XML_VERSION;
        } else if (miningDetailsOutputType.equals((Object)LEAF_NODES) && miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.DECISION_TREE)) {
            modelDetailType = ModelDetailType.DT_LEAF_NODES_ONLY;
        } else if (miningDetailsOutputType.equals((Object)ITEM_SETS)) {
            modelDetailType = ModelDetailType.AR_FREQUENT_ITEM_SETS_TRANSACTIONAL_VERSION;
        } else if (miningDetailsOutputType.equals((Object)PAIR_PROBABILITIES)) {
            modelDetailType = ModelDetailType.NB_PAIR_PROBABILITIES;
        } else if (miningDetailsOutputType.equals((Object)ROW_DIAGNOSTICS)) {
            if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
                modelDetailType = ModelDetailType.GLMC_ROW_DIAGNOSTICS;
            } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
                modelDetailType = ModelDetailType.GLMR_ROW_DIAGNOSTICS;
            }
        } else if (miningDetailsOutputType.equals((Object)RULES)) {
            modelDetailType = ModelDetailType.AR_RULES_STRING_VERSION;
        } else if (miningDetailsOutputType.equals((Object)SCORING_SIGNATURE)) {
            modelDetailType = ModelDetailType.MODEL_SIGNATURE;
        } else if (miningDetailsOutputType.equals((Object)STATISTICS)) {
            if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
                modelDetailType = ModelDetailType.GLMC_COEFFICIENTS_AND_STATISTICS;
            } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
                modelDetailType = ModelDetailType.GLMR_COEFFICIENTS_AND_STATISTICS;
            }
        } else if (miningDetailsOutputType.equals((Object)GLOBAL_DETAILS)) {
            if ((miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION) || miningFunctions.equals((Object)MiningFunctions.REGRESSION)) && miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.GENERALIZED_LINEAR_MODEL)) {
                modelDetailType = ModelDetailType.GLOBAL_DETAILS;
            } else if (miningFunctions.equals((Object)MiningFunctions.ASSOCIATION_RULES)) {
                modelDetailType = ModelDetailType.GLOBAL_DETAILS;
            } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.EXPECTATION_MAXIMIZATION) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SINGULAR_VALUE_DECOMP) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.PRINCIPAL_COMPONENT_ANALYSIS)) {
                modelDetailType = ModelDetailType.GLOBAL_DETAILS;
            }
        }
        return modelDetailType;
    }

    static {
        stringToEnum = new HashMap<String, MiningDetailsOutputType>();
        for (MiningDetailsOutputType miningDetailsOutputType : MiningDetailsOutputType.values()) {
            stringToEnum.put(miningDetailsOutputType.toString(), miningDetailsOutputType);
        }
    }
}

