/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.server.ServerConstantsLrb;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.utils.comparator.ToStringComparator;

public enum MiningDetailsModelType {
    ASSOCIATION(ServerConstantsLrb.get("MODEL_DETAILS_MODEL_TYPE_ASSOCIATION")),
    ANOMALY_DETECTION(ServerConstantsLrb.get("MODEL_DETAILS_MODEL_TYPE_ANOMALY_DETECTION")),
    CLUSTERING(ServerConstantsLrb.get("MODEL_DETAILS_MODEL_TYPE_CLUSTERING")),
    EM_CLUSTERING(ServerConstantsLrb.get("MODEL_DETAILS_MODEL_TYPE_CLUSTERING")),
    DECISION_TREE(ServerConstantsLrb.get("MODEL_DETAILS_MODEL_TYPE_DECISION_TREE")),
    NAIVE_BAYES(ServerConstantsLrb.get("MODEL_DETAILS_MODEL_TYPE_NAIVE_BAYES")),
    SVM_CLASSIFICATION(ServerConstantsLrb.get("MODEL_DETAILS_MODEL_TYPE_SUPPORT_VECTOR_MACHINES_CLASSIFICAION")),
    SVM_REGRESSION(ServerConstantsLrb.get("MODEL_DETAILS_MODEL_TYPE_SUPPORT_VECTOR_MACHINES_REGRESSION")),
    GLM_CLASSIFICATION(ServerConstantsLrb.get("MODEL_DETAILS_MODEL_TYPE_GENERALIZED_LINEAR_CLASSIFICATION")),
    GLM_REGRESSION(ServerConstantsLrb.get("MODEL_DETAILS_MODEL_TYPE_GENERALIZED_LINEAR_REGRESSION")),
    FEATURE_EXTRACTION(ServerConstantsLrb.get("MODEL_DETAILS_MODEL_TYPE_FEATURE_EXTRACTION")),
    SVD_FEATURE_EXTRACTION(ServerConstantsLrb.get("MODEL_DETAILS_MODEL_TYPE_FEATURE_EXTRACTION")),
    SCORING_MODELS(ServerConstantsLrb.get("MODEL_DETAILS_MODEL_TYPE_SCORING_MODELS"));

    private final String translation;
    private static final Map<String, MiningDetailsModelType> stringToEnum;

    private MiningDetailsModelType(String string2) {
        this.translation = string2;
    }

    public static MiningDetailsModelType fromString(String string) {
        return stringToEnum.get(string);
    }

    public String toString() {
        return this.translation;
    }

    public static Vector<MiningDetailsModelType> getMiningDetailsTypeType(MiningFunctions miningFunctions) {
        Vector<MiningDetailsModelType> vector = new Vector<MiningDetailsModelType>();
        if (miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION)) {
            vector.add(ANOMALY_DETECTION);
        } else if (miningFunctions.equals((Object)MiningFunctions.ASSOCIATION_RULES)) {
            vector.add(ASSOCIATION);
        } else if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
            vector.add(DECISION_TREE);
            vector.add(GLM_CLASSIFICATION);
            vector.add(NAIVE_BAYES);
            vector.add(SVM_CLASSIFICATION);
            vector.add(SCORING_MODELS);
        } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
            vector.add(GLM_REGRESSION);
            vector.add(SVM_REGRESSION);
            vector.add(SCORING_MODELS);
        } else if (miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            vector.add(CLUSTERING);
        } else if (miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION)) {
            vector.add(FEATURE_EXTRACTION);
        }
        Collections.sort(vector, ToStringComparator.getComparator());
        return vector;
    }

    static {
        stringToEnum = new HashMap<String, MiningDetailsModelType>();
        for (MiningDetailsModelType miningDetailsModelType : MiningDetailsModelType.values()) {
            stringToEnum.put(miningDetailsModelType.toString(), miningDetailsModelType);
        }
    }
}

