/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.server.ServerConstantsLrb;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.utils.comparator.ToStringComparator;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.javatools.util.Version;

public enum MiningAlgorithmOptions {
    ALL(ServerConstantsLrb.get("ALGO_ALL_ALGORITHMS")),
    APRIORI(ServerConstantsLrb.get("ALGO_APRIORI_ASSOCIATION_RULES")),
    DECISION_TREE(ServerConstantsLrb.get("ALGO_DECISION_TREE")),
    GENERALIZED_LINEAR_MODEL(ServerConstantsLrb.get("ALGO_GENERALIZED_LINEAR_MODEL")),
    KMEANS(ServerConstantsLrb.get("ALGO_KMEANS")),
    NAIVE_BAYES(ServerConstantsLrb.get("ALGO_NAIVE_BAYES")),
    NON_NEGATIVE_MATRIX_FACTORIZATION(ServerConstantsLrb.get("ALGO_NONNEGATIVE_MATRIX_FACTOR")),
    SINGULAR_VALUE_DECOMP(ServerConstantsLrb.get("ALGO_SINGULAR_VALUE_DECOMP")),
    PRINCIPAL_COMPONENT_ANALYSIS(ServerConstantsLrb.get("ALGO_PRINCIPAL_COMPONENT_ANALYSIS")),
    OCLUSTER(ServerConstantsLrb.get("ALGO_O_CLUSTER")),
    EXPECTATION_MAXIMIZATION(ServerConstantsLrb.get("ALGO_EXPECTATION_MAXIMIZATION")),
    SUPPORT_VECTOR_MACHINE(ServerConstantsLrb.get("ALGO_SUPPORT_VECTOR_MACHINE"));

    private final String translation;
    private static final Map<String, MiningAlgorithmOptions> stringToEnum;

    private MiningAlgorithmOptions(String string2) {
        this.translation = string2;
    }

    public static MiningAlgorithmOptions fromString(String string) {
        return stringToEnum.get(string);
    }

    public String toString() {
        return this.translation;
    }

    public static Vector<MiningAlgorithmOptions> getMiningAlgorithmOptions(Version version, MiningFunctions miningFunctions) {
        if (version == null) {
            version = new Version("12.1");
        }
        Vector<MiningAlgorithmOptions> vector = new Vector<MiningAlgorithmOptions>();
        if (miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION)) {
            vector.add(SUPPORT_VECTOR_MACHINE);
        } else if (miningFunctions.equals((Object)MiningFunctions.ASSOCIATION_RULES)) {
            vector.add(APRIORI);
        } else if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
            vector.add(DECISION_TREE);
            vector.add(GENERALIZED_LINEAR_MODEL);
            vector.add(NAIVE_BAYES);
            vector.add(SUPPORT_VECTOR_MACHINE);
            vector.add(ALL);
        } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
            vector.add(GENERALIZED_LINEAR_MODEL);
            vector.add(SUPPORT_VECTOR_MACHINE);
            vector.add(ALL);
        } else if (miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            if (version.toCanonicalString().startsWith("12.")) {
                vector.add(EXPECTATION_MAXIMIZATION);
            }
            vector.add(KMEANS);
            vector.add(OCLUSTER);
            vector.add(ALL);
        } else if (miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION)) {
            vector.add(NON_NEGATIVE_MATRIX_FACTORIZATION);
            if (version.toCanonicalString().startsWith("12.")) {
                vector.add(SINGULAR_VALUE_DECOMP);
                vector.add(PRINCIPAL_COMPONENT_ANALYSIS);
            }
            vector.add(ALL);
        }
        Collections.sort(vector, ToStringComparator.getComparator());
        return vector;
    }

    public static MiningAlgorithmOptions getPreferredAlgorithmOptionForModelDetailsNode(MiningFunctions miningFunctions) {
        MiningAlgorithmOptions miningAlgorithmOptions = null;
        if (miningFunctions == null) {
            return miningAlgorithmOptions;
        }
        if (miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION)) {
            miningAlgorithmOptions = SUPPORT_VECTOR_MACHINE;
        } else if (miningFunctions.equals((Object)MiningFunctions.ASSOCIATION_RULES)) {
            miningAlgorithmOptions = APRIORI;
        } else if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
            miningAlgorithmOptions = ALL;
        } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
            miningAlgorithmOptions = ALL;
        } else if (miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            miningAlgorithmOptions = ALL;
        } else if (miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION)) {
            miningAlgorithmOptions = NON_NEGATIVE_MATRIX_FACTORIZATION;
        }
        return miningAlgorithmOptions;
    }

    public static MiningAlgorithmType getMiningAlgorithmType(MiningAlgorithmOptions miningAlgorithmOptions) {
        MiningAlgorithmType miningAlgorithmType = null;
        if (miningAlgorithmOptions == null) {
            return miningAlgorithmType;
        }
        if (miningAlgorithmOptions.equals((Object)ALL)) {
            miningAlgorithmType = MiningAlgorithmType.ALL;
        } else if (miningAlgorithmOptions.equals((Object)APRIORI)) {
            miningAlgorithmType = MiningAlgorithmType.APRIORI_ASSOCIATION_RULES;
        } else if (miningAlgorithmOptions.equals((Object)DECISION_TREE)) {
            miningAlgorithmType = MiningAlgorithmType.DECISION_TREE;
        } else if (miningAlgorithmOptions.equals((Object)EXPECTATION_MAXIMIZATION)) {
            miningAlgorithmType = MiningAlgorithmType.EXPECTATION_MAXIMIZATION;
        } else if (miningAlgorithmOptions.equals((Object)GENERALIZED_LINEAR_MODEL)) {
            miningAlgorithmType = MiningAlgorithmType.GENERALIZED_LINEAR_MODEL;
        } else if (miningAlgorithmOptions.equals((Object)KMEANS)) {
            miningAlgorithmType = MiningAlgorithmType.KMEANS;
        } else if (miningAlgorithmOptions.equals((Object)NAIVE_BAYES)) {
            miningAlgorithmType = MiningAlgorithmType.NAIVE_BAYES;
        } else if (miningAlgorithmOptions.equals((Object)NON_NEGATIVE_MATRIX_FACTORIZATION)) {
            miningAlgorithmType = MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR;
        } else if (miningAlgorithmOptions.equals((Object)OCLUSTER)) {
            miningAlgorithmType = MiningAlgorithmType.O_CLUSTER;
        } else if (miningAlgorithmOptions.equals((Object)SUPPORT_VECTOR_MACHINE)) {
            miningAlgorithmType = MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
        } else if (miningAlgorithmOptions.equals((Object)SINGULAR_VALUE_DECOMP)) {
            miningAlgorithmType = MiningAlgorithmType.SINGULAR_VALUE_DECOMP;
        } else if (miningAlgorithmOptions.equals((Object)PRINCIPAL_COMPONENT_ANALYSIS)) {
            miningAlgorithmType = MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS;
        }
        return miningAlgorithmType;
    }

    public static MiningAlgorithmOptions getMiningAlgorithmOption(MiningAlgorithmType miningAlgorithmType) {
        MiningAlgorithmOptions miningAlgorithmOptions = null;
        if (miningAlgorithmType == null) {
            return miningAlgorithmOptions;
        }
        if (miningAlgorithmType.equals((Object)MiningAlgorithmType.ALL)) {
            miningAlgorithmOptions = ALL;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.APRIORI_ASSOCIATION_RULES)) {
            miningAlgorithmOptions = APRIORI;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.DECISION_TREE)) {
            miningAlgorithmOptions = DECISION_TREE;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.EXPECTATION_MAXIMIZATION)) {
            miningAlgorithmOptions = EXPECTATION_MAXIMIZATION;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.GENERALIZED_LINEAR_MODEL)) {
            miningAlgorithmOptions = GENERALIZED_LINEAR_MODEL;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.KMEANS)) {
            miningAlgorithmOptions = KMEANS;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.NAIVE_BAYES)) {
            miningAlgorithmOptions = NAIVE_BAYES;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR)) {
            miningAlgorithmOptions = NON_NEGATIVE_MATRIX_FACTORIZATION;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.O_CLUSTER)) {
            miningAlgorithmOptions = OCLUSTER;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.SUPPORT_VECTOR_MACHINES)) {
            miningAlgorithmOptions = SUPPORT_VECTOR_MACHINE;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.SINGULAR_VALUE_DECOMP)) {
            miningAlgorithmOptions = SINGULAR_VALUE_DECOMP;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS)) {
            miningAlgorithmOptions = PRINCIPAL_COMPONENT_ANALYSIS;
        }
        return miningAlgorithmOptions;
    }

    static {
        stringToEnum = new HashMap<String, MiningAlgorithmOptions>();
        for (MiningAlgorithmOptions miningAlgorithmOptions : MiningAlgorithmOptions.values()) {
            stringToEnum.put(miningAlgorithmOptions.toString(), miningAlgorithmOptions);
        }
    }
}

