/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.partition.PartitionColumn;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.server.model.CoefficientSortSpec;
import oracle.dmt.dataminer.server.model.CoefficientWhereSpec;
import oracle.dmt.dataminer.server.model.FilterSetting;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.ModelDetails;
import oracle.dmt.dataminer.server.model.SortSpec;
import oracle.dmt.dataminer.server.model.TargetPriorsPredictionSet;
import oracle.dmt.dataminer.server.model.WhereSpec;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OraclePreparedStatement;

public class FeatureExtraction
extends Model
implements ModelDetails {
    private static final Logger LOGGER = Logger.getLogger(Model.class.getName());
    public static final String MAXIMUM_ABS_COEFFICIENT_VALUE = "MAXIMUM_ABS_COEFFICIENT_VALUE";
    public static final String TOTAL_COEFFICIENTS = "TOTAL_COEFFICIENTS";
    private static final String FEATURE_ID = "FEATURE_ID";
    private static final String MAPPED_FEATURE_ID = "MAPPED_FEATURE_ID";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_nmf(:model_name)) t, \n   TABLE(t.attribute_set) s \n   WHERE t.mapped_feature_id IN(:target_values)  ";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION_PARTITION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_nmf(:model_name,:partitionId)) t, \n   TABLE(t.attribute_set) s \n   WHERE t.mapped_feature_id IN(:target_values)  ";
    private static final String QUERY_MIN_MAX = "SELECT  MAX(coefficient) maximum_value \nFROM TABLE(dbms_data_mining.get_model_details_nmf('<model_name>')) t, TABLE(t.attribute_set) s";
    private static final String QUERY_MIN_MAX_PARTITION = "SELECT  MAX(coefficient) maximum_value \nFROM TABLE(dbms_data_mining.get_model_details_nmf('<model_name>', '<partitionId>')) t, TABLE(t.attribute_set) s";
    private static final String _TARGET_CONDITION = "  WHERE t.mapped_feature_id = <target_value> \n";
    private static final String QUERY_COEFFICIENTS_ALL = "SELECT * FROM ( \nSELECT * FROM ( \nSELECT \n<select_stmt>\n\tfrom ( \tSELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n\t      r.attribute_name || '.' ||  r.attribute_subname \n\t     ELSE r.attribute_name \n\t     END \"attribute_name_subname\", \n\t  r.attribute_name \"attribute_name\", \n\t  r.attribute_value \"attribute_value\", \n\t  r.feature_id \"feature_id\", \n\t  r.mapped_feature_id \"mapped_feature_id\" \n  FROM (SELECT t.feature_id, t.mapped_feature_id, s.attribute_name, s.attribute_subname, s.attribute_value \n    FROM TABLE(dbms_data_mining.get_model_details_nmf(<model_name>)) t, \n   TABLE(t.attribute_set) s \n<target_condition> ) r ) \n<name_filter_condition><group_by>) <order> \n) <rownum> \n";
    private static final String QRY_FEATURE_COEFFICIENTS = "SELECT * FROM ( \nSELECT * FROM ( \n  SELECT \"feature_id\", \"mapped_feature_id\", \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"coefficient\" from  \n      (SELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n                       r.attribute_name || '.' ||  r.attribute_subname \n                  ELSE r.attribute_name \n       END \"attribute_name_subname\", \n       r.attribute_name \"attribute_name\", \n       r.attribute_value \"attribute_value\",  \n       r.coefficient \"coefficient\", \n       r.feature_id \"feature_id\",  \n       r.mapped_feature_id \"mapped_feature_id\" \n  FROM (SELECT t.feature_id, t.mapped_feature_id, s.attribute_name, s.attribute_subname, s.attribute_value, <coefficient_value> \n    FROM TABLE(dbms_data_mining.get_model_details_nmf(:model_name)) t, \n   TABLE(t.attribute_set) s \n     <internal_where_clause> \n ) r  ) \n) <order> \n) <rownum> \n";
    private static final String QRY_FEATURE_COEFFICIENTS_PARTITION = "SELECT * FROM ( \nSELECT * FROM ( \n  SELECT \"feature_id\", \"mapped_feature_id\", \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"coefficient\" from  \n      (SELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n                       r.attribute_name || '.' ||  r.attribute_subname \n                  ELSE r.attribute_name \n       END \"attribute_name_subname\", \n       r.attribute_name \"attribute_name\", \n       r.attribute_value \"attribute_value\",  \n       r.coefficient \"coefficient\", \n       r.feature_id \"feature_id\",  \n       r.mapped_feature_id \"mapped_feature_id\" \n  FROM (SELECT t.feature_id, t.mapped_feature_id, s.attribute_name, s.attribute_subname, s.attribute_value, <coefficient_value> \n    FROM TABLE(dbms_data_mining.get_model_details_nmf(:model_name, :partitionId)) t, \n   TABLE(t.attribute_set) s \n     <internal_where_clause> \n ) r  ) \n) <order> \n) <rownum> \n";
    private static final String QRY_FEATURE_COEFFICIENTS_FEATURE_ID = " t.mapped_feature_id = :target_value";
    private Map<Integer, String> featureIDToLabelMap = new HashMap<Integer, String>();
    public static final String alter_reverse_expression_feature_id = "when value = [FEATURE_ID] then ";
    public static final String alter_reverse_expression_case_rename = "'[NEW_NAME]'\n";
    public static final String alter_reverse_expression_case_keep_old = "'[OLD_NAME]'\n";
    public static final String alter_reverse_expression_case_end = "                else TO_CHAR(value) end";
    public static final String alter_reverse_expression_final = "BEGIN\n  dbms_data_mining.alter_reverse_expression(\n :MODEL_NAME, :CASE_STATEMENT);\nEND;\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFeatures(ConnectionManager connectionManager, String string, String string2) {
        String string3 = "SELECT t.feature_id, t.mapped_feature_id FROM TABLE(dbms_data_mining.get_model_details_nmf('" + Model.getCombinedUserNameModelName(string, string2, true) + "')) t ORDER BY feature_id";
        try (SQLHelper sQLHelper = new SQLHelper();){
            this.featureIDToLabelMap.clear();
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                Integer n = sQLHelper.rs.getInt(FEATURE_ID);
                String string4 = sQLHelper.rs.getString(MAPPED_FEATURE_ID);
                this.featureIDToLabelMap.put(n, string4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<TargetPriorsPredictionSet> getTargetValuePredictionSet(ConnectionManager connectionManager, String string, String string2, PartitionVO partitionVO) throws Exception {
        Object object;
        Object object2;
        SQLHelper sQLHelper = new SQLHelper();
        Vector<TargetPriorsPredictionSet> vector = new Vector<TargetPriorsPredictionSet>();
        StringBuilder stringBuilder = new StringBuilder();
        if (partitionVO != null && partitionVO.getPartitionID() != null && !"".equals(partitionVO.getPartitionID())) {
            stringBuilder.append("select FEATURE_ID, VALUE from table(FEATURE_SET( ");
            stringBuilder.append(Model.getCombinedUserNameModelName(string, string2, false));
            stringBuilder.append("  using ");
            object2 = partitionVO.getColumns();
            for (int i = 0; i < object2.size(); ++i) {
                object = (PartitionColumn)object2.get(i);
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("'");
                stringBuilder.append(((PartitionColumn)object).getValue());
                stringBuilder.append("' as ");
                stringBuilder.append(((PartitionColumn)object).getColumnName());
            }
            stringBuilder.append(")) ORDER BY FEATURE_ID");
        } else {
            stringBuilder.append("select FEATURE_ID, VALUE from table(FEATURE_SET( ");
            stringBuilder.append(Model.getCombinedUserNameModelName(string, string2, false));
            stringBuilder.append("  using <bfile_workaround>)) ORDER BY FEATURE_ID");
        }
        object2 = this.getBFILEColumns(connectionManager, string, string2);
        String string3 = StringUtils.getReplacedString(stringBuilder.toString(), "<bfile_workaround>", (String)object2);
        object = null;
        try {
            object = DatabaseMetadataUtils.createUniqueTableName("ODMR$", connectionManager, "");
            String string4 = "CREATE TABLE " + (String)object + " AS " + string3;
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string4);
            sQLHelper.pstmt.executeQuery();
            string4 = "SELECT FEATURE_ID, VALUE FROM " + (String)object;
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string4);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            ResultSetMetaData resultSetMetaData = sQLHelper.rs.getMetaData();
            int n = resultSetMetaData.getColumnType(1);
            while (sQLHelper.rs.next()) {
                TargetPriorsPredictionSet targetPriorsPredictionSet = null;
                Object object3 = null;
                if (DatabaseMetadataUtils.isSQLDataTypeNumeric(n)) {
                    object3 = sQLHelper.rs.getBigDecimal(FEATURE_ID);
                } else if (DatabaseMetadataUtils.isSQLDataTypeString(n)) {
                    object3 = sQLHelper.rs.getString(FEATURE_ID);
                } else {
                    throw new Exception("Unexpected target data type. Expected either a number or string.");
                }
                targetPriorsPredictionSet = new TargetPriorsPredictionSet(object3, n, sQLHelper.rs.getDouble("VALUE"));
                vector.add(targetPriorsPredictionSet);
            }
            sQLHelper.close();
            this.initFeatures(connectionManager, string, string2);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            sQLHelper.close();
            DatabaseMetadataUtils.dropTable(connectionManager, null, (String)object);
        }
        return vector;
    }

    public TargetPriorsPredictionSet findMostCommonTargetValue(Vector<TargetPriorsPredictionSet> vector) {
        Double d = 0.0;
        Object object = null;
        TargetPriorsPredictionSet targetPriorsPredictionSet = null;
        for (TargetPriorsPredictionSet targetPriorsPredictionSet2 : vector) {
            if (!(d <= targetPriorsPredictionSet2.getProbability())) continue;
            d = targetPriorsPredictionSet2.getProbability();
            object = targetPriorsPredictionSet2.getPrediction();
            targetPriorsPredictionSet = targetPriorsPredictionSet2;
        }
        assert (object != null) : "Unable to find a target value with a prob value >= 0";
        return targetPriorsPredictionSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getMaxValue(ConnectionManager connectionManager, String string, String string2, String string3) {
        String string4;
        SQLHelper sQLHelper = new SQLHelper();
        Double d = null;
        if (string3 != null && !"".equals(string3)) {
            string4 = StringUtils.getReplacedString(QUERY_MIN_MAX_PARTITION, "<model_name>", Model.getCombinedUserNameModelName(string, string2, true));
            string4 = StringUtils.getReplacedString(string4, "<partitionId>", string3);
        } else {
            string4 = StringUtils.getReplacedString(QUERY_MIN_MAX, "<model_name>", Model.getCombinedUserNameModelName(string, string2, true));
        }
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string4);
            if (sQLHelper.rs.next()) {
                d = sQLHelper.rs.getDouble(1);
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            d = null;
        }
        finally {
            sQLHelper.close();
        }
        return d;
    }

    private static String createInternalWhereClause(FilterSetting filterSetting, String string, String string2, String string3) {
        StringBuilder stringBuilder = null;
        if (null != filterSetting.getTargetValue()) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("   WHERE ");
            stringBuilder.append(QRY_FEATURE_COEFFICIENTS_FEATURE_ID);
        }
        if (string != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string);
        }
        if (string != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string);
        }
        if (string2 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string2);
        }
        if (string3 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string3);
        }
        return stringBuilder != null ? stringBuilder.toString() : "";
    }

    private String prepareCoefficientSQL(FilterSetting filterSetting, String string) {
        String string2 = QRY_FEATURE_COEFFICIENTS;
        if (string != null && !"".equals(string)) {
            string2 = QRY_FEATURE_COEFFICIENTS_PARTITION;
        }
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        StringBuffer stringBuffer = new StringBuffer();
        String string7 = "";
        Double d = null;
        Double d2 = null;
        Vector<CoefficientSortSpec> vector = null;
        if (filterSetting != null) {
            Object object;
            if (filterSetting.isUseFilterSpecification()) {
                object = filterSetting.getMaxCoefficient();
                if (object != null) {
                    d = ((BigDecimal)object).doubleValue();
                }
                if ((object = filterSetting.getMinCoefficient()) != null) {
                    d2 = ((BigDecimal)object).doubleValue();
                }
            }
            vector = filterSetting.getSortSpecification();
            string3 = "s.coefficient";
            if (d != null) {
                string5 = " AND s.coefficient <= " + d;
            }
            if (d2 != null) {
                string6 = " AND s.coefficient >= " + d2;
            }
            if (filterSetting.getFetchSize() > 0) {
                string7 = " where rownum <= " + filterSetting.getFetchSize();
            }
            if (vector != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                object = vector.iterator();
                while (object.hasNext()) {
                    CoefficientSortSpec coefficientSortSpec = (CoefficientSortSpec)object.next();
                    if (!coefficientSortSpec.isUseIt()) continue;
                    stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    if (coefficientSortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!object.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        string2 = StringUtils.getReplacedString(string2, "<coefficient_value>", string3);
        string2 = StringUtils.getReplacedString(string2, "<internal_where_clause>", FeatureExtraction.createInternalWhereClause(filterSetting, string4, string5, string6));
        string2 = StringUtils.getReplacedString(string2, "<order>", stringBuffer.toString());
        string2 = StringUtils.getReplacedString(string2, "<rownum>", string7);
        return string2;
    }

    private Vector<CoefficientRowData> invokeCoefficientQuery(ConnectionManager connectionManager, String string, String string2, String string3, String string4, String string5) throws SQLException {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string4);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.setStringAtName("target_value", string3);
            if (string5 != null && !"".equals(string5)) {
                sQLHelper.opstmt.setStringAtName("partitionId", string5);
            }
            sQLHelper.opstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string6;
                String string7 = sQLHelper.rs.getString("attribute_name_subname");
                if (string7 == null) {
                    string7 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
                }
                if ((string6 = sQLHelper.rs.getString("attribute_value")) == null) {
                    string6 = "";
                }
                Double d = sQLHelper.rs.getDouble("coefficient");
                CoefficientRowData coefficientRowData = new CoefficientRowData(string7, string6, d);
                vector.add(coefficientRowData);
            }
        }
        return vector;
    }

    public Vector<CoefficientRowData> getCoefficients(ConnectionManager connectionManager, String string, String string2, FilterSetting filterSetting, String string3) throws SQLException {
        Vector<CoefficientRowData> vector = new Vector();
        String string4 = this.prepareCoefficientSQL(filterSetting, string3);
        vector = this.invokeCoefficientQuery(connectionManager, string, string2, filterSetting.getTargetValue() != null ? filterSetting.getTargetValue().toString() : "", string4, string3);
        return vector;
    }

    private Map<String, Object> invokeCoefficientsStatisticsQuery(ConnectionManager connectionManager, String string, String string2, List<Object> list, String string3) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        SQLHelper sQLHelper = new SQLHelper();
        boolean bl = list.get(0) instanceof String;
        String string4 = Model.getCombinedUserNameModelName(string, string2, false);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (Object object : list) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(",");
            }
            if (bl) {
                stringBuilder.append("'");
                stringBuilder.append(object.toString());
                stringBuilder.append("'");
                continue;
            }
            stringBuilder.append(object.toString());
        }
        try {
            sQLHelper.conn = connectionManager.getConnection();
            if (string3 != null && !"".equals(string3)) {
                sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION_PARTITION);
                sQLHelper.opstmt.setStringAtName("partitionId", string3);
            } else {
                sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION);
            }
            sQLHelper.opstmt.setStringAtName("model_name", string4);
            sQLHelper.opstmt.setStringAtName("target_values", stringBuilder.toString());
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                Object object;
                Integer n = sQLHelper.rs.getInt(TOTAL_COEFFICIENTS);
                hashMap.put(TOTAL_COEFFICIENTS, n);
                object = sQLHelper.rs.getDouble(MAXIMUM_ABS_COEFFICIENT_VALUE);
                hashMap.put(MAXIMUM_ABS_COEFFICIENT_VALUE, object);
            } else {
                hashMap.put(TOTAL_COEFFICIENTS, 0);
                hashMap.put(MAXIMUM_ABS_COEFFICIENT_VALUE, 0.0);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    public Map<String, Object> getCoefficientStatistics(ConnectionManager connectionManager, String string, String string2, List<Object> list, String string3) throws SQLException {
        assert (list != null) : "Must provide a non null collection of target values.";
        assert (list != null && list.size() > 0) : "Must provide at least one target value";
        Map<String, Object> map = this.invokeCoefficientsStatisticsQuery(connectionManager, string, string2, list, string3);
        return map;
    }

    private String prepareCoefficientSQLAll(String string, String string2, FilterSetting filterSetting) {
        String string3 = QUERY_COEFFICIENTS_ALL;
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = "";
        String string5 = null;
        String string6 = "";
        StringBuilder stringBuilder2 = null;
        String string7 = null;
        if (filterSetting != null) {
            Object object;
            Object object2;
            Object object3;
            Vector<CoefficientSortSpec> vector;
            if (filterSetting.getFetchSize() > 0) {
                string4 = " WHERE rownum <= " + filterSetting.getFetchSize();
            }
            if ((vector = filterSetting.getSortSpecification()) != null && vector.size() > 0) {
                stringBuilder.append("order by ");
                object3 = vector.iterator();
                while (object3.hasNext()) {
                    object2 = (CoefficientSortSpec)object3.next();
                    if (!((SortSpec)object2).isUseIt()) continue;
                    object = ((SortSpec)object2).getAttributeName();
                    if (((String)object).equals("attribute_name_subname")) {
                        string5 = "\"attribute_name_subname\", max(\"attribute_name\") \"attribute_name\", max(\"attribute_value\") \"attribute_value\"";
                        string6 = "GROUP BY \"attribute_name_subname\"";
                        stringBuilder.append("\"attribute_name_subname\"");
                    } else if (((String)object).equals("attribute_name")) {
                        string5 = "max(\"attribute_name_subname\") \"attribute_name_subname\", \"attribute_name\", max(\"attribute_value\") \"attribute_value\"";
                        string6 = "GROUP BY \"attribute_name\"";
                        stringBuilder.append("\"attribute_name\"");
                    } else if (((String)object).equals("attribute_value")) {
                        string5 = "\"attribute_name_subname\", \"attribute_name\", \"attribute_value\"";
                        stringBuilder.append("\"attribute_value\"");
                    }
                    if (((SortSpec)object2).isAscending()) {
                        stringBuilder.append(" ASC ");
                    } else {
                        stringBuilder.append(" DESC NULLS LAST ");
                    }
                    if (!object3.hasNext()) continue;
                    stringBuilder.append(",");
                }
                if (stringBuilder.substring(stringBuilder.length() - 1, stringBuilder.length()).equalsIgnoreCase(",")) {
                    stringBuilder.setLength(stringBuilder.length() - 1);
                }
            }
            if ((object3 = filterSetting.getWhereSpecification()) != null && ((Vector)object3).size() > 0) {
                object2 = ((Vector)object3).iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (!((CoefficientWhereSpec)object).isUseIt()) continue;
                    if (stringBuilder2 == null) {
                        stringBuilder2 = new StringBuilder(" WHERE ");
                    }
                    stringBuilder2.append(" \"" + ((WhereSpec)object).getLeftSideObject() + "\" ");
                    switch (((WhereSpec)object).getCondition()) {
                        case 1: {
                            stringBuilder2.append(" LIKE ");
                            break;
                        }
                        case 2: {
                            stringBuilder2.append(" NOT LIKE ");
                            break;
                        }
                        default: {
                            stringBuilder2.append(" LIKE ");
                            assert (false) : "Unrecognized Where Action: " + ((WhereSpec)object).getCondition();
                            break;
                        }
                    }
                    stringBuilder2.append("'%" + ((WhereSpec)object).getRightSideObject() + "%' \n");
                }
            }
            string7 = null != filterSetting.getTargetValue() ? StringUtils.getReplacedString(_TARGET_CONDITION, "<target_value>", "'" + filterSetting.getTargetValue().toString() + "'") : "";
        }
        string3 = StringUtils.getReplacedString(string3, "<select_stmt>", string5);
        string3 = StringUtils.getReplacedString(string3, "<model_name>", "'" + Model.getCombinedUserNameModelName(string, string2, true) + "'");
        if (stringBuilder2 == null) {
            stringBuilder2 = new StringBuilder("");
        }
        string3 = StringUtils.getReplacedString(string3, "<name_filter_condition>", stringBuilder2.toString());
        string3 = StringUtils.getReplacedString(string3, "<target_condition>", string7);
        string3 = StringUtils.getReplacedString(string3, "<order>", stringBuilder.toString());
        string3 = StringUtils.getReplacedString(string3, "<group_by>", string6);
        string3 = StringUtils.getReplacedString(string3, "<rownum>", string4);
        return string3;
    }

    private Vector<CoefficientRowData> invokeItemPickerQuery(ConnectionManager connectionManager, String string) throws SQLException {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.stmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string);
            while (sQLHelper.rs.next()) {
                String string2;
                String string3 = sQLHelper.rs.getString("attribute_name_subname");
                if (string3 == null) {
                    string3 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
                }
                if ((string2 = sQLHelper.rs.getString("attribute_value")) == null) {
                    string2 = "";
                }
                CoefficientRowData coefficientRowData = new CoefficientRowData(string3, string2, null, null);
                vector.add(coefficientRowData);
            }
        }
        return vector;
    }

    public Vector<CoefficientRowData> getAllCoefficients(ConnectionManager connectionManager, String string, String string2, FilterSetting filterSetting) throws SQLException {
        Vector<CoefficientRowData> vector = new Vector();
        String string3 = this.prepareCoefficientSQLAll(string, string2, filterSetting);
        vector = this.invokeItemPickerQuery(connectionManager, string3);
        return vector;
    }

    public boolean isFeatureLabelUniquie(String string) {
        return !this.featureIDToLabelMap.containsValue(string);
    }

    public String renameFeatureLabel(ConnectionManager connectionManager, String string, String string2, String string3, String string4) throws Exception {
        Object object;
        Integer n = null;
        for (Map.Entry<Integer, String> object22 : this.featureIDToLabelMap.entrySet()) {
            Integer n2 = object22.getKey();
            object = object22.getValue();
            if (!((String)object).equals(string4)) continue;
            n = n2;
            break;
        }
        StringBuilder stringBuilder = new StringBuilder("case ");
        for (Map.Entry<Integer, String> entry : this.featureIDToLabelMap.entrySet()) {
            object = entry.getKey();
            String string5 = entry.getValue();
            StringBuilder stringBuilder2 = new StringBuilder();
            String string6 = StringUtils.getReplacedString(alter_reverse_expression_feature_id, "[FEATURE_ID]", ((Integer)object).toString());
            stringBuilder2.append(string6);
            if (((Integer)object).equals(n)) {
                this.featureIDToLabelMap.put((Integer)object, string3);
                string6 = StringUtils.getReplacedString(alter_reverse_expression_case_rename, "[NEW_NAME]", string3);
            } else {
                string6 = StringUtils.getReplacedString(alter_reverse_expression_case_keep_old, "[OLD_NAME]", string5);
            }
            stringBuilder2.append(string6);
            stringBuilder.append(stringBuilder2.toString());
        }
        stringBuilder.append(alter_reverse_expression_case_end);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(alter_reverse_expression_final);
            sQLHelper.opstmt.setStringAtName("MODEL_NAME", Model.getCombinedUserNameModelName(string, string2, true));
            sQLHelper.opstmt.setStringAtName("CASE_STATEMENT", stringBuilder.toString());
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
        }
        return string3;
    }
}

