/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.runner;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.models.Duration;
import oracle.dmt.dataminer.controls.renderers.FormatterCellRenderer;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.EventLog;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.utils.HTMLStringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.comparator.DurationComparator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public class EventLogPanel
extends DialogDisplayer
implements SearchListener {
    private String _connName;
    private EventLog.EntryInfo jobInfo;
    private boolean bShowErrors;
    private boolean bShowWarnings;
    private boolean bShowInfo;
    private String searchText;
    private transient SearchCategory searchCategory;
    private transient RowFilter<LogTableModel, Integer> nodeFilter;
    private transient boolean selectPending;
    private transient EventLog.EntryInfo selectPendingEntry;
    private JPanel _detailPanel;
    private JEditorPane _jDetailText;
    private JPanel _jEventsPanel;
    private TransparentPanel _jEventsTablePanel;
    private ComponentWithTitlebar<JComponent> _jEventsToolBar;
    private JSplitPane _jSplitter;
    private JScrollPane jScrollPane1;
    private static int REFRESH_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.runner.refresh");
    private static int SHOW_ERROR_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.runner.showErrors");
    private static int SHOW_WARNING_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.runner.showWarnings");
    private static int SHOW_INFO_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.runner.showInfos");
    private GenericTable _jEventsTable = new DataMinerTable();
    private LogTableModel _tableModel;
    private ToolButton _refresh;
    private ToggleToolButton _showErrors;
    private ToggleToolButton _showWarnings;
    private ToggleToolButton _showInfo;
    private SearchField _searchField;
    private static final String DETAIL_TEMPLATE = "<html><table>\n<tr>\n<td align=\"left\" valign=\"top\">{2}</td>\n<td align=\"left\" valign=\"top\">{0}</td>\n</tr>\n<tr>\n<td align=\"left\" valign=\"top\">{3}</td>\n<td align=\"left\" valign=\"top\">{1}</td>\n</tr>\n</table></html>";

    public EventLogPanel(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2, EventLog.EntryInfo entryInfo, boolean bl) {
        LogSteps logSteps = EventLogPanel.getSteps(string, bigDecimal, bigDecimal2, entryInfo.getNodeId());
        if (logSteps == null) {
            throw new RuntimeException("Error loading Events Log Steps");
        }
        List<EventLog.Entry> list = logSteps.getSteps();
        EventLog.Entry entry = logSteps.getLastEntry();
        if (entry != null) {
            entryInfo.setEntry(entry);
        }
        this._connName = string;
        this.jobInfo = entryInfo;
        this.bShowErrors = true;
        this.bShowWarnings = true;
        this.bShowInfo = false;
        this.searchText = null;
        this.searchCategory = null;
        this.selectPending = false;
        this.selectPendingEntry = null;
        this.initComponents();
        this.initUI(list, this.jobInfo, bl);
        this.initRes();
    }

    private void initComponents() {
        this._jSplitter = new JSplitPane();
        this._jEventsPanel = new JPanel();
        this._jEventsTablePanel = new TransparentPanel();
        this._jEventsToolBar = new ComponentWithTitlebar();
        this._detailPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this._jDetailText = new JEditorPane();
        this.setPreferredSize(new Dimension(300, 200));
        this._jSplitter.setDividerLocation(250);
        this._jSplitter.setDividerSize(2);
        this._jSplitter.setOrientation(0);
        this._jSplitter.setPreferredSize(new Dimension(400, 275));
        this._jEventsPanel.setPreferredSize(new Dimension(400, 150));
        this._jEventsTablePanel.setPreferredSize(new Dimension(400, 150));
        GroupLayout groupLayout = new GroupLayout((Container)this._jEventsTablePanel);
        this._jEventsTablePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jEventsToolBar, -1, 580, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jEventsToolBar, -1, 249, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this._jEventsPanel);
        this._jEventsPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jEventsTablePanel, -1, 580, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jEventsTablePanel, -1, 249, Short.MAX_VALUE));
        this._jSplitter.setLeftComponent(this._jEventsPanel);
        this._detailPanel.setPreferredSize(new Dimension(400, 50));
        this._jDetailText.setMinimumSize(new Dimension(10, 20));
        this._jDetailText.setPreferredSize(new Dimension(700, 20));
        this.jScrollPane1.setViewportView(this._jDetailText);
        GroupLayout groupLayout3 = new GroupLayout(this._detailPanel);
        this._detailPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 580, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 100, Short.MAX_VALUE));
        this._jSplitter.setBottomComponent(this._detailPanel);
        GroupLayout groupLayout4 = new GroupLayout(this);
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jSplitter, -1, 582, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jSplitter, -1, 353, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
    }

    public void initUI(List<EventLog.Entry> list, final EventLog.EntryInfo entryInfo, boolean bl) {
        SearchCategory[] searchCategoryArray;
        JScrollPane jScrollPane = new JScrollPane((Component)this._jEventsTable);
        this._jEventsToolBar.setComponent((JComponent)jScrollPane);
        ControlBar controlBar = new ControlBar();
        this._jEventsToolBar.setControlBar(controlBar);
        this._jEventsToolBar.setLabel(new JLabel());
        IdeAction ideAction = IdeAction.get((int)REFRESH_CMDID);
        this._refresh = new ToolButton((Action)ideAction);
        this._refresh.setIcon(OracleIcons.getIcon((String)"refresh.png"));
        this._refresh.setToolTipText(RunManagerLrb.get("REFRESH_TIP"));
        this._jEventsToolBar.getControlBar().add((Component)this._refresh);
        this._jEventsToolBar.getControlBar().addSeparator();
        this._refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogSteps logSteps = EventLogPanel.getSteps(EventLogPanel.this._connName, entryInfo.getProjectId(), entryInfo.getWorkflowId(), null);
                EventLogPanel.this._tableModel.reload(logSteps.getSteps());
                EventLogPanel.this.configureSorting();
            }
        });
        IdeAction ideAction2 = IdeAction.get((int)SHOW_ERROR_CMDID);
        ideAction2.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                EventLogPanel.this.bShowErrors = EventLogPanel.this._showErrors.isSelected();
                EventLogPanel.this.configureSorting();
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return true;
            }
        });
        this._showErrors = new ToggleToolButton((ToggleAction)ideAction2);
        this._showErrors.setIcon(OracleIcons.getIcon((String)"error.png"));
        this._showErrors.setToolTipText(RunManagerLrb.get("SHOW_ERRORS_TIP"));
        this._jEventsToolBar.getControlBar().add((Component)this._showErrors);
        this._showErrors.setSelected(this.bShowErrors);
        IdeAction ideAction3 = IdeAction.get((int)SHOW_WARNING_CMDID);
        ideAction3.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                EventLogPanel.this.bShowWarnings = EventLogPanel.this._showWarnings.isSelected();
                EventLogPanel.this.configureSorting();
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return true;
            }
        });
        this._showWarnings = new ToggleToolButton((ToggleAction)ideAction3);
        this._showWarnings.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this._showWarnings.setToolTipText(RunManagerLrb.get("SHOW_WARNINGS_TIP"));
        this._jEventsToolBar.getControlBar().add((Component)this._showWarnings);
        this._showWarnings.setSelected(this.bShowWarnings);
        IdeAction ideAction4 = IdeAction.get((int)SHOW_INFO_CMDID);
        ideAction4.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                EventLogPanel.this.bShowInfo = EventLogPanel.this._showInfo.isSelected();
                EventLogPanel.this.configureSorting();
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return true;
            }
        });
        this._showInfo = new ToggleToolButton((ToggleAction)ideAction4);
        this._showInfo.setIcon(OracleIcons.getIcon((String)"info.png"));
        this._showInfo.setToolTipText(RunManagerLrb.get("SHOW_INFO_TIP"));
        this._jEventsToolBar.getControlBar().add((Component)this._showInfo);
        this._jEventsToolBar.getControlBar().addSeparator();
        this._showInfo.setSelected(this.bShowInfo);
        this._searchField = new SearchField(SearchField.Style.FILTER);
        this._searchField.setPreferredSize(new Dimension(200, 10));
        for (SearchCategory searchCategory : searchCategoryArray = new SearchCategory[]{new SearchCategory(RunManagerLrb.get("FILTER_NODE")), new SearchCategory(RunManagerLrb.get("FILTER_NODE_EXACT")), new SearchCategory(RunManagerLrb.get("FILTER_ANY"))}) {
            this._searchField.addCategory(searchCategory);
        }
        this._jEventsToolBar.getControlBar().add((Component)this._searchField);
        this._searchField.addSearchListener((SearchListener)this);
        this._jDetailText.setEditable(false);
        this._jDetailText.setContentType("text/html");
        this._jDetailText.setDragEnabled(true);
        this._jDetailText.setTransferHandler(new TransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent jComponent) {
                JEditorPane jEditorPane = (JEditorPane)jComponent;
                return new StringSelection(jEditorPane.getSelectedText());
            }

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 3;
            }
        });
        this._tableModel = new LogTableModel(list);
        this.setupTable();
        this.configureSorting();
        if (bl) {
            this._searchField.setSelectedCategory(searchCategoryArray[1]);
            if (entryInfo.getEntry() != null) {
                this._searchField.setText(entryInfo.getEntry().getNodeName());
            }
        }
        this._jDetailText.setText(RunManagerLrb.get("VIEW_NO_SELECTION"));
        this._jSplitter.setDividerLocation(330);
    }

    public void setupTable() {
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = ((EventLog.Entry)object).getType();
                if ("ERR".equals(string)) {
                    return OracleIcons.getIcon((String)"error.png");
                }
                if ("WARN".equals(string)) {
                    return OracleIcons.getIcon((String)"warning.png");
                }
                if ("INFO".equals(string)) {
                    return OracleIcons.getIcon((String)"info.png");
                }
                return null;
            }
        });
        FormatterCellRenderer formatterCellRenderer = new FormatterCellRenderer(DateFormat.getDateTimeInstance(3, 2));
        this._jEventsTable.setModel((TableModel)((Object)this._tableModel));
        this._jEventsTable.setResizeColumnOnDoubleClick(true);
        this._jEventsTable.getSelectionModel().setSelectionMode(2);
        this._jEventsTable.setNoEntryInstructionText(RunManagerLrb.get("NO_LOG_ENTRIES_TEXT"));
        this._jEventsTable.getColumnModel().getColumn(4).setCellRenderer(formatterCellRenderer);
        this._jEventsTable.getColumnModel().getColumn(0).setCellRenderer(iconCellRenderer);
        this._jEventsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EventLogPanel.this.loadDetail();
            }
        });
        this._jEventsTable.setAutoResizeMode(1);
        this.nodeFilter = new RowFilter<LogTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends LogTableModel, ? extends Integer> entry) {
                String string;
                boolean bl;
                boolean bl2 = false;
                Integer n = entry.getIdentifier();
                LogTableModel logTableModel = entry.getModel();
                EventLog.Entry entry2 = logTableModel.getEntry(n);
                boolean bl3 = false;
                boolean bl4 = bl = EventLogPanel.this.searchText != null && EventLogPanel.this.searchCategory != null;
                if (entry2.getType().equals("ERR") && EventLogPanel.this.bShowErrors || entry2.getType().equals("WARN") && EventLogPanel.this.bShowWarnings || entry2.getType().equals("INFO") && EventLogPanel.this.bShowInfo) {
                    bl3 = true;
                }
                String string2 = string = EventLogPanel.this.searchText != null ? EventLogPanel.this.searchText.toLowerCase() : null;
                if (bl3 && bl && EventLogPanel.this.searchCategory.getLabel().equals(RunManagerLrb.get("FILTER_NODE"))) {
                    String string3;
                    String string4 = string3 = entry2.getNodeName() != null ? entry2.getNodeName().toLowerCase() : "";
                    if (string3.contains(string)) {
                        bl2 = true;
                    }
                } else if (bl3 && bl && EventLogPanel.this.searchCategory.getLabel().equals(RunManagerLrb.get("FILTER_NODE_EXACT"))) {
                    String string5;
                    String string6 = string5 = entry2.getNodeName() != null ? entry2.getNodeName().toLowerCase() : "";
                    if (string.isEmpty() || string5.equals(string)) {
                        bl2 = true;
                    }
                } else if (bl3 && bl && EventLogPanel.this.searchCategory.getLabel().equals(RunManagerLrb.get("FILTER_ANY"))) {
                    String string7;
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
                    String string8 = entry2.getNodeName() != null ? entry2.getNodeName().toLowerCase() : "";
                    String string9 = entry2.toString().toLowerCase();
                    String string10 = entry2.getSubNodeName() != null ? entry2.getSubNodeName().toLowerCase() : "";
                    String string11 = entry2.getDurationFormatted() != null ? entry2.getDurationFormatted().toLowerCase() : "";
                    String string12 = entry2.getTime() != null ? dateFormat.format(entry2.getTime()) : "";
                    String string13 = string7 = entry2.getMessage() != null ? entry2.getMessage().toLowerCase() : "";
                    if (string8.contains(string) || string12.contains(string) || string7.contains(string) || entry2.getJobName().contains(string) || string9.contains(string) || string10.contains(string) || string11.contains(string)) {
                        bl2 = true;
                    }
                } else if (bl3) {
                    bl2 = true;
                }
                return bl2;
            }
        };
    }

    public void configureSorting() {
        TableRowSorter<LogTableModel> tableRowSorter = new TableRowSorter<LogTableModel>(this._tableModel);
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
        arrayList.add(new RowSorter.SortKey(4, SortOrder.DESCENDING));
        tableRowSorter.setSortKeys(arrayList);
        tableRowSorter.setSortsOnUpdates(true);
        tableRowSorter.setComparator(6, DurationComparator.getComparator());
        tableRowSorter.setRowFilter(this.nodeFilter);
        this._jEventsTable.setRowSorter(tableRowSorter);
        String string = MessageFormat.format(RunManagerLrb.get("TOOLBAR_TITLE"), tableRowSorter.getViewRowCount(), this._tableModel.getRowCount());
        this._jEventsToolBar.getLabel().setText(string);
    }

    public void searchPerformed(SearchEvent searchEvent) {
        this.searchCategory = searchEvent.getSearchCategory();
        this.searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._jEventsTable.scrollToSelection();
        this.applyPendingRowSelection();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
        this.searchCategory = searchEvent.getSearchCategory();
        this.searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._jEventsTable.scrollToSelection();
        this.applyPendingRowSelection();
    }

    @Override
    protected String getDialogTitle() {
        return RunManagerLrb.get("EVENT_LOG_TITLE") + " " + this._connName + "/" + this.jobInfo.getProjectName() + "/" + this.jobInfo.getWorkflowName();
    }

    @Override
    protected String getHelpTopic() {
        return "view_event_log";
    }

    @Override
    protected int getDialogButtonMask() {
        return 6;
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setCancelButtonText(RunManagerLrb.get("CLOSE_VIEWER"));
        jEWTDialog.setPreferredSize(new Dimension(1000, 500));
        jEWTDialog.setMinimumSize(new Dimension(300, 200));
    }

    private void applyPendingRowSelection() {
        if (this.selectPending && this.selectPendingEntry != null) {
            LogTableModel logTableModel = (LogTableModel)((Object)this._jEventsTable.getModel());
            List<EventLog.Entry> list = logTableModel.getDataList();
            for (int i = 0; i < list.size(); ++i) {
                EventLog.Entry entry = list.get(i);
                if (this.selectPendingEntry.getJobId() == null || !this.selectPendingEntry.getJobId().equals(entry.getWorkflowId()) || !this.selectPendingEntry.getEntry().getTime().equals(entry.getTime())) continue;
                int n = this._jEventsTable.convertRowIndexToView(i);
                this._jEventsTable.setRowSelectionInterval(n, n);
                this._jEventsTable.scrollToSelection();
                break;
            }
            this.selectPending = false;
            this.selectPendingEntry = null;
        }
    }

    private void loadDetail() {
        String string;
        LogTableModel logTableModel = (LogTableModel)((Object)this._jEventsTable.getModel());
        List<EventLog.Entry> list = logTableModel.getDataList();
        int[] nArray = this._jEventsTable.getSelectedRowsInModel();
        if (nArray.length == 0) {
            this._jDetailText.setText(RunManagerLrb.get("VIEW_NO_SELECTION"));
            return;
        }
        if (nArray.length > 1) {
            this._jDetailText.setText(RunManagerLrb.get("VIEW_TOO_MANY_SELECTED"));
            return;
        }
        String string2 = list.get(nArray[0]).getMessage();
        if (string2 != null) {
            string2 = HTMLStringUtils.forHTML(string2);
        }
        if ((string = list.get(nArray[0]).getMessageDetails()) != null) {
            string = HTMLStringUtils.forHTML(string);
        }
        if (string2 == null) {
            string2 = RunManagerLrb.get("VIEW_NO_INFO");
        }
        if (string == null) {
            string = RunManagerLrb.get("VIEW_NO_INFO");
        }
        Object[] objectArray = new Object[]{string2, string, RunManagerLrb.get("EVENT_VIEWER_MESSAGE_HEADER"), RunManagerLrb.get("EVENT_VIEWER_DETAIL_HEADER")};
        String string3 = MessageFormat.format(DETAIL_TEMPLATE, objectArray);
        this._jDetailText.setText(string3);
        this._jDetailText.setCaretPosition(this._jDetailText.getDocument().getLength());
        this._jDetailText.moveCaretPosition(0);
    }

    public static LogSteps getSteps(final String string, final BigDecimal bigDecimal, final BigDecimal bigDecimal2, final String string2) {
        class GetLogEnties
        extends ProgressRunnable {
            private boolean canceled;
            private LogSteps stepsInfo = null;

            GetLogEnties() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doWork() throws Exception {
                Connection connection = null;
                try {
                    Object object;
                    connection = ConnectionFolder.getConnection(string);
                    LogSteps logSteps = new LogSteps();
                    if (string2 != null) {
                        object = EventLog.getLastEntryFor(connection, bigDecimal, bigDecimal2, string2);
                        logSteps.setLastEntry((EventLog.Entry)object);
                    }
                    object = EventLog.getEntriesFor(connection, bigDecimal, bigDecimal2);
                    logSteps.setSteps((List<EventLog.Entry>)object);
                    this.stepsInfo = logSteps;
                }
                finally {
                    SQLHelper.close(connection);
                }
                return this.stepsInfo;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this.canceled = true;
            }

            public LogSteps getSteps() {
                return this.stepsInfo;
            }
        }
        GetLogEnties getLogEnties = new GetLogEnties();
        getLogEnties.setTitle(RunManagerLrb.get("GETTING_EVENT_LOG_TITLE"));
        getLogEnties.setMessage(RunManagerLrb.get("GETTING_EVENT_LOG_DESCRIPTION"));
        try {
            getLogEnties.start(true);
            if (getLogEnties.canceled) {
                return null;
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            return null;
        }
        return getLogEnties.getSteps();
    }

    public static class LogSteps {
        private List<EventLog.Entry> steps = null;
        private EventLog.Entry lastEntry = null;

        public void setSteps(List<EventLog.Entry> list) {
            this.steps = list;
        }

        public List<EventLog.Entry> getSteps() {
            return this.steps;
        }

        public void setLastEntry(EventLog.Entry entry) {
            this.lastEntry = entry;
        }

        public EventLog.Entry getLastEntry() {
            return this.lastEntry;
        }
    }

    private static class LogTableModel
    extends GenericBaseTableModel {
        private transient List<EventLog.Entry> _allData;
        private static final int EVENT = 0;
        private static final int JOB_NAME = 1;
        private static final int NODE_NAME = 2;
        private static final int SUBNODE_NAME = 3;
        private static final int TIMESTAMP = 4;
        private static final int MESSAGE = 5;
        private static final int DURATION = 6;
        private static final int COLUMN_COUNT = 7;
        private String[] _columns = new String[]{RunManagerLrb.get("TABLE_COL_EVENT"), RunManagerLrb.get("TABLE_COL_JOB"), RunManagerLrb.get("TABLE_COL_NODE"), RunManagerLrb.get("TABLE_COL_SUBNODE"), RunManagerLrb.get("TABLE_COL_TIME"), RunManagerLrb.get("TABLE_COL_MESSAGE"), RunManagerLrb.get("TABLE_COL_DURATION")};

        public LogTableModel(List<EventLog.Entry> list) {
            this._allData = list;
            this.setColumnIdentifiers(this._columns);
            this.setColumnCount(7);
            this.setRowCount(this._allData.size());
            this.fireTableDataChanged();
        }

        public void reload(List<EventLog.Entry> list) {
            this.setRowCount(0);
            this._allData.clear();
            this._allData.addAll(list);
            this.setRowCount(this._allData.size());
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int n) {
            if (n == 4) {
                return Timestamp.class;
            }
            if (n == 0) {
                return EventLog.Entry.class;
            }
            if (n == 6) {
                return Duration.class;
            }
            return String.class;
        }

        public EventLog.Entry getEntry(int n) {
            return this._allData.get(n);
        }

        public Object getValueAt(int n, int n2) {
            EventLog.Entry entry = this._allData.get(n);
            Object object = null;
            switch (n2) {
                case 2: {
                    object = entry.getNodeName();
                    break;
                }
                case 4: {
                    Timestamp timestamp = entry.getTime();
                    if (timestamp != null) {
                        object = timestamp;
                        break;
                    }
                    object = null;
                    break;
                }
                case 5: {
                    object = entry.getMessage();
                    break;
                }
                case 1: {
                    object = entry.getJobName();
                    break;
                }
                case 0: {
                    object = entry;
                    break;
                }
                case 3: {
                    object = entry.getSubNodeName();
                    break;
                }
                case 6: {
                    object = entry.getDurationObject();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public List<EventLog.Entry> getDataList() {
            return this._allData;
        }
    }
}

