/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.server.ServerConstantsLrb;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.comparator.LetterNumberComparator;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ROCs;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;

public class ClassTestResult
extends TestResult {
    private static final Logger theLogger = Logger.getLogger(ClassTestResult.class.getName());
    private static final String CONFUSION_MATRIX_TABLE_NAME = "CONFUSION_MATRIX_TABLE_NAME";
    private static final String AVG_ACCURACY = "AVG_ACCURACY";
    private static final String ACCURACY = "ACCURACY";
    private static final String COST = "COST";
    private static final String LEAST_TARGET_VALUE = "LEAST_TARGET_VALUE";
    private static final String TEST_ROWS = "TEST_ROWS";
    private HashMap<String, String> _liftResultTables;
    private HashMap<String, String> _rocResultTables;
    private HashMap<String, Double> _rocAreaUnderCurves;
    private Vector<String> _targetValues;
    private static String metrics_class_qry = "Select metric_name, metric_num_value, metric_varchar_value from <performanceTable> where <partition_clause> and metric_name in ( 'PREDICTIVE_CONFIDENCE', 'AVG_ACCURACY', 'ACCURACY', 'COST', 'LEAST_TARGET_VALUE', 'TEST_ROWS')";

    public ClassTestResult(ClassTestResult classTestResult) {
        super(classTestResult);
    }

    public ClassTestResult(Context context, BuildNodeType buildNodeType, MiningResultType miningResultType) {
        super(context, buildNodeType, miningResultType);
        boolean bl = false;
        if (buildNodeType instanceof ClassificationBuildNodeType) {
            CGeneralizedLinearModelType cGeneralizedLinearModelType;
            Object object;
            Object object22;
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)buildNodeType;
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list = models.getNaiveBayesModel();
            this._data.put("RESULT_NAME", miningResultType.getName());
            this._data.put("MINING_FUNCTION", ServerConstantsLrb.get("CLASSIFICATION"));
            this._data.put("CREATION_TIME", miningResultType.getCreationDate());
            for (Object object22 : list) {
                if (object22.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                this._data.put("MODEL_NAME", object22.getName());
                this._data.put("MODEL_ID", object22.getId());
                this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_NAIVE_BAYES"));
                bl = true;
                break;
            }
            if (!bl) {
                object = models.getCGeneralizedLinearModel();
                object22 = object.iterator();
                while (object22.hasNext()) {
                    cGeneralizedLinearModelType = (CGeneralizedLinearModelType)object22.next();
                    if (cGeneralizedLinearModelType.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                    this._data.put("MODEL_NAME", cGeneralizedLinearModelType.getName());
                    this._data.put("MODEL_ID", cGeneralizedLinearModelType.getId());
                    this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_GENERALIZED_LINEAR_MODEL"));
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                object = models.getDecisionTreeModel();
                object22 = object.iterator();
                while (object22.hasNext()) {
                    cGeneralizedLinearModelType = (DecisionTreeModelType)object22.next();
                    if (cGeneralizedLinearModelType.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                    this._data.put("MODEL_NAME", cGeneralizedLinearModelType.getName());
                    this._data.put("MODEL_ID", cGeneralizedLinearModelType.getId());
                    this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_DECISION_TREE"));
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                object = models.getCSupportVectorMachineModel();
                object22 = object.iterator();
                while (object22.hasNext()) {
                    cGeneralizedLinearModelType = (CSupportVectorMachineModelType)object22.next();
                    if (cGeneralizedLinearModelType.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                    this._data.put("MODEL_NAME", cGeneralizedLinearModelType.getName());
                    this._data.put("MODEL_ID", cGeneralizedLinearModelType.getId());
                    this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_SUPPORT_VECTOR_MACHINE"));
                    bl = true;
                    break;
                }
            }
            if (((ClassificationResultType)miningResultType).getTestMetrics() != null) {
                this._data.put("PERFORM_METRICS_TABLE_NAME", ((ClassificationResultType)miningResultType).getTestMetrics().getName());
            }
            if (((ClassificationResultType)miningResultType).getConfusionMatrix() != null) {
                this._data.put(CONFUSION_MATRIX_TABLE_NAME, ((ClassificationResultType)miningResultType).getConfusionMatrix().getName());
            }
        }
    }

    public ClassTestResult(Context context, TestNodeType testNodeType, MiningResultType miningResultType) {
        super(context, testNodeType, miningResultType);
        for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
            if (model.getModelId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
            this._data.put("RESULT_NAME", miningResultType.getName());
            this._data.put("MINING_FUNCTION", ServerConstantsLrb.get("CLASSIFICATION"));
            this._data.put("CREATION_TIME", miningResultType.getCreationDate());
            this._data.put("MODEL_SCHEMA", model.getSchema());
            this._data.put("MODEL_NAME", model.getName());
            this._data.put("MODEL_ID", model.getModelId());
            this._data.put("MINING_ALGORITHM", ServerConstants.Algorithm.getUIAlgorithmName(model.getMiningAlgorithm().value()));
            break;
        }
        this._data.put("PERFORM_METRICS_TABLE_NAME", ((ClassificationResultType)miningResultType).getTestMetrics().getName());
        this._data.put(CONFUSION_MATRIX_TABLE_NAME, ((ClassificationResultType)miningResultType).getConfusionMatrix().getName());
    }

    public boolean isROCResult() {
        if (this._result instanceof ClassificationResultType) {
            ClassificationResultType classificationResultType = (ClassificationResultType)this._result;
            return classificationResultType.getROCs() != null && classificationResultType.getROCs().getROC().size() > 0;
        }
        return false;
    }

    public boolean isConfusionMatrixResult() {
        if (this._result instanceof ClassificationResultType) {
            ClassificationResultType classificationResultType = (ClassificationResultType)this._result;
            return classificationResultType.getConfusionMatrix() != null;
        }
        return false;
    }

    public boolean isAccuracyMetricsResult() {
        if (this._result instanceof ClassificationResultType) {
            ClassificationResultType classificationResultType = (ClassificationResultType)this._result;
            return classificationResultType.getTestMetrics() != null;
        }
        return false;
    }

    public boolean isLiftProfitResult() {
        if (this._result instanceof ClassificationResultType) {
            ClassificationResultType classificationResultType = (ClassificationResultType)this._result;
            return classificationResultType.getLifts() != null && classificationResultType.getLifts().getLift().size() > 0;
        }
        return false;
    }

    private void loadResultsTables() {
        String string;
        String string2;
        List list;
        if (this._targetValues == null) {
            this._targetValues = new Vector();
        }
        ClassificationResultType classificationResultType = (ClassificationResultType)this._result;
        if (this._liftResultTables == null) {
            this._liftResultTables = new HashMap();
            list = null;
            if (classificationResultType.getLifts() != null) {
                list = classificationResultType.getLifts().getLift();
            }
            if (list != null) {
                for (Object object2 : list) {
                    string2 = object2.getTargetValue();
                    string = object2.getName();
                    this._liftResultTables.put(string2, string);
                    this._targetValues.add(string2);
                }
            }
        }
        if (this._rocResultTables == null) {
            this._rocResultTables = new HashMap();
            this._rocAreaUnderCurves = new HashMap();
            list = null;
            if (classificationResultType.getROCs() != null) {
                list = classificationResultType.getROCs().getROC();
            }
            if (list != null) {
                Object object2;
                for (Object object2 : list) {
                    string2 = object2.getTargetValue();
                    string = object2.getName();
                    this._rocResultTables.put(string2, string);
                    if (this._targetValues.contains(string2)) continue;
                    this._targetValues.add(string2);
                }
                List list2 = classificationResultType.getROCs().getAreaUnderCurve();
                object2 = list2.iterator();
                while (object2.hasNext()) {
                    ROCs.AreaUnderCurve areaUnderCurve = (ROCs.AreaUnderCurve)object2.next();
                    string2 = areaUnderCurve.getTargetValue();
                    double d = areaUnderCurve.getArea();
                    this._rocAreaUnderCurves.put(string2, d);
                }
            }
        }
        if (this._targetValues != null && this._targetValues.size() > 0) {
            Collections.sort(this._targetValues, LetterNumberComparator.getComparator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNonPartitionedMetrics() {
        String string = null;
        String string2 = this.getPerformanceMatrixTable();
        if (string2 != null) {
            string = "Select metric_name, metric_num_value, metric_varchar_value from " + string2 + " where metric_name in ( 'PREDICTIVE_CONFIDENCE', 'AVG_ACCURACY', 'ACCURACY', 'COST', 'LEAST_TARGET_VALUE')";
            try (SQLHelper sQLHelper = new SQLHelper();){
                sQLHelper.conn = ConnectionFolder.getConnection(this._context);
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    String string3 = sQLHelper.rs.getString(1);
                    if ("PREDICTIVE_CONFIDENCE".equals(string3)) {
                        this._data.put("PREDICTIVE_CONFIDENCE", sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (AVG_ACCURACY.equals(string3)) {
                        this._data.put(AVG_ACCURACY, sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (ACCURACY.equals(string3)) {
                        this._data.put(ACCURACY, sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (COST.equals(string3)) {
                        this._data.put(COST, sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (!LEAST_TARGET_VALUE.equals(string3)) continue;
                    this._data.put(LEAST_TARGET_VALUE, sQLHelper.rs.getString(3));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPartitionedMetrics(String string) {
        String string2 = this.getPerformanceMatrixTable();
        if (string2 != null) {
            String string3 = StringUtils.getReplacedString(metrics_class_qry, "<performanceTable>", string2);
            string3 = SharedTestEditorState.setPartitionClause(string3, string);
            try (SQLHelper sQLHelper = new SQLHelper();){
                sQLHelper.conn = ConnectionFolder.getConnection(this._context);
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
                if (string != null) {
                    sQLHelper.pstmt.setString(1, string);
                }
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    String string4 = sQLHelper.rs.getString(1);
                    if ("PREDICTIVE_CONFIDENCE".equals(string4)) {
                        this._data.put("PREDICTIVE_CONFIDENCE", sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (AVG_ACCURACY.equals(string4)) {
                        this._data.put(AVG_ACCURACY, sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (ACCURACY.equals(string4)) {
                        this._data.put(ACCURACY, sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (COST.equals(string4)) {
                        this._data.put(COST, sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (LEAST_TARGET_VALUE.equals(string4)) {
                        this._data.put(LEAST_TARGET_VALUE, sQLHelper.rs.getString(3));
                        continue;
                    }
                    if (!TEST_ROWS.equals(string4)) continue;
                    this._data.put(TEST_ROWS, sQLHelper.rs.getInt("METRIC_NUM_VALUE"));
                }
            }
        }
    }

    public String geLiftResultTable(String string) {
        if (this._liftResultTables == null) {
            this.loadResultsTables();
        }
        return this._liftResultTables.get(string);
    }

    public boolean liftResultExists() {
        if (this._liftResultTables == null) {
            this.loadResultsTables();
        }
        return this._liftResultTables.size() > 0;
    }

    public String geRocResultTable(String string) {
        if (this._rocResultTables == null) {
            this.loadResultsTables();
        }
        return this._rocResultTables.get(string);
    }

    public boolean rocResultExists() {
        if (this._rocResultTables == null) {
            this.loadResultsTables();
        }
        return this._rocResultTables.size() > 0;
    }

    public Double getRocAreaUnderCurve(String string) {
        if (this._rocAreaUnderCurves == null) {
            this.loadResultsTables();
        }
        return this._rocAreaUnderCurves.get(string);
    }

    public String getConfusionMatrixTable() {
        return (String)this._data.get(CONFUSION_MATRIX_TABLE_NAME);
    }

    public boolean confusionMatrixExists() {
        return this._data.get(CONFUSION_MATRIX_TABLE_NAME) != null;
    }

    public Vector<String> getTargetValues() {
        if (this._targetValues == null) {
            this.loadResultsTables();
        }
        return this._targetValues;
    }

    public String getLeastTargetValue(boolean bl, String string) {
        String string2 = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string2 == null) {
            if (bl) {
                this.loadPartitionedMetrics(string);
            } else {
                this.loadNonPartitionedMetrics();
            }
        }
        return (String)this._data.get(LEAST_TARGET_VALUE);
    }

    public BigDecimal getPredictiveConfidence(boolean bl, String string) {
        String string2 = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string2 == null) {
            if (bl) {
                this.loadPartitionedMetrics(string);
            } else {
                this.loadNonPartitionedMetrics();
            }
        }
        return (BigDecimal)this._data.get("PREDICTIVE_CONFIDENCE");
    }

    public BigDecimal getAvgAccuracy(boolean bl, String string) {
        String string2 = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string2 == null) {
            if (bl) {
                this.loadPartitionedMetrics(string);
            } else {
                this.loadNonPartitionedMetrics();
            }
        }
        return (BigDecimal)this._data.get(AVG_ACCURACY);
    }

    public Integer getTestRows(boolean bl, String string) {
        String string2 = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string2 == null) {
            if (bl) {
                this.loadPartitionedMetrics(string);
            } else {
                this.loadNonPartitionedMetrics();
            }
        }
        return (Integer)this._data.get(TEST_ROWS);
    }

    public BigDecimal getOverallAccuracy(boolean bl, String string) {
        String string2 = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string2 == null) {
            if (bl) {
                this.loadPartitionedMetrics(string);
            } else {
                this.loadNonPartitionedMetrics();
            }
        }
        return (BigDecimal)this._data.get(ACCURACY);
    }

    public BigDecimal getCost(boolean bl, String string) {
        String string2 = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string2 == null) {
            if (bl) {
                this.loadPartitionedMetrics(string);
            } else {
                this.loadNonPartitionedMetrics();
            }
        }
        return (BigDecimal)this._data.get(COST);
    }
}

