/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.modelnodes;

import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMRModelNode;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.ModelGeneralDescription;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.ExceptionDialog;

public abstract class AbstractModelNode
extends BaseTreeNode
implements ModelNode {
    private static final Logger theLogger = Logger.getLogger(AbstractModelNode.class.getName());
    protected String _schema;
    private Boolean _exists = false;
    private Model _odmModel;
    private Icon _icon;

    public AbstractModelNode(URL uRL) {
        super(uRL);
        this._exists = false;
    }

    @Override
    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("GENERIC_MODEL_NODE_ICON"));
        }
        return this._icon;
    }

    @Override
    public Model getOdmModel() {
        return this._odmModel;
    }

    public AbstractModelNode() {
    }

    @Override
    public Boolean isModelExists() {
        return this._exists;
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this.unload();
    }

    protected void openImpl() throws IOException {
        super.openImpl();
        this.load();
    }

    @Override
    public boolean mayHaveChildren() {
        return false;
    }

    public void unload() {
        this._exists = false;
        this._odmModel = null;
    }

    @Override
    public void load() {
        this.loadImpl();
    }

    private void loadImpl() {
        try {
            String string;
            ConnectionFolder connectionFolder = (ConnectionFolder)this.getParent().getAncestor(ConnectionFolder.class, true);
            Object object = this.getRepositoryData();
            if (object instanceof ModelType) {
                ModelType modelType = (ModelType)object;
                string = modelType.getName();
            } else if (object instanceof TestModelType.Model) {
                TestModelType.Model model = (TestModelType.Model)object;
                string = model.getName();
            } else if (object instanceof ModelNodeType.Models.Model) {
                ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)object;
                string = model.getName();
            } else {
                throw new RuntimeException("Invalid state detected");
            }
            this._odmModel = new Model(this.getSchema(), string);
            this._odmModel.load(connectionFolder);
            this._exists = false == this._odmModel.getModelGeneralDescription().equals(ModelGeneralDescription._NONE);
            if (this._exists.booleanValue() && this instanceof SVMCModelNode) {
                ((SVMCModelNode)this).loadLinearKernel(connectionFolder);
            } else if (this._exists.booleanValue() && this instanceof SVMRModelNode) {
                ((SVMRModelNode)this).loadLinearKernel(connectionFolder);
            } else if (this._exists.booleanValue() && this instanceof ANModelNode) {
                ((ANModelNode)this).loadLinearKernel(connectionFolder);
            }
        }
        catch (SQLException sQLException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)sQLException, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
    }

    @Override
    public void setSchema(String string) {
        this._schema = string;
    }

    @Override
    public String getSchema() {
        return this._schema;
    }

    class LoadInBackground
    extends ProgressRunnable {
        boolean _canceled = false;

        LoadInBackground() {
        }

        protected Object doWork() throws Exception {
            AbstractModelNode.this.loadImpl();
            return Boolean.TRUE;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

