/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.net.DMURLFileSystemHelper;
import oracle.dmt.dataminer.navigator.wflownodes.AggregationNodeNav;
import oracle.dmt.dataminer.navigator.wflownodes.ApplyNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.ApplyTextNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.BuildNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.BuildTextNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.BuildTextRefNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.ColumnFilterDetailsNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.ColumnFilterNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.CreateTableNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.DataProfileNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.DataSourceNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.DynamicClusterNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.DynamicPredictionNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.GraphNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.JSONQueryNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.JoinNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.ModelDetailsNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.ModelRefNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.RowFilterNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.SQLQueryNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.SampleNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.TestNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.TransformationNodeNav;
import oracle.dmt.dataminer.navigator.wflownodes.UpdateTableNavNode;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.DynamicAnomalyNavNode;
import oracle.dmt.dataminer.workflow.DynamicFeatureNavNode;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeRefType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicAnomalyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicClusterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicFeatureNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicPredictionNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FilterDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RowFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;

public class WorkflowNodeFilter
extends BaseDeferredFilter {
    private static final Logger theLogger = Logger.getLogger(WorkflowNodeFilter.class.getName());

    @Override
    protected List<Element> loadChildrenImpl(TNode tNode) throws Exception {
        Object object;
        Object object2;
        if (tNode != null) {
            this._cachedOwner = tNode;
        }
        WorkflowNode workflowNode = (WorkflowNode)tNode.getData();
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        String string = connectionFolder.getUserAccountName();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        workflowNode.open();
        Workflow workflow = (Workflow)workflowNode.getRepositoryData();
        WorkflowProcess workflowProcess = workflow.getWorkflowProcess();
        if (workflowProcess == null || workflow.isReadOnly()) {
            if (!workflow.isLoaded()) {
                object2 = connectionFolder.getConnection();
                try {
                    workflow.load((Connection)object2, workflowNode.getLastSavedOn(), false, false);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                finally {
                    SQLHelper.close((Connection)object2);
                }
                workflowProcess = workflow.getWorkflowProcess();
                object = workflowNode.getWorkflowModel();
                if (object == null) {
                    workflowNode.createModel();
                    object = workflowNode.getWorkflowModel();
                }
                ((WorkflowModel)((Object)object)).load(workflowProcess, Context.newIdeContext((Node)workflowNode));
                workflowNode.setWorkflowModel((WorkflowModel)((Object)object));
            } else {
                workflowProcess = workflow.getWorkflowProcess();
            }
        }
        object2 = MetaDataHelper.getNodeCollection(workflowProcess);
        object = object2.iterator();
        while (object.hasNext()) {
            NodeType nodeType = (NodeType)object.next();
            String string2 = this.getSchemaPrefix(nodeType, string);
            BaseTreeNode baseTreeNode = WorkflowNodeFilter.getChildNode(workflowNode.getURL().getPath() + "/" + string2 + nodeType.getName(), nodeType, true);
            baseTreeNode.setRepositoryData(nodeType);
            baseTreeNode.setParent(this.getOwner());
            arrayList.add((Element)baseTreeNode);
            baseTreeNode.close();
        }
        return arrayList;
    }

    private String getSchemaPrefix(NodeType nodeType, String string) {
        String string2 = "";
        if (nodeType instanceof DataSourceNodeType) {
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)nodeType;
            string2 = string.equals(dataSourceNodeType.getSourceTable().getSchema()) ? "" : dataSourceNodeType.getSourceTable().getSchema() + ".";
        } else if (nodeType instanceof UpdateTableNodeType) {
            UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)nodeType;
            string2 = string.equals(updateTableNodeType.getUpdateTargetTable().getSchema()) ? "" : updateTableNodeType.getUpdateTargetTable().getSchema() + ".";
        }
        return string2;
    }

    public static BaseTreeNode getChildNode(String string, NodeType nodeType, boolean bl) throws Exception {
        BaseTreeNode baseTreeNode = null;
        try {
            URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)string);
            Class clazz = null;
            if (nodeType instanceof DataSourceNodeType) {
                clazz = DataSourceNavNode.class;
            } else if (nodeType instanceof ColumnFilterNodeType) {
                clazz = ColumnFilterNavNode.class;
            } else if (nodeType instanceof DataProfileNodeType) {
                clazz = DataProfileNavNode.class;
            } else if (nodeType instanceof BuildNodeType) {
                clazz = BuildNavNode.class;
            } else if (nodeType instanceof ModelNodeType) {
                clazz = ModelRefNavNode.class;
            } else if (nodeType instanceof ModelDetailsDataNodeType) {
                clazz = ModelDetailsNavNode.class;
            } else if (nodeType instanceof ApplyNodeType) {
                clazz = ApplyNavNode.class;
            } else if (nodeType instanceof TestNodeType) {
                clazz = TestNavNode.class;
            } else if (nodeType instanceof JoinNodeType) {
                clazz = JoinNavNode.class;
            } else if (nodeType instanceof AggregationNodeType) {
                clazz = AggregationNodeNav.class;
            } else if (nodeType instanceof TransformationNodeType) {
                clazz = TransformationNodeNav.class;
            } else if (nodeType instanceof CreateTableNodeType) {
                clazz = CreateTableNavNode.class;
            } else if (nodeType instanceof UpdateTableNodeType) {
                clazz = UpdateTableNavNode.class;
            } else if (nodeType instanceof FilterDetailsDataNodeType) {
                clazz = ColumnFilterDetailsNavNode.class;
            } else if (nodeType instanceof SampleNodeType) {
                clazz = SampleNavNode.class;
            } else if (nodeType instanceof RowFilterNodeType) {
                clazz = RowFilterNavNode.class;
            } else if (nodeType instanceof BuildTextNodeType) {
                clazz = BuildTextNavNode.class;
            } else if (nodeType instanceof ApplyTextNodeType) {
                clazz = ApplyTextNavNode.class;
            } else if (nodeType instanceof BuildTextNodeRefType) {
                clazz = BuildTextRefNavNode.class;
            } else if (nodeType instanceof DynamicPredictionNodeType) {
                clazz = DynamicPredictionNavNode.class;
            } else if (nodeType instanceof DynamicClusterNodeType) {
                clazz = DynamicClusterNavNode.class;
            } else if (nodeType instanceof DynamicFeatureNodeType) {
                clazz = DynamicFeatureNavNode.class;
            } else if (nodeType instanceof DynamicAnomalyNodeType) {
                clazz = DynamicAnomalyNavNode.class;
            } else if (nodeType instanceof SQLQueryNodeType) {
                clazz = SQLQueryNavNode.class;
            } else if (nodeType instanceof JSONQueryNodeType) {
                clazz = JSONQueryNavNode.class;
            } else if (nodeType instanceof GraphNodeType) {
                clazz = GraphNavNode.class;
            } else {
                throw new RuntimeException("Unsupported node type. Please add a handler.");
            }
            BaseTreeNode baseTreeNode2 = baseTreeNode = bl ? (BaseTreeNode)NodeFactory.findOrCreate(clazz, (URL)uRL) : (BaseTreeNode)NodeFactory.find((URL)uRL);
            if (nodeType instanceof BuildNodeType) {
                ((BuildNavNode)baseTreeNode).setIcon((BuildNodeType)nodeType);
            }
        }
        catch (InstantiationException instantiationException) {
            theLogger.log(Level.SEVERE, instantiationException.getMessage(), instantiationException);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return baseTreeNode;
    }

    public Icon getIcon() {
        TNode tNode = this.getOwner();
        if (tNode == null) {
            tNode = this.getCachedOwner();
        }
        return tNode.getData().getIcon();
    }

    public String getShortLabel() {
        TNode tNode = this.getOwner();
        if (tNode == null) {
            tNode = this.getCachedOwner();
        }
        return tNode.getData().getShortLabel();
    }
}

