/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataMinerNode;
import oracle.dmt.dataminer.navigator.DataminerNavigatorManager;
import oracle.dmt.dataminer.navigator.DataminerNavigatorWindow;
import oracle.dmt.dataminer.navigator.net.DMURLFileSystemHelper;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.view.View;
import oracle.ideimpl.explorer.BaseTreeExplorer;

public abstract class BaseTreeNode
extends DefaultContainer
implements DataMinerNode {
    protected TNode _parent = null;
    protected Object _reposObj = null;
    protected ConnectionFolder _connFolder = null;
    private static final Logger theLogger = Logger.getLogger(BaseTreeNode.class.getName());

    public BaseTreeNode() {
    }

    public boolean isDeleteable() {
        return false;
    }

    public BaseTreeNode(URL uRL) {
        super(uRL);
    }

    @Override
    public void setParent(TNode tNode) {
        this._parent = tNode;
    }

    @Override
    public TNode getParent() {
        return this._parent;
    }

    public void setConnectionFolder(ConnectionFolder connectionFolder) {
        this._connFolder = connectionFolder;
    }

    @Override
    public void closeNode() {
        Context context = Context.newIdeContext((Node)this);
        IdeAction ideAction = IdeActions.getFileCloseAction();
        if (ideAction != null) {
            MetaClass metaClass = ideAction.getCommandMetaClass();
            if (metaClass != null) {
                Command command = CommandProcessor.createCommandFromMeta((MetaClass)metaClass, (Context)context);
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                try {
                    commandProcessor.invoke(command);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
            }
        } else {
            return;
        }
    }

    public void refreshNode() {
        DataminerNavigatorManager dataminerNavigatorManager = (DataminerNavigatorManager)DataminerNavigatorManager.getInstance();
        DataminerNavigatorWindow dataminerNavigatorWindow = dataminerNavigatorManager.getNavigatorInstance();
        BaseTreeExplorer baseTreeExplorer = (BaseTreeExplorer)dataminerNavigatorWindow.getTreeExplorer();
        baseTreeExplorer.refresh(this.getParent());
    }

    @Override
    public void closeChildren() {
        BaseTreeNode.closeChildrenImpl((Node)this);
    }

    public static void closeChildrenImpl(Node node) {
        Iterator iterator = node.getChildren();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            BaseTreeNode baseTreeNode = (BaseTreeNode)iterator.next();
            BaseTreeNode.closeChildrenImpl((Node)baseTreeNode);
            baseTreeNode.closeNode();
        }
    }

    public boolean setReadOnly(boolean bl) {
        if (bl) {
            this.getAttributes().set(ElementAttributes.NON_EDITABLE | ElementAttributes.READ_ONLY);
        } else {
            this.getAttributes().unset(ElementAttributes.NON_EDITABLE | ElementAttributes.READ_ONLY);
        }
        return true;
    }

    public boolean isReadOnly() {
        return this.getAttributes().isSet(ElementAttributes.NON_EDITABLE) && this.getAttributes().isSet(ElementAttributes.NON_EDITABLE);
    }

    @Override
    public Object getRepositoryData() {
        return this._reposObj;
    }

    @Override
    public void setRepositoryData(Object object) {
        this._reposObj = object;
    }

    public String getLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        return DMURLFileSystemHelper.getName(super.getShortLabel());
    }

    @Override
    public ConnectionFolder getConnectionFolder() {
        if (this._parent != null) {
            Element element = this._parent.getAncestor(ConnectionFolder.class);
            return (ConnectionFolder)element;
        }
        return this._connFolder;
    }

    public void selectAndOpen(Context context) {
        if (!(context.getView() instanceof NavigatorWindow)) {
            theLogger.log(Level.SEVERE, "Unexpected state encountered");
            return;
        }
        TreeExplorer treeExplorer = this.getTreeExplorer(context);
        TNode tNode = treeExplorer.searchTNodeBreadthFirst((Element)this, this.getParent());
        if (tNode != null) {
            treeExplorer.setSelected(tNode);
            Context context2 = Context.newIdeContext((Node)this);
            EditorManager.getEditorManager().openDefaultEditorInFrame(context2);
        }
    }

    public void selectInTree(Context context) {
        if (!(context.getView() instanceof NavigatorWindow)) {
            theLogger.log(Level.SEVERE, "Unexpected state encountered");
            return;
        }
        TreeExplorer treeExplorer = BaseTreeNode.getTreeExplorerImpl(context);
        TNode tNode = treeExplorer.searchTNodeBreadthFirst((Element)this, this.getParent());
        if (tNode != null) {
            treeExplorer.setSelected(tNode);
        }
    }

    public static TreeExplorer getTreeExplorerImpl(Context context) {
        View view = context.getView();
        TreeExplorer treeExplorer = null;
        if (view instanceof NavigatorWindow) {
            treeExplorer = ((NavigatorWindow)context.getView()).getTreeExplorer();
        } else {
            DataMinerNode dataMinerNode = (DataMinerNode)context.getNode();
            treeExplorer = dataMinerNode.getParent().getOwner();
        }
        return treeExplorer;
    }

    @Override
    public TreeExplorer getTreeExplorer(Context context) {
        return BaseTreeNode.getTreeExplorerImpl(context);
    }

    @Override
    public BaseTreeNode getRootTreeNode(Context context) {
        return BaseTreeNode.getRootTreeNodeImpl(context);
    }

    public static BaseTreeNode getRootTreeNodeImpl(Context context) {
        TreeExplorer treeExplorer = BaseTreeNode.getTreeExplorerImpl(context);
        TNode tNode = treeExplorer.getRoot();
        return (BaseTreeNode)tNode.getAncestor(Connections.class, true);
    }

    public Iterator<Element> getChildren() {
        return super.getChildren();
    }
}

