/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.svd.details;

import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.mviewer.svd.details.DetailsLrb;
import oracle.dmt.dataminer.mviewer.svd.details.DetailsViewerState;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.ComponentWithTitlebar;

public class DetailsViewer
extends DataMinerViewGUI {
    private DetailsViewerState _state;
    private BlockingComponent overLayPanel = null;
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private DataMinerTable _jAttributesTable = new DataMinerTable();

    public DetailsViewer(Editor editor, Context context, DetailsViewerState detailsViewerState) {
        super(editor, context);
        this._context = context;
        this._state = detailsViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public DetailsViewer(Editor editor, Context context, DetailsViewerState detailsViewerState, BlockingComponent blockingComponent) {
        super(editor, context);
        this.overLayPanel = blockingComponent;
        this._context = context;
        this._state = detailsViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    private void initComponents() {
        this.jAttributesComponent = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jAttributesComponent, -1, 400, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 298, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jAttributesComponent, GroupLayout.Alignment.TRAILING, -1, 298, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this._jAttributesTable.setTooltipEnable(true);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jAttributesTable));
        this.jAttributesComponent.setComponent((JComponent)jScrollPane);
        this.jAttributesComponent.setLabel(new JLabel(DetailsLrb.get("DETAILS_VIEWER_GRID_TITLE_SVD")));
        this._jAttributesTable.setModel((TableModel)((Object)this._state.getTableModel()));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setSortColumn(0, true);
        this._jAttributesTable.setAutoResizeMode(4);
        this._state.loadStatus(DetailsLrb.get("DETAILS_LOADING_DATA_MESSAGE"));
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        protected Object doInBackground() throws Exception {
            try {
                DetailsViewer.this._state.load("");
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return DetailsViewer.this._state;
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    DetailsViewer.this._state.loadTableModel();
                    DetailsViewer.this.setLoaded(true);
                } else {
                    DetailsViewer.this._state.loadStatus(DetailsLrb.get("DETAILS_LOADING_ERROR"));
                }
            }
            catch (Exception exception) {
                this._ex = exception;
            }
            finally {
                if (this._ex != null) {
                    DataMinerEditor.handleEditorException(DetailsViewer.this.getEditor().getContext(), this._ex, DetailsLrb.get("DETAILS_VIEWER_FAILURE_TITLE"), DetailsLrb.get("DETAILS_VIEWER_FAILURE_MESG"));
                }
                DetailsViewer.this.setLoading(false);
                if (DetailsViewer.this.overLayPanel != null) {
                    DetailsViewer.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

