/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.svd;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.svd.SingularValuesTableModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.server.model.SVDCoefficientRowData;
import oracle.dmt.dataminer.server.model.SingularValueDecomposition;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;

public class SingularValuesState
extends BaseViewerState {
    private static final Logger theLogger = Logger.getLogger(SingularValuesState.class.getName());
    private ModelViewerState1 _modelViewerState1;
    private String _modelName;
    private String _userName;
    private Context _context;
    private boolean _loaded;
    private SingularValuesTableModel _model = new SingularValuesTableModel();

    public SingularValuesState() {
    }

    @Override
    public HelpInfo getHelpInfo() {
        String string = "svd_viewer_singular";
        return new HelpInfo(string);
    }

    public SingularValuesState(Context context) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
    }

    public boolean isFeatureLabelUniquie(String string) {
        return SingularValueDecomposition.isFeatureLabelUniquie(string);
    }

    public String renameFeatureLabel(String string, String string2) throws Exception {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        String string3 = SingularValueDecomposition.renameFeatureLabel(connectionFolder, this._userName, this._modelName, string, string2);
        return string3;
    }

    public void load() throws SQLException, InterruptedException {
        Object object;
        this._modelViewerState1 = new ModelViewerState1(this._context);
        this._modelViewerState1.load();
        this._modelName = this._modelViewerState1.getModelName();
        this._userName = this._modelViewerState1.getUserName();
        while (SingularValueDecomposition.isLoading()) {
            theLogger.log(Level.FINEST, "waiting");
            this.wait(100L);
        }
        if (SingularValueDecomposition.isFeatureIdSingularMapEmpty()) {
            object = ConnectionFolder.getConnectionFolder(this._context);
            SingularValueDecomposition.loadSingularValues((ConnectionManager)object, this._userName, this._modelName);
        }
        object = SingularValueDecomposition.getFeatureIdSingularValueMap();
        Vector<SVDCoefficientRowData> vector = new Vector<SVDCoefficientRowData>();
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            Double d = (Double)entry.getValue();
            SVDCoefficientRowData sVDCoefficientRowData = new SVDCoefficientRowData(string, d);
            vector.add(sVDCoefficientRowData);
        }
        Collections.sort(vector);
        this._model = new SingularValuesTableModel();
        this._model.addRows(vector);
        this._loaded = true;
    }

    public SingularValuesTableModel getModel() {
        return this._model;
    }

    public void clearRows() {
        this._model.clearRows();
    }

    public String getModelName() {
        return this._modelName;
    }

    public String getUserName() {
        return this._userName;
    }
}

