/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.pca;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientEditor;
import oracle.dmt.dataminer.mviewer.pca.PCAValuesTableModel;
import oracle.dmt.dataminer.mviewer.pca.RenameFeaturePanel;
import oracle.dmt.dataminer.mviewer.pca.ScreePlotEditor;
import oracle.dmt.dataminer.mviewer.pca.ScreePlotLrb;
import oracle.dmt.dataminer.mviewer.pca.ScreePlotViewerState;
import oracle.dmt.dataminer.mviewer.svd.SVDLrb;
import oracle.dmt.dataminer.navigator.RefreshController;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.ComponentWithTitlebar;

public class ScreePlotMainPanel
extends DataMinerViewGUI {
    private ScreePlotViewerState _state;
    private BlockingComponent overLayPanel = null;
    private JPanel _jDetailPanel;
    private DataMinerTablePanel detailTablePanel;
    private ComponentWithTitlebar<JComponent> jComponentWithTitlebar;
    private JPanel jGraphPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSplitPane jSplitPane1;
    private JButton renameBtn;
    private GraphPanel _graphPanel;

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public ScreePlotMainPanel(Editor editor, Context context) {
        super(editor, context);
        this._state = new ScreePlotViewerState(context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jDetailPanel = new JPanel();
        this.jComponentWithTitlebar = new ComponentWithTitlebar();
        this.renameBtn = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.detailTablePanel = new DataMinerTablePanel();
        this.jGraphPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        GroupLayout groupLayout = new GroupLayout(this._jDetailPanel);
        this._jDetailPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 664, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jComponentWithTitlebar, GroupLayout.Alignment.TRAILING, -1, 664, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 76, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jComponentWithTitlebar, GroupLayout.Alignment.TRAILING, -1, 76, Short.MAX_VALUE)));
        this.renameBtn.setText("jButton1");
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.4);
        this.jSplitPane1.setRightComponent(this.detailTablePanel);
        GroupLayout groupLayout2 = new GroupLayout(this.jGraphPanel);
        this.jGraphPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 664, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 148, Short.MAX_VALUE));
        this.jSplitPane1.setTopComponent(this.jGraphPanel);
        this.jLabel1.setText("Number of Features:");
        this.jLabel2.setText("50");
        this.jLabel3.setText("Suggested Cutoff Value:");
        this.jLabel4.setText("10");
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -2, 0, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 122, -2).addComponent(this.jLabel3, -2, 134, -2)).addGap(26, 26, 26).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -2, 82, -2)).addGap(414, 414, 414)));
        groupLayout3.linkSize(0, this.jLabel1, this.jLabel3);
        groupLayout3.linkSize(0, this.jLabel2, this.jLabel4);
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 411, Short.MAX_VALUE)));
    }

    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabel1, (Component)this.jLabel2, (String)ScreePlotLrb.get("NUMBER_OF_FEATURES_LABEL"));
        this.jLabel1.getAccessibleContext().setAccessibleName(ScreePlotLrb.get("NUMBER_OF_FEATURES_LABEL"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(ScreePlotLrb.get("NUMBER_OF_FEATURES_LABEL_ADA"));
        ResourceUtils.resLabel((JLabel)this.jLabel3, (Component)this.jLabel4, (String)ScreePlotLrb.get("SUGGESTED_CUTOFF_VALUE_LABEL"));
        this.jLabel3.getAccessibleContext().setAccessibleName(ScreePlotLrb.get("SUGGESTED_CUTOFF_VALUE_LABEL"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(ScreePlotLrb.get("SUGGESTED_CUTOFF_VALUE_LABEL_ADA"));
    }

    @Override
    public void initUI() {
        ListSelectionModel listSelectionModel = this.detailTablePanel.getTable().getSelectionModel();
        this.detailTablePanel.getTable().setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ScreePlotMainPanel.this.renameBtn.setEnabled(-1 != listSelectionEvent.getFirstIndex());
            }
        });
        this.addCustomButons();
        this.detailTablePanel.setTitle("");
        this.detailTablePanel.getTable().setNoEntryInstructionText(CommonLrb.get("COMMON_LOADING"));
        this.detailTablePanel.addControlBarComponents(this.renameBtn);
        this.detailTablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    ScreePlotMainPanel.this.rename();
                }
            }
        });
        this.createMessagePanel(ScreePlotLrb.get("SCREE_PLOT_LOADING_MESG"));
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public void reload() {
        this.initUI();
    }

    protected void addCustomButons() {
        this.renameBtn.setText(ScreePlotLrb.get("RENAME_FEATURE_BUTTON"));
        this.renameBtn.setToolTipText(ScreePlotLrb.get("RENAME_FEATURE_BUTTON_TOOL_TIP"));
        this.renameBtn.setEnabled(true);
        if (this.renameBtn.getActionListeners() == null || this.renameBtn.getActionListeners().length == 0) {
            this.renameBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScreePlotMainPanel.this.rename();
                }
            });
        }
        this.renameBtn.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rename() {
        int[] nArray = this.detailTablePanel.getTable().getSelectedRowsInModel();
        String string = this._state.getModel().getDataVector().get(nArray[0]).getAttributeName();
        RenameFeaturePanel renameFeaturePanel = new RenameFeaturePanel(this._context, this._state, string);
        if (renameFeaturePanel.showAsDialog(this)) {
            Cursor cursor = this.getCursor();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                String string2 = this._state.renameFeatureLabel(renameFeaturePanel.getCurrentName(), string);
                ((PCAValuesTableModel)((Object)this.detailTablePanel.getTable().getModel())).updateFeatureID(string2, string, nArray[0]);
                this._state.updateFeature(string, string2);
                this.updateGraph();
                ScreePlotEditor screePlotEditor = (ScreePlotEditor)this.getEditor();
                RefreshController.getInstance().forceRefreshInSiblingEditors(screePlotEditor.getParentNodeId(), screePlotEditor);
                this.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
            }
            catch (Exception exception) {
                try {
                    if (exception.getMessage().equals(ScreePlotLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"))) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)ScreePlotLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"), (String)ScreePlotLrb.get("FEATURE_RENAME_FAILURE_TITLE"), null);
                    } else {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ScreePlotLrb.get("FEATURE_RENAME_FAILURE_TITLE"), (String)ScreePlotLrb.get("FEATURE_RENAME_FAILURE_MESG"), null);
                    }
                    this.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                }
                catch (Throwable throwable) {
                    this.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
            }
        }
    }

    protected void refreshActiveSVDCoefficientsEditor() {
        List list = EditorManager.getEditorManager().findEditors(this._context);
        for (Object e : list) {
            if (!(e instanceof CoefficientEditor)) continue;
            CoefficientEditor coefficientEditor = (CoefficientEditor)e;
            coefficientEditor.refresh(this._state.getUserName(), this._state.getModelName());
        }
    }

    public void createMessagePanel(String string) {
        this.jGraphPanel.removeAll();
        this.jGraphPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont((float)font.getSize() * 2.0f);
        jLabel.setFont(font2);
        int n = this.jGraphPanel.getGraphics() != null ? this.jGraphPanel.getGraphics().getFontMetrics(font2).stringWidth(string) : 400;
        jPanel.add(Box.createHorizontalStrut(n / 2));
        jPanel.add(jLabel);
        this.jGraphPanel.add((Component)jPanel, "Center");
        this.jGraphPanel.updateUI();
    }

    private void updateGraph() {
        this._graphPanel.initGraph(this._state.getGraphDataModel());
        this._graphPanel.getGraph().setMarkerDisplayed(false);
        this._graphPanel.getGraph().setLineDataLineDisplayed(true);
        this._graphPanel.refreshGraph();
        this.jGraphPanel.removeAll();
        this.jGraphPanel.setLayout(new BorderLayout());
        this.jGraphPanel.add((Component)this._graphPanel, "Center");
        this.jGraphPanel.updateUI();
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        protected Object doInBackground() throws Exception {
            try {
                ScreePlotMainPanel.this.detailTablePanel.getTable().setNoEntryInstructionText(CommonLrb.get("COMMON_LOADING"));
                ScreePlotMainPanel.this._state.load("");
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return ScreePlotMainPanel.this._state;
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    ScreePlotMainPanel.this._graphPanel = new GraphPanel(ScreePlotMainPanel.this._state.getGraphDataModel());
                    ScreePlotMainPanel.this._graphPanel.initGraph();
                    ScreePlotMainPanel.this._graphPanel.getGraph().setMarkerDisplayed(false);
                    ScreePlotMainPanel.this._graphPanel.getGraph().setLineDataLineDisplayed(true);
                    ScreePlotMainPanel.this._graphPanel.updateGraphStyle();
                    ScreePlotMainPanel.this.jGraphPanel.removeAll();
                    ScreePlotMainPanel.this.jGraphPanel.setLayout(new BorderLayout());
                    ScreePlotMainPanel.this.jGraphPanel.add((Component)ScreePlotMainPanel.this._graphPanel, "Center");
                    ScreePlotMainPanel.this.jGraphPanel.updateUI();
                    ScreePlotMainPanel.this.jLabel2.setText(String.valueOf(ScreePlotMainPanel.this._state.getNumberOfFeatures()));
                    ScreePlotMainPanel.this.jLabel4.setText(ScreePlotMainPanel.this._state.getSuggetsedCutofValue());
                    ScreePlotMainPanel.this.detailTablePanel.setup((TableModel)((Object)ScreePlotMainPanel.this._state.getModel()), null, 0);
                } else {
                    ScreePlotMainPanel.this.detailTablePanel.getTable().setNoEntryInstructionText(SVDLrb.get("SINGULAR_VALUES_FAILURE"));
                    ScreePlotMainPanel.this._state.clearRows();
                }
            }
            catch (Exception exception) {
                this._ex = exception;
            }
            finally {
                if (this._ex != null) {
                    DataMinerEditor.handleEditorException(ScreePlotMainPanel.this.getEditor().getContext(), this._ex, ScreePlotLrb.get("SCREE_PLOT_FAILURE_TITLE"), ScreePlotLrb.get("SCREE_PLOT_FAILURE_MESG"));
                }
                ScreePlotMainPanel.this.setLoading(false);
                if (ScreePlotMainPanel.this.overLayPanel != null) {
                    ScreePlotMainPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

