/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.pca;

import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.mviewer.pca.ScreePlotLrb;
import oracle.dmt.dataminer.mviewer.pca.ScreePlotViewerState;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class RenameFeaturePanel
extends DialogDisplayer<AbstractNode> {
    private String _currentName;
    private ScreePlotViewerState state;
    private JLabel _jRenameLabel;
    private JTextField _jRenameValue;

    public RenameFeaturePanel(Context context, ScreePlotViewerState screePlotViewerState, String string) {
        super(context, null);
        this._currentName = string;
        this.state = screePlotViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jRenameLabel = new JLabel();
        this._jRenameValue = new JTextField();
        this._jRenameLabel.setText("Rename To:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jRenameLabel, -2, 108, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jRenameValue, -1, 268, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jRenameLabel).addComponent(this._jRenameValue, -2, -1, -2)).addContainerGap(33, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jRenameLabel, (Component)this._jRenameValue, (String)ScreePlotLrb.get("FEATURE_RENAME_TO_LABEL"));
        this._jRenameLabel.getAccessibleContext().setAccessibleDescription(ScreePlotLrb.get("FEATURE_RENAME_TO_LABEL_ADA"));
        this._jRenameValue.setDocument(new TextFieldLimit(30));
    }

    @Override
    public void initUI() {
        this._jRenameValue.setText(this._currentName);
    }

    @Override
    public boolean doWork() {
        String string = this._jRenameValue.getText().trim();
        if (string.isEmpty()) {
            MessageDialog.error((Component)this.getDialogInstance(), (Object)ScreePlotLrb.get("FEATURE_NAME_EMPTY"), (String)ScreePlotLrb.get("FEATURE_ERROR_TITLE"), null);
            return false;
        }
        if (string.length() > 4000) {
            MessageDialog.error((Component)this.getDialogInstance(), (Object)ScreePlotLrb.get("FEATURE_NAME_TOO_LONG"), (String)ScreePlotLrb.get("FEATURE_ERROR_TITLE"), null);
            return false;
        }
        if (string.equals(this._currentName)) {
            MessageDialog.information((Component)this.getDialogInstance(), (Object)ScreePlotLrb.get("FEATURE_NAME_ALEADY_USED"), (String)ScreePlotLrb.get("FEATURE_ERROR_TITLE"), null);
            return false;
        }
        if (!this.state.isFeatureLabelUniquie(string)) {
            MessageDialog.information((Component)this.getDialogInstance(), (Object)ScreePlotLrb.get("FEATURE_NAME_ALEADY_USED"), (String)ScreePlotLrb.get("FEATURE_ERROR_TITLE"), null);
            return false;
        }
        this._currentName = string;
        return true;
    }

    public String getCurrentName() {
        return this._currentName;
    }

    @Override
    protected String getDialogTitle() {
        StringBuilder stringBuilder = new StringBuilder(ScreePlotLrb.get("FEATURE_RENAME_FEATURE"));
        stringBuilder.append(": ");
        stringBuilder.append(this._currentName);
        return stringBuilder.toString();
    }

    @Override
    protected String getHelpTopic() {
        return "renameFeature.htm";
    }
}

