/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.compare;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.renderers.ComboBoxListRenderer;
import oracle.dmt.dataminer.filter.FilterConsumer;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.compare.CoefCompareMainPanel;
import oracle.dmt.dataminer.mviewer.compare.CompareLrb;
import oracle.dmt.dataminer.mviewer.compare.CompareState;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.server.model.CompareFilterSetting;
import oracle.dmt.dataminer.workflow.DataMinerViewListenerAdapter;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class CompareFilterPanel
extends JPanel
implements DataminerGUIPanel {
    private static final Logger theLogger = Logger.getLogger(CompareFilterPanel.class.getName());
    private CompareState _state;
    private View _consumerView;
    private boolean _loaded;
    private CoefCompareMainPanel _mainPanel;
    private CompareFilterSetting _coefFilterSetting;
    private Context _context;
    public static final String FILTER_SETTING_PROPERTY = "FILTER_SETTING_PROPERTY";
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private JCheckBox _jAbsoluteValueFilter;
    private JButton _jApplyFilterButton;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private JComboBox _jTargetValueComboOne;
    private JComboBox _jTargetValueComboTwo;
    private JLabel _jTargetValueLabelOne;
    private JLabel _jTargetValueLabelTwo;
    private ModelViewerPartitionToolbar modelViewerPartitionToolbar1;

    public CompareFilterPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public CompareFilterPanel(CoefCompareMainPanel coefCompareMainPanel, Context context, CompareState compareState) {
        try {
            this._mainPanel = coefCompareMainPanel;
            this._context = context;
            this._state = compareState;
            this.initComponents();
            this.initRes();
            this.initUI();
            this.initializeUIState();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public JPanel getUIComponent() {
        return this;
    }

    private void initComponents() {
        this._jTargetValueLabelOne = new JLabel();
        this._jTargetValueComboOne = new JComboBox();
        this._jApplyFilterButton = new JButton();
        this._jTargetValueLabelTwo = new JLabel();
        this._jTargetValueComboTwo = new JComboBox();
        this._jFetchSize = new JSpinner();
        this._jFetchSizeLabel = new JLabel();
        this._jAbsoluteValueFilter = new JCheckBox();
        this.modelViewerPartitionToolbar1 = new ModelViewerPartitionToolbar();
        this._jTargetValueLabelOne.setText("Target Value 1:");
        this._jTargetValueComboOne.setModel(new DefaultComboBoxModel<String>(new String[]{"", ""}));
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        this._jTargetValueLabelTwo.setText("Target Value 2:");
        this._jTargetValueComboTwo.setModel(new DefaultComboBoxModel<String>(new String[]{"", ""}));
        this._jFetchSize.setMaximumSize(new Dimension(87, 20));
        this._jFetchSize.setMinimumSize(new Dimension(87, 20));
        this._jFetchSize.setPreferredSize(new Dimension(87, 20));
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jFetchSizeLabel.setMaximumSize(new Dimension(64, 14));
        this._jFetchSizeLabel.setMinimumSize(new Dimension(64, 14));
        this._jFetchSizeLabel.setPreferredSize(new Dimension(64, 14));
        this._jAbsoluteValueFilter.setText("Sort By Absolute Value");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._jTargetValueLabelOne, -1, 91, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetValueComboOne, -2, 152, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._jTargetValueLabelTwo, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetValueComboTwo, -2, 149, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.modelViewerPartitionToolbar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this._jFetchSizeLabel, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._jAbsoluteValueFilter, -2, 224, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this._jFetchSize, -2, -1, -2).addComponent(this._jApplyFilterButton, -2, 110, -2)).addContainerGap()));
        groupLayout.linkSize(0, this._jTargetValueLabelOne, this._jTargetValueLabelTwo);
        groupLayout.linkSize(0, this._jTargetValueComboOne, this._jTargetValueComboTwo);
        groupLayout.linkSize(0, this._jApplyFilterButton, this._jFetchSize);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jTargetValueLabelOne).addComponent(this._jTargetValueComboOne, -2, -1, -2).addComponent(this._jTargetValueLabelTwo).addComponent(this._jTargetValueComboTwo, -2, 22, -2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jApplyFilterButton, -2, -1, -2).addComponent(this._jAbsoluteValueFilter))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFetchSize, -2, -1, -2).addComponent(this._jFetchSizeLabel, -2, -1, -2)).addComponent(this.modelViewerPartitionToolbar1, GroupLayout.Alignment.TRAILING, -2, -1, -2))));
    }

    @Override
    public void initRes() {
        if (this.isAnomaly()) {
            this._jTargetValueLabelOne.setVisible(false);
            this._jTargetValueLabelTwo.setVisible(false);
        } else {
            ResourceUtils.resLabel((JLabel)this._jTargetValueLabelOne, (Component)this._jTargetValueComboOne, (String)CompareLrb.get("TARGET_VALUE_1"));
            this._jTargetValueLabelOne.getAccessibleContext().setAccessibleName(CompareLrb.get("TARGET_VALUE_1"));
            this._jTargetValueLabelOne.getAccessibleContext().setAccessibleDescription(CompareLrb.get("TARGET_VALUE_ADA"));
            ResourceUtils.resLabel((JLabel)this._jTargetValueLabelTwo, (Component)this._jTargetValueComboTwo, (String)CompareLrb.get("TARGET_VALUE_2"));
            this._jTargetValueLabelTwo.getAccessibleContext().setAccessibleName(CompareLrb.get("TARGET_VALUE_2"));
            this._jTargetValueLabelTwo.getAccessibleContext().setAccessibleDescription(CompareLrb.get("TARGET_VALUE_ADA"));
        }
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)CompareLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(CompareLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(CompareLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)CompareLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(CompareLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(CompareLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(CompareLrb.get("FETCH_SIZE_ADA") + "\n" + CompareLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1000));
        ResourceUtils.resButton((AbstractButton)this._jAbsoluteValueFilter, (String)CompareLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleName(CompareLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleDescription(CompareLrb.get("ABSOLUTE_VALUE_ADA"));
        this._jAbsoluteValueFilter.setToolTipText(CompareLrb.get("ABSOLUTE_VALUE_ADA"));
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    private void _jAbsoluteValueFilter_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this._state.setSortByAbsoluteValue(this._jAbsoluteValueFilter.isSelected());
        this._coefFilterSetting.setFilterByAbsolute(this._jAbsoluteValueFilter.isSelected());
    }

    private void setLoading(boolean bl) {
        this._mainPanel.updateLoading(bl);
    }

    @Override
    public void initUI() {
        this.setLocale(this._jFetchSize, Locale.getDefault());
        this.enableAllControls(false);
        this.addListeners();
        ((GroupLayout)this.getLayout()).invalidateLayout(this);
        if (this.isNB()) {
            this._jAbsoluteValueFilter.setVisible(false);
        }
        if (this._mainPanel.isModelPartitioned()) {
            this.modelViewerPartitionToolbar1.setEditor(this._mainPanel.getEditor());
            this.modelViewerPartitionToolbar1.setVisible(true);
        } else {
            this.modelViewerPartitionToolbar1.setVisible(false);
        }
    }

    public String getSelectedParitionId() {
        if (this._mainPanel.isModelPartitioned()) {
            return this.modelViewerPartitionToolbar1.getSelectedPartitionID();
        }
        return "";
    }

    public PartitionVO getPartitionVO() {
        return this.modelViewerPartitionToolbar1.getPartitionVO();
    }

    private boolean isAnomaly() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        if (modelNode instanceof ANModelNode) {
            return ((ANModelNode)modelNode).isLinearKernel() != false;
        }
        return false;
    }

    private boolean isNB() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof NBModelNode;
    }

    public void setupUI(CompareFilterSetting compareFilterSetting) {
        this._coefFilterSetting = compareFilterSetting;
        this.loadStateAttributes();
        this.enableAllControls(true);
        this.requestFocusInWindow();
        this.setLoaded(true);
    }

    public void setupUI(View view) {
        if (this._consumerView == view) {
            return;
        }
        if (view == null) {
            return;
        }
        FilterConsumer filterConsumer = (FilterConsumer)view;
        this._consumerView = view;
        if (!filterConsumer.isLoaded()) {
            this._consumerView = view;
            return;
        }
        this.setupUIDetail();
    }

    private void initializeUIState() throws Exception {
        this._coefFilterSetting = new CompareFilterSetting();
        this.loadStateAttributes();
    }

    private void setupUIDetail() {
        FilterConsumer filterConsumer = (FilterConsumer)this._consumerView;
        this._coefFilterSetting = (CompareFilterSetting)filterConsumer.getCachedFilterState();
        assert (this._coefFilterSetting != null) : "Coefficient Filter Setting state is null.";
        this.loadStateAttributes();
        this.enableAllControls(true);
        this.setLoaded(true);
    }

    public void unloadUI() throws Exception {
        this.enableAllControls(false);
        if (this._consumerView == null) {
            return;
        }
        this.updateInput();
        ((FilterConsumer)this._consumerView).setCachedFilterState(this._coefFilterSetting);
        this.clearState();
        this.setLoaded(false);
    }

    public void updateInput() throws Exception {
        Number number = this.getNumber(this._jFetchSize);
        this._coefFilterSetting.setFetchSize(number.intValue());
        this._coefFilterSetting.setUseFilterSpecification(false);
    }

    private void clearState() {
        this._consumerView = null;
        this.resetUIAttributes();
        this._jApplyFilterButton.setEnabled(false);
        this._coefFilterSetting = null;
    }

    private void resetUIAttributes() {
        this.setNumber(this._jFetchSize, this._modelViewerPrefenceSettings.getFetchSizeOtherModels());
    }

    private void enableAllControls(boolean bl) {
        this._jApplyFilterButton.setEnabled(bl);
        if (!this.isAnomaly()) {
            this._jTargetValueComboOne.setEnabled(bl);
            this._jTargetValueComboTwo.setEnabled(bl);
            this._jTargetValueLabelOne.setEnabled(bl);
            this._jTargetValueLabelTwo.setEnabled(bl);
        } else {
            this._jTargetValueComboOne.setVisible(false);
            this._jTargetValueComboTwo.setVisible(false);
            this._jTargetValueLabelOne.setVisible(false);
            this._jTargetValueLabelTwo.setVisible(false);
        }
        this._jFetchSize.setEnabled(bl);
        this._jFetchSizeLabel.setEnabled(bl);
    }

    public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
        this._jApplyFilterButton.setEnabled(true);
        if (!this.isLoaded() && this._consumerView != null) {
            this.setupUIDetail();
        }
    }

    public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
        this._jApplyFilterButton.setEnabled(false);
    }

    private void loadStateAttributes() {
        if (this._coefFilterSetting.getViewerState() != null) {
            this.setNumber(this._jFetchSize, this._modelViewerPrefenceSettings.getFetchSizeOtherModels());
            this._jAbsoluteValueFilter.setSelected(this._coefFilterSetting.getFilterAndSortByAbsolute());
        }
    }

    private void addListeners() {
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareFilterPanel.this._jApplyFilterButton_actionPerformed(actionEvent);
            }
        });
        this._jTargetValueComboOne.setRenderer(new ComboBoxListRenderer());
        this._jTargetValueComboOne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareFilterPanel.this._jTargetValueComboOne_actionPerformed(actionEvent);
            }
        });
        this._jTargetValueComboTwo.setRenderer(new ComboBoxListRenderer());
        this._jTargetValueComboTwo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareFilterPanel.this._jTargetValueComboTwo_actionPerformed(actionEvent);
            }
        });
        this._jAbsoluteValueFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareFilterPanel.this._jAbsoluteValueFilter_actionPerformed(actionEvent);
            }
        });
        this._mainPanel.addDataMinerViewListener(new DataMinerViewListenerAdapter(){

            @Override
            public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
                CompareFilterPanel.this.enableAllControls(true);
            }

            @Override
            public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
                CompareFilterPanel.this.enableAllControls(false);
            }
        });
    }

    private void _jTargetValueComboOne_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this.setLoading(true);
        Object object = this._jTargetValueComboOne.getSelectedItem();
        this._state.setSelectedTargetClass(object);
        ComboBoxModel comboBoxModel = this._jTargetValueComboOne.getModel();
        ComboBoxModel comboBoxModel2 = this._jTargetValueComboTwo.getModel();
        Object object2 = comboBoxModel2.getSelectedItem();
        boolean bl = false;
        Vector vector = new Vector();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            Object e = comboBoxModel.getElementAt(i);
            if (e.equals(object)) {
                if (!object2.equals(object)) continue;
                bl = true;
                continue;
            }
            vector.add(e);
        }
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
        this._jTargetValueComboTwo.setModel(defaultComboBoxModel);
        if (bl) {
            this._state.setSecondSelectedTargetClass(this._jTargetValueComboTwo.getItemAt(0));
            this._jTargetValueComboTwo.setSelectedItem(this._state.getSecondSelectedTargetClass());
        } else {
            this._jTargetValueComboTwo.setSelectedItem(object2);
        }
        this.prepareReload();
    }

    void prepareReload() {
        this._mainPanel.prepareReload();
    }

    void updateTargetCombos() {
        if (this.isAnomaly()) {
            return;
        }
        Vector<Object> vector = this._state.getTargetPredictions();
        Object object = this._state.getSelectedTargetClass();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
        this._jTargetValueComboOne.setModel(defaultComboBoxModel);
        if (object instanceof Number) {
            this._jTargetValueComboOne.setSelectedItem(object);
        } else {
            this._jTargetValueComboOne.setSelectedItem(object.toString());
        }
        Vector<Object> vector2 = new Vector<Object>();
        for (Object object2 : vector) {
            if (object2 instanceof Number ? object2.equals(object) : object2.equals(object.toString())) continue;
            vector2.add(object2);
        }
        DefaultComboBoxModel defaultComboBoxModel2 = new DefaultComboBoxModel(vector2);
        this._jTargetValueComboTwo.setModel(defaultComboBoxModel2);
        if (this._state.getSecondSelectedTargetClass() instanceof Number) {
            this._jTargetValueComboTwo.setSelectedItem(this._state.getSecondSelectedTargetClass());
        } else {
            this._jTargetValueComboTwo.setSelectedItem(this._state.getSecondSelectedTargetClass().toString());
        }
    }

    private void _jTargetValueComboTwo_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this.setLoading(true);
        this._state.setSecondSelectedTargetClass(this._jTargetValueComboTwo.getSelectedItem());
        this.prepareReload();
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this._jApplyFilterButton.setEnabled(false);
            ValidateUpdateState validateUpdateState = new ValidateUpdateState();
            validateUpdateState.setTitle(CompareLrb.get("FILTER_PROCESS_TITLE"));
            validateUpdateState.setMessage(CompareLrb.get("FILTER_PROCESS_MESG"));
            validateUpdateState.setCancelable(false);
            validateUpdateState.start(true);
            if (validateUpdateState.getException() != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)validateUpdateState.getException(), (String)CompareLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CompareLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
                this.enableAllControls(true);
            }
            if (validateUpdateState.getValidation()) {
                this._mainPanel.setFilterState(this._coefFilterSetting);
            } else {
                this.enableAllControls(true);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CompareLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CompareLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            this.enableAllControls(true);
        }
    }

    private void setNumber(JSpinner jSpinner, Number number) {
        jSpinner.setValue(number);
    }

    private void setLocale(JSpinner jSpinner, Locale locale) {
        jSpinner.setLocale(locale);
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    private void setLoaded(boolean bl) {
        this._loaded = bl;
    }

    class ValidateUpdateState
    extends ProgressRunnable {
        private Exception _exception;
        private Boolean _validated;
        private boolean _canceled = false;

        ValidateUpdateState() {
        }

        public boolean getValidation() {
            return this._validated;
        }

        public Exception getException() {
            return this._exception;
        }

        protected Object doWork() throws Exception {
            Number number;
            block5: {
                this._validated = false;
                number = CompareFilterPanel.this.getNumber(CompareFilterPanel.this._jFetchSize);
                if (null != number && number.longValue() > 0L) break block5;
                this._validated = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareLrb.get("FETCH_SIZE_RANGE_ERROR"), (String)CompareLrb.get("COEFFICIENT_ERROR_TITLE"), null);
                Boolean bl = this._validated;
                return bl;
            }
            try {
                this._validated = true;
                CompareFilterPanel.this._coefFilterSetting.setFetchSize(number.intValue());
            }
            catch (Exception exception) {
                this._exception = exception;
                this._validated = false;
            }
            return this._validated;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

