/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.mviewer.clustering.component.ComponentLrb;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ClusterComponentDataTableModel
extends GenericBaseTableModel {
    static Vector<String> _colNames = new Vector();
    public static final int _COLUMN_VALUE = 0;
    public static final int _COLUMN_FREQUENCY = 1;
    private static final int COLUMN_COUNT = 2;
    private List<NameValuePair> _data = new ArrayList<NameValuePair>();

    public void clearTable() {
        if (this._data != null) {
            for (int i = 0; i < this._data.size(); ++i) {
                this._data.get(i).setValue(0);
            }
        }
    }

    public ClusterComponentDataTableModel() {
        this.setColumnIdentifiers(_colNames);
        this.setColumnCount(2);
    }

    public ClusterComponentDataTableModel(List<NameValuePair> list) {
        this.setDataList(list);
        this.setColumnIdentifiers(_colNames);
        this.setColumnCount(2);
    }

    public void setDataList(List<NameValuePair> list) {
        if (list != null && !list.isEmpty()) {
            this._data.addAll(list);
            this.setRowCount(this._data.size());
        }
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        NameValuePair nameValuePair = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = nameValuePair.getName();
                break;
            }
            case 1: {
                object = nameValuePair.getValue();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing cluster details";
                break;
            }
        }
        return object != null ? object : "";
    }

    public void loadData(List<NameValuePair> list) {
        this._data.clear();
        this.setDataList(list);
        this.fireTableDataChanged();
    }

    static {
        _colNames.add(ComponentLrb.get("CLUSTER_COMPONENT_DATA_TABLE_COLUMN_VALUE"));
        _colNames.add(ComponentLrb.get("CLUSTER_COMPONENT_DATA_TABLE_COLUMN_SUBNAME"));
    }
}

