/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.server.model.AssociationRules;
import oracle.dmt.dataminer.server.model.FilterItemSet;
import oracle.dmt.dataminer.server.model.Item;
import oracle.dmt.dataminer.server.model.ItemSet;
import oracle.dmt.dataminer.server.model.ItemSetFilterSetting;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.ide.Context;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ARItemTableModel
extends GenericBaseTableModel {
    public static final int NAME = 0;
    public static final int VALUE = 1;
    public static final int SUPPORT = 2;
    public static final int FILTER_WITHOUT_SUPPORT = 2;
    public static final int FILTER = 3;
    private Vector<FilterItemSet> _data = new Vector(1000, 500);
    private ARItemTableModel _filteredItems;
    private Context _context;
    private AssociationRules _model;
    private ItemSetFilterSetting _filterSetting;
    private boolean _includeSupportColumn = true;
    private NAME_DISPLAY _nameDisplay = NAME_DISPLAY.NAME_SUBNAME;
    private String[] COLUMN_NAMES = new String[]{ARRulesLrb.get("ADD_ITEM_NAME_COLUMN"), ARRulesLrb.get("ADD_ITEM_VALUE_COLUMN"), ARRulesLrb.get("ADD_ITEM_SUPPORT_COLUMN"), ARRulesLrb.get("ADD_ITEM_FILTER_COLUMN")};
    private String[] COLUMNS_WITHOUT_SUPPORT = new String[]{ARRulesLrb.get("ADD_ITEM_NAME_COLUMN"), ARRulesLrb.get("ADD_ITEM_VALUE_COLUMN"), ARRulesLrb.get("ADD_ITEM_FILTER_COLUMN")};

    public boolean isIncludeSupportColumn() {
        return this._includeSupportColumn;
    }

    public void setNameDisplay(NAME_DISPLAY nAME_DISPLAY) {
        this._nameDisplay = nAME_DISPLAY;
    }

    public NAME_DISPLAY getNameDisplay() {
        return this._nameDisplay;
    }

    public ARItemTableModel(boolean bl) {
        this(new Vector<FilterItemSet>(0), bl);
    }

    public ARItemTableModel(Vector<FilterItemSet> vector, boolean bl) {
        this._includeSupportColumn = bl;
        if (this._includeSupportColumn) {
            this.setColumnIdentifiers(this.COLUMN_NAMES);
        } else {
            this.setColumnIdentifiers(this.COLUMNS_WITHOUT_SUPPORT);
        }
        this._data = vector;
        this.setRowCount(vector.size());
    }

    public ARItemTableModel(Context context, AssociationRules associationRules, ItemSetFilterSetting itemSetFilterSetting, ARItemTableModel aRItemTableModel, boolean bl) {
        this._includeSupportColumn = bl;
        if (this._includeSupportColumn) {
            this.setColumnIdentifiers(this.COLUMN_NAMES);
        } else {
            this.setColumnIdentifiers(this.COLUMNS_WITHOUT_SUPPORT);
        }
        this.setRowCount(0);
        this._context = context;
        this._model = associationRules;
        this._filterSetting = itemSetFilterSetting;
        this._filteredItems = aRItemTableModel;
    }

    public void load(String string) throws Exception {
        assert (this._model != null) : "Model is null, unable to load.";
        assert (this._context != null) : "Context is null, unable to load.";
        Vector<Object> vector = new Vector();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        vector = this._model.getItemSets((ConnectionManager)connectionFolder, this._model.getUserName(), this._model.getModelName(), this._filterSetting, string);
        this._data = vector;
        this.removeExistingFilteredItems();
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    private void removeExistingFilteredItems() {
        Vector<FilterItemSet> vector = this._filteredItems.getDataVector();
        Iterator<FilterItemSet> iterator = vector.iterator();
        Vector<FilterItemSet> vector2 = new Vector<FilterItemSet>();
        block0: while (iterator.hasNext()) {
            Iterator<FilterItemSet> iterator2 = this._data.iterator();
            FilterItemSet filterItemSet = iterator.next();
            Item item = filterItemSet.getItems().get(0);
            while (iterator2.hasNext()) {
                FilterItemSet filterItemSet2 = iterator2.next();
                Item item2 = filterItemSet2.getItems().get(0);
                if (!item.getFullAttributeName().equals(item2.getFullAttributeName())) continue;
                if (item.getValue() == null && item.getValue() == null) {
                    vector2.add(filterItemSet2);
                    continue block0;
                }
                if (item.getValue() == null || item.getValue() == null || !item.getValue().equals(item2.getValue())) continue;
                vector2.add(filterItemSet2);
                continue block0;
            }
        }
        this._data.removeAll(vector2);
    }

    public void addRows(Vector<FilterItemSet> vector) {
        for (FilterItemSet filterItemSet : vector) {
            this.getDataVector().add(filterItemSet);
        }
    }

    public int getRowCount() {
        if (this._data == null) {
            return 0;
        }
        return this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public ItemSet getRow(int n) {
        return this._data.get(n);
    }

    public void addSelection(ARItemTableModel aRItemTableModel, int[] nArray) {
        Vector<FilterItemSet> vector = aRItemTableModel.getDataVector();
        FilterItemSet filterItemSet = null;
        for (int i = 0; i < nArray.length; ++i) {
            filterItemSet = vector.elementAt(nArray[i]);
            this._data.add(filterItemSet);
        }
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public void setFilterActionForAll(int n) {
        for (FilterItemSet filterItemSet : this._data) {
            filterItemSet.setFilterAction(n);
        }
    }

    public void setFilterActionForSelected(int n, int[] nArray) {
        FilterItemSet filterItemSet = null;
        for (int i = 0; i < nArray.length; ++i) {
            filterItemSet = this._data.elementAt(nArray[i]);
            filterItemSet.setFilterAction(n);
        }
        this.fireTableDataChanged();
    }

    public Vector<FilterItemSet> getDataVector() {
        return this._data;
    }

    public void removeSelectedRows(int[] nArray) {
        Vector<FilterItemSet> vector = new Vector<FilterItemSet>();
        FilterItemSet filterItemSet = null;
        for (int i = 0; i < nArray.length; ++i) {
            filterItemSet = this._data.elementAt(nArray[i]);
            vector.add(filterItemSet);
        }
        this._data.removeAll(vector);
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 3;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        FilterItemSet filterItemSet = this._data.get(n);
        Object object = null;
        Item item = filterItemSet.getItems().get(0);
        switch (n2) {
            case 0: {
                if (this._nameDisplay == NAME_DISPLAY.SUB_NAME_ONLY) {
                    object = item.getAttribute_subname();
                    break;
                }
                if (this._nameDisplay == NAME_DISPLAY.NAME_ONLY) {
                    object = item.getAttribute_name();
                    break;
                }
                if (this._nameDisplay == NAME_DISPLAY.NAME_SUBNAME) {
                    object = item.getFullAttributeName();
                    break;
                }
                object = item.getFullAttributeName();
                break;
            }
            case 1: {
                if (item.getValue() == null) {
                    object = "";
                    break;
                }
                object = item.getValue();
                break;
            }
            case 2: {
                if (this._includeSupportColumn) {
                    if (filterItemSet.getSupport() != null) {
                        object = filterItemSet.getSupport() * 100.0;
                        break;
                    }
                    object = filterItemSet.getSupport();
                    break;
                }
                object = this.getFilterData(filterItemSet);
                break;
            }
            case 3: {
                object = this.getFilterData(filterItemSet);
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing items";
                break;
            }
        }
        return object;
    }

    private Object getFilterData(FilterItemSet filterItemSet) {
        int n = filterItemSet.getFilterAction();
        Object object = n == 0 ? new JLabel(ARRulesLrb.get("FILTER_BOTH"), OracleIcons.getIcon((String)"update.png"), 10) : (n == 1 ? new JLabel(ARRulesLrb.get("FILTER_CONDITION"), OracleIcons.getIcon((String)"forwardDirection.png"), 10) : (n == 2 ? new JLabel(ARRulesLrb.get("FILTER_ASSOCIATION"), OracleIcons.getIcon((String)"from_ref.png"), 10) : "Unknown Action"));
        return object;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 3) {
            FilterItemSet filterItemSet = this._data.get(n);
            JLabel jLabel = (JLabel)object;
            if (ARRulesLrb.get("FILTER_BOTH").equals(jLabel.getText())) {
                filterItemSet.setFilterAction(0);
            } else if (ARRulesLrb.get("FILTER_CONDITION").equals(jLabel.getText())) {
                filterItemSet.setFilterAction(1);
            } else if (ARRulesLrb.get("FILTER_ASSOCIATION").equals(jLabel.getText())) {
                filterItemSet.setFilterAction(2);
            }
        } else {
            this.setValueAt(object, n, n2);
        }
    }

    public void addRow(FilterItemSet filterItemSet) {
        this._data.add(filterItemSet);
    }

    public static enum NAME_DISPLAY {
        SUB_NAME_ONLY,
        NAME_ONLY,
        NAME_SUBNAME;

    }
}

