/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dmt.dataminer.partition.AbstractPartitionToolbar;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.partition.PartitionsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.editor.Editor;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.HyperlinkButton;

public class ModelViewerPartitionToolbar
extends AbstractPartitionToolbar<ModelViewerPartitionToolbar> {
    private static final Map<String, AbstractPartitionToolbar.VirtualInstance<ModelViewerPartitionToolbar>> TOOLBAR_MAP = new HashMap<String, AbstractPartitionToolbar.VirtualInstance<ModelViewerPartitionToolbar>>();
    private JPanel jPanel1;
    private HyperlinkButton jPartitionHyperlink;
    private JLabel jPartitionLabel;
    private JButton jSearchPartitionButton;

    public ModelViewerPartitionToolbar() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        this.jSearchPartitionButton.setIcon(OracleIcons.getIcon((String)"search.png"));
        ResourceUtils.resLabel((JLabel)this.jPartitionLabel, (Component)this.jPartitionHyperlink, (String)PartitionsLrb.get("TOOLBAR_COMPARE_PARTITION"));
    }

    @Override
    public void initUI() {
        this.jSearchPartitionButton.addActionListener(new AbstractPartitionToolbar.SearchPartitionActionListener(this));
        this.jPartitionHyperlink.addActionListener((ActionListener)new AbstractPartitionToolbar.PartitionDetailsActionListener(this));
        this.partitionLink = this.jPartitionHyperlink;
    }

    @Override
    public void setEditor(Editor editor) {
        super.setEditor(editor);
        String string = this.node.getLongLabel();
        AbstractPartitionToolbar.VirtualInstance<ModelViewerPartitionToolbar> virtualInstance = TOOLBAR_MAP.get(string);
        if (virtualInstance != null) {
            this.setVirtualInstance(virtualInstance);
            this.updatePartitionHyperlink();
        } else {
            TOOLBAR_MAP.put(string, this.getVirtualInstance());
            this.updatePartitionHyperlink();
        }
        if (this.node.getRepositoryData() instanceof ModelNodeType.Models.Model) {
            ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)this.node.getRepositoryData();
            this.getVirtualInstance().setModelName(model.getName());
        } else if (this.node.getRepositoryData() instanceof ModelType) {
            ModelType modelType = (ModelType)this.node.getRepositoryData();
            this.getVirtualInstance().setModelName(modelType.getName());
        }
        this.getVirtualInstance().getRelatedToolbars().add(this);
    }

    public void setEditor(Editor editor, PartitionVO partitionVO) {
        this.setEditor(editor);
        PartitionVO partitionVO2 = this.getVirtualInstance().getPartition();
        if (partitionVO2 == null) {
            this.getVirtualInstance().setPartition(partitionVO);
        }
        this.getVirtualInstance().setNode(this.node);
    }

    public PartitionVO getPartitionVO() {
        return this.getVirtualInstance().getPartition();
    }

    @Override
    protected int getComponentsWidth() {
        if (this.componentsWidth == -1) {
            String string = this.jPartitionLabel.getText();
            int n = this.jPartitionLabel.getFontMetrics(this.jPartitionLabel.getFont()).stringWidth(string);
            this.componentsWidth = n + this.jSearchPartitionButton.getPreferredSize().width;
        }
        return this.componentsWidth;
    }

    private void initComponents() {
        this.jPartitionLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jPartitionHyperlink = new HyperlinkButton();
        this.jSearchPartitionButton = new JButton();
        this.setMinimumSize(new Dimension(150, 30));
        this.setPreferredSize(new Dimension(150, 30));
        this.setLayout(new BoxLayout(this, 2));
        this.jPartitionLabel.setText("Partition:");
        this.add(this.jPartitionLabel);
        FlowLayout flowLayout = new FlowLayout(0, 5, 0);
        flowLayout.setAlignOnBaseline(true);
        this.jPanel1.setLayout(flowLayout);
        this.jPartitionHyperlink.setText("None");
        this.jPartitionHyperlink.setHorizontalTextPosition(2);
        this.jPartitionHyperlink.setIconTextGap(2);
        this.jPartitionHyperlink.setMaximumSize(new Dimension(400, 23));
        this.jPartitionHyperlink.setPreferredSize(new Dimension(35, 23));
        this.jPanel1.add((Component)this.jPartitionHyperlink);
        this.jSearchPartitionButton.setIconTextGap(2);
        this.jSearchPartitionButton.setPreferredSize(new Dimension(28, 24));
        this.jPanel1.add(this.jSearchPartitionButton);
        this.add(this.jPanel1);
    }

    public static void setSelectedPartitionForModel(String string, PartitionVO partitionVO) {
        AbstractPartitionToolbar.VirtualInstance<ModelViewerPartitionToolbar> virtualInstance = TOOLBAR_MAP.get(string);
        if (virtualInstance != null) {
            virtualInstance.setPartition(partitionVO);
        } else {
            virtualInstance = new AbstractPartitionToolbar.VirtualInstance(null, partitionVO, null);
            TOOLBAR_MAP.put(string, virtualInstance);
        }
    }
}

