/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.common.vo.TableVO;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.SchemaChooserPane;
import oracle.dmt.dataminer.controls.TableChooserModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.SimpleSearchListener;
import oracle.dmt.dataminer.workflow.TableChooserPreferenceSettings;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizardModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.table.GenericTable;

public class TableChooserPane
extends JPanel
implements DataminerGUIPanel {
    private static final int SEARCH_ALL_NAME = 0;
    private static final int SEARCH_TABLE_NAME = 1;
    private static final int SEARCH_SCHEMA_NAME = 2;
    private TableChooserModel tblChooserModel = null;
    private Context _context;
    private TableVO _selectedTable;
    private boolean _isInitialized = false;
    private boolean _loading = false;
    private String _connectionName;
    private AbstractDataNode _node;
    private TableType _existingSelectedTable;
    private boolean _initialTableLoadComplete = false;
    private DataSourceWizardModel _wizModel;
    private TableChooserPreferenceSettings _tableChooserPrefenceSettings = TableChooserPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private JCheckBox _jChkIncludeAllSchemas;
    private JButton _jEditSchemaListButton;
    private DataMinerTablePanel tablePanel;

    public TableChooserPane(Context context) {
        this(context, null, null);
    }

    public TableChooserPane(Context context, AbstractDataNode abstractDataNode, DataSourceWizardModel dataSourceWizardModel) {
        assert (context != null) : "Context can not be null.";
        this._context = context;
        this._node = abstractDataNode;
        this._wizModel = dataSourceWizardModel;
        try {
            String string = ConnectionFolder.getUserAccountName(this._context);
            string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
            this.tblChooserModel = new TableChooserModel(string, this._context);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Error getting user name");
        }
        this.initComponents();
        this.initRes();
    }

    public boolean isInitialized() {
        return this._isInitialized;
    }

    public void setExistingSelectedTable(TableType tableType) {
        this._existingSelectedTable = tableType;
    }

    public boolean isDirty() {
        if (this._existingSelectedTable != null) {
            if (this._existingSelectedTable.getSchema() != null && this._existingSelectedTable.getName() != null) {
                return this._selectedTable == null || !this._existingSelectedTable.getSchema().equals(this._selectedTable.getSchema()) || !this._existingSelectedTable.getName().equals(this._selectedTable.getName());
            }
            return true;
        }
        return true;
    }

    public GenericTable getTableComponent() {
        return this.tablePanel.getTable();
    }

    public TableVO getSelectedTable() {
        return this._selectedTable;
    }

    public void setSelectedTable(TableVO tableVO) {
        this._selectedTable = tableVO;
    }

    private void initComponents() {
        this._jChkIncludeAllSchemas = new JCheckBox();
        this._jEditSchemaListButton = new JButton();
        this.tablePanel = new DataMinerTablePanel();
        this._jChkIncludeAllSchemas.setText("Include Tables from Other Schemas");
        this._jChkIncludeAllSchemas.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._jChkIncludeAllSchemas.setMargin(new Insets(0, 0, 0, 0));
        this._jEditSchemaListButton.setText("Add Schemas");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._jChkIncludeAllSchemas, -2, 298, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 37, Short.MAX_VALUE).addComponent(this._jEditSchemaListButton)).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jEditSchemaListButton).addComponent(this._jChkIncludeAllSchemas, -2, 15, -2)).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this._jChkIncludeAllSchemas, (String)ControlsLrb.get("TABLE_CHOOSER_INCLUDE_ALL_SCHEMAS"));
        this._jChkIncludeAllSchemas.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("TABLE_CHOOSER_INCLUDE_ALL_SCHEMAS_ADA"));
        ResourceUtils.resButton((AbstractButton)this._jEditSchemaListButton, (String)ControlsLrb.get("TABLE_CHOOSER_ADD_SCHEMAS"));
        this._jEditSchemaListButton.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("TABLE_CHOOSER_ADD_SCHEMAS_ADA"));
        this._jEditSchemaListButton.setToolTipText(ControlsLrb.get("TABLE_CHOOSER_ADD_SCHEMAS_ADA"));
        this.tablePanel.setTitle(ControlsLrb.get("TABLE_CHOOSER_AVAILABLE_TABLES"));
    }

    @Override
    public void initUI() {
        Object object;
        try {
            DataSourceNodeType dataSourceNodeType;
            object = null;
            if (this._node instanceof DataSourceNode) {
                object = this._node;
                dataSourceNodeType = (DataSourceNodeType)((AbstractNode)object).getData();
                this._existingSelectedTable = dataSourceNodeType.getSourceTable();
            } else if (this._node instanceof UpdateTableNode) {
                object = this._node;
                dataSourceNodeType = (UpdateTableNodeType)((AbstractNode)object).getData();
                this._existingSelectedTable = dataSourceNodeType.getUpdateTargetTable();
            }
            this._connectionName = ConnectionFolder.getConnectionName(this._context);
            this._jChkIncludeAllSchemas.setSelected(this._tableChooserPrefenceSettings.getIncludeAllSchemas(this._connectionName));
            this.setSchemaButtonLabel();
            this.tblChooserModel.setOwnerOnly(!this._jChkIncludeAllSchemas.isSelected());
            this.tblChooserModel.setTablesOnly(object instanceof UpdateTableNode);
            this.setupTable(this.tblChooserModel);
            this._jEditSchemaListButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableChooserPane.this._jEditSchemaListButton_actionPerformed();
                }
            });
            dataSourceNodeType = new SearchCategory(ControlsLrb.get("TABLE_CHOOSER_TABLES_SEARCH_CAT_ALL"));
            this.tablePanel.getSearchField().addCategory((SearchCategory)dataSourceNodeType);
            this.tablePanel.getSearchField().addCategory(new SearchCategory(ControlsLrb.get("TABLE_CHOOSER_TABLES_SEARCH_CAT_TABLE")));
            this.tablePanel.getSearchField().addCategory(new SearchCategory(ControlsLrb.get("TABLE_CHOOSER_TABLES_SEARCH_CAT_SCHEMA")));
            this.tablePanel.getSearchField().setSelectedCategory((SearchCategory)dataSourceNodeType);
            RowFilter<TableChooserModel, Integer> rowFilter = new RowFilter<TableChooserModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends TableChooserModel, ? extends Integer> entry) {
                    int n = -1;
                    String string = TableChooserPane.this.tablePanel.getSearchField().getSelectedCategory().getLabel();
                    if (string.equals(ControlsLrb.get("TABLE_CHOOSER_TABLES_SEARCH_CAT_ALL"))) {
                        n = 0;
                    } else if (string.equals(ControlsLrb.get("TABLE_CHOOSER_TABLES_SEARCH_CAT_TABLE"))) {
                        n = 1;
                    } else if (string.equals(ControlsLrb.get("TABLE_CHOOSER_TABLES_SEARCH_CAT_SCHEMA"))) {
                        n = 2;
                    }
                    String string2 = TableChooserPane.this.tablePanel.getSearchField().getText();
                    SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string2, (boolean)true);
                    boolean bl = true;
                    boolean bl2 = TableChooserPane.this._jChkIncludeAllSchemas.isSelected();
                    boolean bl3 = string2.length() <= 0;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Integer n2 = entry.getIdentifier();
                    TableChooserModel tableChooserModel = entry.getModel();
                    TableVO tableVO = tableChooserModel.getRow(n2);
                    if (bl2) {
                        bl4 = true;
                    } else {
                        boolean bl6 = bl4 = tableVO.getSchema().equals(tableChooserModel.getOwnerSchema());
                    }
                    if (bl3) {
                        bl5 = true;
                    } else {
                        String string3;
                        switch (n) {
                            case 0: {
                                string3 = tableVO.getFullName();
                                break;
                            }
                            case 1: {
                                string3 = tableVO.getName();
                                break;
                            }
                            case 2: {
                                string3 = tableVO.getSchema();
                                break;
                            }
                            default: {
                                string3 = tableVO.getFullName();
                            }
                        }
                        bl5 = searchMatcher.matches((CharSequence)string3);
                    }
                    bl = bl4 && bl5;
                    return bl;
                }
            };
            this.tablePanel.getSearchField().addSearchListener((SearchListener)new SimpleSearchListener((GenericTable)this.tablePanel.getTable(), rowFilter, 0));
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_MESSAGE"), null);
        }
        this._jChkIncludeAllSchemas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TableChooserPane.this._loading) {
                    return;
                }
                ListStructure listStructure = TableChooserPane.this._tableChooserPrefenceSettings.getIncludedSchemaList(TableChooserPane.this._connectionName);
                boolean bl = TableChooserPane.this._jChkIncludeAllSchemas.isSelected();
                TableChooserPane.this._existingSelectedTable = null;
                if (bl) {
                    if (listStructure.size() == 0) {
                        if (MessageDialog.confirm((Component)TableChooserPane.this, (Object)ControlsLrb.get("TABLE_CHOOSER_PROMPT_ADD_SCHEMA"), (String)ControlsLrb.get("SCHEMA_CHOOSER_DLG_TITLE"), null)) {
                            TableChooserPane.this._jEditSchemaListButton_actionPerformed();
                            if (listStructure.size() == 0) {
                                TableChooserPane.this._jChkIncludeAllSchemas.setSelected(false);
                            }
                        } else {
                            TableChooserPane.this._jChkIncludeAllSchemas.setSelected(false);
                        }
                    } else {
                        TableChooserPane.this.reloadUI(true);
                    }
                } else {
                    TableChooserPane.this.reloadUI(false);
                }
            }
        });
        this.enableControls(false);
        this.tablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                TableChooserPane.this.updateTableSelection();
            }
        });
        this._isInitialized = true;
        object = new LoadUI();
        ((SwingWorker)object).execute();
    }

    private void reloadUI(final boolean bl) {
        this.enableControls(false);
        this._tableChooserPrefenceSettings.setIncludeAllSchemas(this._connectionName, bl);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableChooserPane.this._jChkIncludeAllSchemas.setSelected(bl);
            }
        });
        this.tblChooserModel.setOwnerOnly(!bl);
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void _jEditSchemaListButton_actionPerformed() {
        SchemaChooserPane schemaChooserPane = new SchemaChooserPane(this._context);
        ListStructure listStructure = ListStructure.newInstance();
        this._tableChooserPrefenceSettings.getIncludedSchemaList(this._connectionName).copyTo(listStructure);
        schemaChooserPane.showAsDialog(this);
        ListStructure listStructure2 = this._tableChooserPrefenceSettings.getIncludedSchemaList(this._connectionName);
        if (!listStructure.equals((Object)listStructure2)) {
            this.setSchemaButtonLabel();
            boolean bl = listStructure2.size() > 0;
            this.reloadUI(bl);
        }
    }

    private void setSchemaButtonLabel() {
        ListStructure listStructure = this._tableChooserPrefenceSettings.getIncludedSchemaList(this._connectionName);
        if (listStructure.size() > 0) {
            ResourceUtils.resButton((AbstractButton)this._jEditSchemaListButton, (String)ControlsLrb.get("TABLE_CHOOSER_EDIT_SCHEMAS"));
        } else {
            ResourceUtils.resButton((AbstractButton)this._jEditSchemaListButton, (String)ControlsLrb.get("TABLE_CHOOSER_ADD_SCHEMAS"));
        }
    }

    private void enableControls(boolean bl) {
        this.tablePanel.getSearchField().setEnabled(bl);
        this._jEditSchemaListButton.setEnabled(bl);
        this._jChkIncludeAllSchemas.setEnabled(bl);
    }

    private void setupTable(TableChooserModel tableChooserModel) {
        this.tablePanel.getTable().setModel((TableModel)((Object)tableChooserModel));
        this.tablePanel.getTable().setSorted(true);
        this.tablePanel.getTable().setSortColumn(0, true);
        this.tablePanel.getTable().setSelectionMode(0);
        TableColumnModel tableColumnModel = this.tablePanel.getTable().getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(320);
        tableColumnModel.getColumn(1).setPreferredWidth(80);
    }

    public synchronized void configureSorting(boolean bl) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        try {
            ideMainWindow.setCursor(new Cursor(3));
            if (bl) {
                this.enableControls(false);
            }
            this.selectExistingTable(this.tblChooserModel);
            if (bl) {
                this.enableControls(true);
            }
        }
        finally {
            ideMainWindow.setCursor(new Cursor(0));
        }
    }

    private void selectExistingTable(TableChooserModel tableChooserModel) {
        if (this._existingSelectedTable != null && this._existingSelectedTable.getName() != null && !this._initialTableLoadComplete && this._wizModel.isTableExists()) {
            this._initialTableLoadComplete = true;
            int n = tableChooserModel.selectRow(this._existingSelectedTable.getSchema(), this._existingSelectedTable.getName());
            if (n != -1) {
                this.setSelectedTable(tableChooserModel.getRow(n));
                int n2 = this.tablePanel.getTable().convertRowIndexToView(n);
                if (n2 != -1) {
                    this.tablePanel.getTable().setSelectedRowsInModel(new int[]{n2});
                    this.tablePanel.getTable().scrollToSelection();
                } else {
                    this._initialTableLoadComplete = false;
                }
            } else {
                Object[] objectArray = new Object[]{"\"" + this._existingSelectedTable.getSchema() + "\".\"" + this._existingSelectedTable.getName() + "\""};
                String string = MessageFormat.format(ControlsLrb.get("TABLE_CHOOSER_ERROR_MESG_MISSING_TABLE"), objectArray);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), null);
            }
        }
    }

    public void refreshSelectedTable() {
        int[] nArray = this.tablePanel.getTable().getSelectedRowsInModel();
        this._selectedTable = nArray != null && nArray.length > 0 ? this.tblChooserModel.getRow(nArray[0]) : null;
    }

    public void updateTableSelection() {
        int[] nArray = this.tablePanel.getTable().getSelectedRowsInModel();
        this._selectedTable = nArray != null && nArray.length == 1 ? this.tblChooserModel.getRow(nArray[0]) : null;
    }

    public TableChooserModel getModel() {
        return this.tblChooserModel;
    }

    public int getSelectedRow() {
        return this.tablePanel.getTable().getSelectedRowsInModel()[0];
    }

    private class LoadUI
    extends ODMrSwingWorker<List<TableVO>, Void> {
        private LoadUI() {
            super(TableChooserPane.this, TableChooserPane.this.tablePanel.getTable());
            TableChooserPane.this._loading = true;
        }

        @Override
        protected List<TableVO> doInBackground() throws Exception {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(TableChooserPane.this._context);
            return TableChooserPane.this.tblChooserModel.load(connectionFolder);
        }

        @Override
        protected void onSuccess(List<TableVO> list) throws Exception {
            TableChooserPane.this._loading = false;
            TableChooserPane.this.tblChooserModel.setSrcData(list);
            TableChooserPane.this.tablePanel.trySearch();
            TableChooserPane.this.configureSorting(true);
        }

        @Override
        protected void onFinally() {
            TableChooserPane.this.enableControls(true);
        }
    }
}

