/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.jdbc.OraclePreparedStatement;

public class SchemaChooserTableModel
extends ODMrTableModel<String> {
    public static final int SCHEMA_NAME = 0;
    private static final String[] COLUMN_NAMES = new String[]{ControlsLrb.get("SCHEMA_CHOOSER_SCHEMA_NAME")};
    private static final String SQL_QUERY = "select SCHEMA FROM (\nselect DISTINCT(OWNER) SCHEMA from all_tables\n where OWNER NOT IN (:owner_schema_param)\nUNION \nselect DISTINCT(OWNER) SCHEMA from all_views\n where OWNER NOT IN (:owner_schema_param))\n ORDER BY SCHEMA";
    private static final Logger THE_LOGGER = Logger.getLogger(SchemaChooserTableModel.class.getName());

    public SchemaChooserTableModel() {
        super(COLUMN_NAMES);
    }

    public SchemaChooserTableModel(Vector<String> vector) {
        super(COLUMN_NAMES, vector);
    }

    public void removeDuplicateRows(List<String> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : list) {
            hashMap.put(string, string);
        }
        Iterator<String> iterator = this.srcData.iterator();
        while (iterator.hasNext()) {
            String string;
            string = iterator.next();
            String string2 = (String)hashMap.get(string);
            if (string2 == null) continue;
            iterator.remove();
        }
    }

    public void setLoadingStatus() {
        String string = CommonLrb.get("COMMON_LOADING");
        this.srcData.clear();
        this.srcData.add(string);
        this.fireTableDataChanged();
    }

    public void load(Context context) throws SQLException {
        String string = ConnectionFolder.getUserAccountName(context);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context);
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(SQL_QUERY);
            sQLHelper.opstmt.setStringAtName("owner_schema_param", string);
            sQLHelper.opstmt.setFetchSize(100);
            long l = System.currentTimeMillis();
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            THE_LOGGER.log(Level.FINEST, "Time required excute query to get available schemas(milliseconds): " + (System.currentTimeMillis() - l));
            String string2 = null;
            while (sQLHelper.rs.next()) {
                string2 = sQLHelper.rs.getString("SCHEMA");
                this.srcData.add(string2);
            }
        }
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        switch (n2) {
            case 0: {
                return this.srcData.get(n);
            }
        }
        assert (false) : "Out of bounds column when accessing list of schemas";
        return null;
    }
}

