/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.utils.SimpleSearchListener;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;

public class DataMinerTablePanel
extends JPanel {
    private SearchListener listener;
    private ComponentWithTitlebar containerPanel;
    private ControlBar controlBar;
    private JSeparator jSeparator;
    private JScrollPane scrollPane;
    private SearchField searchField;
    private DataMinerTable table;
    private JLabel titleLabel;

    public DataMinerTablePanel() {
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.searchField = new SearchField();
        this.controlBar = new ControlBar();
        this.titleLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.table = new DataMinerTable();
        this.jSeparator = new JSeparator();
        this.containerPanel = new ComponentWithTitlebar();
        this.searchField.setPreferredSize(new Dimension(150, 21));
        this.controlBar.setMaximumSize(new Dimension(500, 21));
        this.titleLabel.setText("Title");
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{" "}));
        this.table.setAutoResizeMode(4);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.scrollPane.setViewportView((Component)((Object)this.table));
        this.containerPanel.setComponent((JComponent)this.scrollPane);
        this.containerPanel.setControlBar(this.controlBar);
        this.containerPanel.setLabel(this.titleLabel);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.containerPanel, GroupLayout.Alignment.TRAILING, -1, 245, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.containerPanel, -1, 235, Short.MAX_VALUE));
    }

    private void initUI() {
        this.controlBar.add((Component)this.searchField);
        this.titleLabel.setText("");
    }

    public void setup(TableModel tableModel, String string, int n) {
        this.tableSetup(tableModel, string, n);
        this.listener = new SimpleSearchListener((GenericTable)this.table, n);
        this.searchField.addSearchListener(this.listener);
    }

    public void setup(TableModel tableModel, String string, int n, boolean bl) {
        this.tableSetup(tableModel, string, n);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            String string2 = tableModel.getColumnName(i);
            SearchCategory searchCategory = new SearchCategory(string2);
            this.searchField.addCategory(searchCategory);
            if (i == n) {
                this.searchField.setSelectedCategory(searchCategory);
            }
            hashMap.put(string2, i);
        }
        this.listener = new SimpleSearchListener((GenericTable)this.table, hashMap);
        this.searchField.addSearchListener(this.listener);
    }

    public void setup(TableModel tableModel, String string, String[] stringArray, int n) {
        this.tableSetup(tableModel, string, n);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            SearchCategory searchCategory = new SearchCategory(string2);
            this.searchField.addCategory(searchCategory);
            if (i == n) {
                this.searchField.setSelectedCategory(searchCategory);
            }
            for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                if (!tableModel.getColumnName(j).equals(string2)) continue;
                hashMap.put(string2, j);
            }
        }
        this.listener = new SimpleSearchListener((GenericTable)this.table, hashMap);
        this.searchField.addSearchListener(this.listener);
    }

    private void tableSetup(TableModel tableModel, String string, int n) {
        this.table.setModel(tableModel);
        this.table.setSorted(true);
        ResourceUtils.resLabel((JLabel)this.titleLabel, (Component)((Object)this.table), (String)string);
        String string2 = tableModel.getColumnName(n);
        this.searchField.setPrompt(string2);
        this.searchField.clearCategories();
        if (this.listener != null) {
            this.searchField.removeSearchListener(this.listener);
        }
    }

    public void removeTitle() {
        this.containerPanel.setLabel(null);
    }

    public void removeSearchField() {
        this.controlBar.remove((Component)this.searchField);
        if (this.jSeparator != null) {
            this.controlBar.remove((Component)this.jSeparator);
        }
        this.searchField.setPreferredSize(new Dimension(1, 1));
    }

    public void addControlBarComponents(Component ... componentArray) {
        if (this.controlBar.getComponentIndex((Component)this.jSeparator) == -1) {
            this.controlBar.add((Component)this.jSeparator, 0);
        } else {
            this.controlBar.add((Component)new JToolBar.Separator(null), 0);
        }
        for (int i = componentArray.length - 1; i >= 0; --i) {
            this.controlBar.add(componentArray[i], 0);
        }
    }

    public void removeControlBarButtons() {
        this.controlBar = new ControlBar();
        this.controlBar.add((Component)this.searchField);
        this.containerPanel.setControlBar(this.controlBar);
    }

    public void trySearch() {
        if (this.searchField.getText().trim().length() > 0) {
            this.searchField.doSearch(this.searchField.getSelectedCategory(), this.searchField.getText(), SearchEvent.Direction.FORWARD);
        }
    }

    public DataMinerTable getTable() {
        return this.table;
    }

    public void setTable(DataMinerTable dataMinerTable) {
        this.table = dataMinerTable;
        this.scrollPane.setViewportView((Component)((Object)dataMinerTable));
    }

    public SearchField getSearchField() {
        return this.searchField;
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
    }

    public void setModelExample(TableModel tableModel) {
        this.table.setModel(tableModel);
    }
}

