/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.usage.BaseQueryTaskImpl;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.event.MethodUsageListener;
import oracle.jdevimpl.java.usage.BaseUsageQuery;

final class MethodQueryTaskImpl
extends BaseQueryTaskImpl {
    private String _fqClassName;
    private String[] _fqParameterTypes;
    private String _methodName;
    private JavaMethod _javaMethod;

    MethodQueryTaskImpl(UsageManager usageManager, String fqClassName, String methodName, String[] fqParameterTypes, MethodUsageListener listener, URL[] urlsToSearch) {
        super(usageManager, listener, urlsToSearch);
        this._fqClassName = fqClassName;
        this._methodName = methodName;
        this._fqParameterTypes = fqParameterTypes;
    }

    MethodQueryTaskImpl(UsageManager usageManager, JavaMethod javaMethod, MethodUsageListener listener, URL[] urlsToSearch) {
        super(usageManager, listener, urlsToSearch);
        this._javaMethod = javaMethod;
        this._fqClassName = javaMethod.getOwningClass().getRawName();
        this._methodName = javaMethod.getName();
        Collection parameters = javaMethod.getParameters();
        int count = parameters.size();
        this._fqParameterTypes = new String[count];
        Iterator iterator = parameters.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            JavaLocalVariable v = (JavaLocalVariable)iterator.next();
            JavaType type = v.getResolvedType();
            String typeName = "";
            if (type != null) {
                typeName = type.getRawName();
            }
            this._fqParameterTypes[i++] = typeName;
        }
    }

    @Override
    protected boolean isStartingDataValid() {
        if (this._fqClassName.length() >= 0 && this._methodName.length() >= 0 && this._fqParameterTypes != null) {
            for (String type : this._fqParameterTypes) {
                if (type != null && type.length() != 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getSearchKeyword() {
        return this._methodName;
    }

    @Override
    protected int[][] getKeywordLocations(URL url, ReadTextBuffer textBuffer) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(textBuffer);
        lexer.setRecognizeSQLJ(true);
        lexer.setSkipComments(true);
        LexerToken lexerToken = lexer.createLexerToken();
        int[] startLocations = new int[10];
        int[] endLocations = new int[10];
        int countLocations = 0;
        int[][] nameLocations = super.getKeywordLocations(url, textBuffer);
        int[] nameStartLocations = nameLocations[0];
        int[] nameEndLocations = nameLocations[1];
        int numLocations = nameStartLocations.length;
        for (int i = 0; i < numLocations; ++i) {
            int nameStart = nameStartLocations[i];
            lexer.setPosition(nameStart);
            lexer.lex(lexerToken);
            int token = lexer.lex(lexerToken);
            if (token != 55) continue;
            int nameEnd = nameEndLocations[i];
            startLocations = this.addIntToArray(startLocations, countLocations, nameStart);
            endLocations = this.addIntToArray(endLocations, countLocations, nameEnd);
            ++countLocations;
        }
        startLocations = this.trimArrayToSize(startLocations, countLocations);
        endLocations = this.trimArrayToSize(endLocations, countLocations);
        Arrays.sort(startLocations);
        Arrays.sort(endLocations);
        return new int[][]{startLocations, endLocations, nameLocations[2], nameLocations[3]};
    }

    @Override
    protected void performUsages(SourceFile file, int[] startLocations, int[] endLocations) {
        BaseUsageQuery.findMethodUsages(file, this._listener, startLocations, endLocations, this._fqClassName, this._methodName, this._fqParameterTypes);
    }
}

