/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.java.JavaManager;

public final class JavaBeansPackage {
    private static List<String> alternativeJavaBeansPackages = null;
    private static final String DEFAULT_JAVA_BEANS_PKG = "java.beans";

    public static List<String> getAlternativeJavaBeansPackages() {
        return alternativeJavaBeansPackages;
    }

    public static void addAlternativeJavaBeansPackage(String pkg) {
        if (alternativeJavaBeansPackages == null) {
            alternativeJavaBeansPackages = new ArrayList<String>();
        }
        alternativeJavaBeansPackages.add(pkg);
    }

    public static String getJavaBeansPackage(Context context) {
        List<String> alternativePackages;
        Project project = context.getProject();
        JavaManager manager = JavaManager.getAnyInstance(context.getWorkspace(), project);
        JavaClass foundClass = manager.getClass("java.beans.PropertyChangeListener");
        String alternativePkg = null;
        if (!(foundClass != null && BuildSystemConfiguration.buildAllowsClassInProfile(project, foundClass.getRawName()) || (alternativePackages = JavaBeansPackage.getAlternativeJavaBeansPackages()) == null)) {
            for (String pkg : alternativePackages) {
                foundClass = manager.getClass(pkg + ".PropertyChangeListener");
                if (foundClass == null || !BuildSystemConfiguration.buildAllowsClassInProfile(project, foundClass.getRawName())) continue;
                alternativePkg = pkg;
                break;
            }
        }
        return alternativePkg != null ? alternativePkg : DEFAULT_JAVA_BEANS_PKG;
    }
}

