/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder;

import oracle.jdeveloper.builder.resource.BuilderArb;

public final class BuilderValidationHelper {
    private static int FILENAME_DISPLAY_MAX_LENGTH = 80;

    private BuilderValidationHelper() {
    }

    public static String checkSuitableTypeName(String typeName) {
        if (typeName != null && typeName.length() > 0 && !Character.isUpperCase(typeName.charAt(0))) {
            return BuilderArb.getString(187);
        }
        return null;
    }

    public static String checkSuitablePackageName(String packageName) {
        if (packageName != null) {
            for (int i = 0; i < packageName.length(); ++i) {
                char c = packageName.charAt(i);
                if (!Character.isUpperCase(c)) continue;
                return BuilderArb.getString(188);
            }
        }
        return null;
    }

    public static String getDisplayName(String name, boolean shortenInMiddle) {
        String result = name;
        if (name.length() > FILENAME_DISPLAY_MAX_LENGTH) {
            result = shortenInMiddle ? BuilderArb.format(137, name.substring(0, FILENAME_DISPLAY_MAX_LENGTH / 2), name.substring(name.length() - FILENAME_DISPLAY_MAX_LENGTH / 2)) : BuilderArb.format(136, name.substring(0, FILENAME_DISPLAY_MAX_LENGTH));
        }
        return result;
    }
}

