/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.browse;

import java.net.URL;
import javax.swing.SwingWorker;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeNavigationPoint;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.jdeveloper.browse.JavaBrowseBundle;
import oracle.jdeveloper.browse.JavaBrowseHelper;
import oracle.jdeveloper.browse.JavaBrowseNavigationPoint;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.util.FoundSymbol;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Cancellable;

class JavaBrowseSupportWorker
extends SwingWorker {
    private JavaBrowseHelper helper;
    private CodeNavigationPoint point;
    private boolean[] cancelled = new boolean[]{false};
    private ProgressHandle handle;

    JavaBrowseSupportWorker(JavaBrowseHelper helper) {
        this.helper = helper;
        String s = JavaBrowseBundle.get("WAITING_FOR_BROWSE_SYMBOL");
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                JavaBrowseSupportWorker.this.finishHandle();
                ((JavaBrowseSupportWorker)JavaBrowseSupportWorker.this).cancelled[0] = true;
                JavaBrowseSupportWorker.this.cancel(true);
                return true;
            }
        };
        this.handle = ProgressHandle.createHandle((String)s, (Cancellable)cancellable);
        this.handle.start();
    }

    protected Object doInBackground() throws Exception {
        this.helper.acquire();
        try {
            this.performBrowseSymbolImpl();
        }
        finally {
            this.helper.release();
        }
        return null;
    }

    private synchronized void finishHandle() {
        if (this.handle != null) {
            this.handle.finish();
            this.handle = null;
        }
    }

    @Override
    protected void done() {
        this.finishHandle();
        if (this.point != null && !this.cancelled[0]) {
            NavigationManager mgr = NavigationManager.getNavigationManager();
            try {
                if (mgr != null) {
                    mgr.navigateTo((NavigationPoint)this.point);
                } else {
                    this.point.navigate();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void performBrowseSymbolImpl() {
        URL currentUrl;
        URL gotoUrl;
        JavaHasType result = this.getBrowseSymbolImpl();
        if (result != null && (gotoUrl = this.determineGotoURL(result, currentUrl = this.helper.getURL())) != null) {
            int offset = this.determineGotoOffset(result);
            if (currentUrl != null && currentUrl.equals(gotoUrl)) {
                this.browseInCurrentFile(offset);
            } else {
                this.browseInOtherFile(gotoUrl, offset, result, this.helper.getProvider());
            }
        }
    }

    protected void browseInCurrentFile(int offset) {
        Context context = this.helper.getContext();
        if (context != null) {
            this.point = new LineNavigationPoint(context, offset, false);
        }
    }

    private void browseInOtherFile(URL url, int offset, JavaHasType result, JavaManager provider) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            Context context = Context.newIdeContext((Node)node);
            Project definingProject = JavaManager.getDefiningProject(context, url);
            if (definingProject != null) {
                context.setProject(definingProject);
            }
            this.point = new JavaBrowseNavigationPoint(context, offset, result, provider);
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
    }

    private JavaHasType getBrowseSymbolImpl() {
        JavaHasType browseable;
        FoundSymbol returnSymbol = new FoundSymbol();
        JavaHasType result = this.helper.analyze(returnSymbol, false, false);
        while (result != null && (browseable = this.getBrowseableResult(result)) != result) {
            result = browseable;
        }
        return result;
    }

    private URL determineGotoURL(JavaHasType result, URL currentUrl) {
        int k = result.getElementKind();
        switch (k) {
            case 7: {
                return currentUrl;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                JavaMember member = (JavaMember)result;
                JavaClass owning = member.getOwningClass();
                if (owning != null) {
                    SourceClass owningSource = owning.getSourceElement();
                    if (owningSource != null) {
                        return owningSource.getOwningSourceFile().getURL();
                    }
                    return owning.getURL();
                }
                return null;
            }
            case 3: {
                JavaType resultType = (JavaType)result;
                SourceClass sourceClass = (SourceClass)result.getSourceElement();
                if (sourceClass != null) {
                    return sourceClass.getOwningSourceFile().getURL();
                }
                return resultType.getURL();
            }
        }
        throw new RuntimeException("determineGotoURL: " + k);
    }

    private int determineGotoOffset(JavaHasType result) {
        SourceHasName hasName;
        SourceName name;
        SourceElement sourceResult;
        JavaMethod method;
        if (result.getElementKind() == 8 && (method = (JavaMethod)result).isSynthetic() && method.isConstructor()) {
            result = method.getOwningClass();
        }
        if ((sourceResult = result.getSourceElement()) == null) {
            return -1;
        }
        if (sourceResult instanceof SourceHasName && (name = (hasName = (SourceHasName)sourceResult).getNameElement()) != null) {
            return name.getStartOffset();
        }
        return sourceResult.getStartOffset();
    }

    private JavaHasType getBrowseableResult(JavaHasType result) {
        int k = result.getElementKind();
        switch (k) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                return result;
            }
            case 15: 
            case 17: {
                return result.getResolvedType();
            }
        }
        throw new RuntimeException("getBrowseableResult: " + k);
    }
}

