/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.browse;

import java.awt.Component;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.LexerDocumentRenderer;
import oracle.javatools.editor.language.LexerOffsetsCache;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.browse.JavaBrowseBundle;
import oracle.jdeveloper.browse.JavaBrowseContext;
import oracle.jdeveloper.browse.JavaBrowseContextImpl;
import oracle.jdeveloper.browse.JavaBrowseHelper;
import oracle.jdeveloper.browse.JavaBrowseSupportWorker;
import oracle.jdevimpl.java.util.FoundSymbol;

public class JavaBrowseSupport {
    private static JavaBrowseSupport singleton = null;

    protected JavaBrowseSupport() {
    }

    public static JavaBrowseSupport getSingleton() {
        if (singleton == null) {
            singleton = new JavaBrowseSupport();
        }
        return singleton;
    }

    protected JavaBrowseContext getJavaBrowseContext(Context context, int offset) {
        return JavaBrowseContextImpl.createContext(context, offset);
    }

    protected JavaBrowseHelper getJavaBrowseHelper(Context context, int offset) {
        JavaBrowseContext browseContext = this.getJavaBrowseContext(context, offset);
        return new JavaBrowseHelper(browseContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HelpInfo getHelpInfo(Context context, int offset, boolean reportErrors) {
        JavaBrowseHelper helper = this.getJavaBrowseHelper(context, offset);
        helper.acquire();
        try {
            HelpInfo helpInfo = this.getHelpInfoImpl(helper, reportErrors);
            return helpInfo;
        }
        finally {
            helper.release();
        }
    }

    public final HelpInfo getHelpInfo(Context context, JavaElement javaElement) {
        switch (javaElement.getElementKind()) {
            case 5: {
                return this.helpInfoFor(context, (JavaField)javaElement);
            }
            case 8: {
                return this.helpInfoFor(context, (JavaMethod)javaElement);
            }
            case 3: {
                return this.helpInfoFor(context, (JavaClass)javaElement);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaHasType getSymbolAtOffset(Context context, int offset) {
        JavaBrowseHelper helper = this.getJavaBrowseHelper(context, offset);
        helper.acquire();
        try {
            FoundSymbol returnSymbol = new FoundSymbol();
            JavaHasType javaHasType = helper.analyze(returnSymbol, true, false);
            return javaHasType;
        }
        finally {
            helper.release();
        }
    }

    public void performBrowseSymbolAtOffset(Context context, int cursorOffset) {
        JavaBrowseSupportWorker worker = new JavaBrowseSupportWorker(this.getJavaBrowseHelper(context, cursorOffset));
        worker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performJavaHelpAtOffset(Context context, int offset, boolean reportErrors) {
        HelpInfo hi = null;
        JavaBrowseHelper helper = this.getJavaBrowseHelper(context, offset);
        helper.acquire();
        try {
            hi = this.getHelpInfoImpl(helper, reportErrors);
        }
        finally {
            helper.release();
        }
        if (hi != null) {
            HelpSystem.getHelpSystem().showHelp(hi);
        }
    }

    protected HelpInfo getHelpInfoImpl(JavaBrowseHelper helper, boolean reportErrors) {
        HelpInfo helpInfo = null;
        FoundSymbol returnSymbol = new FoundSymbol();
        JavaHasType result = helper.analyze(returnSymbol, true, reportErrors);
        if (result != null) {
            JavaType browseType;
            int k = result.getElementKind();
            switch (k) {
                case 5: {
                    helpInfo = this.helpInfoFor(helper.getContext(), (JavaField)result);
                    browseType = null;
                    break;
                }
                case 3: 
                case 7: 
                case 15: 
                case 17: {
                    browseType = result.getResolvedType();
                    break;
                }
                case 4: 
                case 8: {
                    JavaMethod method = (JavaMethod)result;
                    helpInfo = this.helpInfoFor(helper.getContext(), method);
                    browseType = null;
                    break;
                }
                case 10: {
                    JavaTypeVariable variable = (JavaTypeVariable)result;
                    JavaMember owner = variable.getOwningMember();
                    if (owner.getElementKind() == 3) {
                        browseType = owner.getResolvedType();
                        break;
                    }
                    browseType = owner.getOwningClass();
                    break;
                }
                default: {
                    throw new RuntimeException("performBrowseSymbolImpl: " + k);
                }
            }
            JavaClass browseClass = null;
            if (browseType != null && browseType.getElementKind() == 3) {
                browseClass = (JavaClass)browseType;
            }
            if (helpInfo == null && browseClass != null) {
                helpInfo = this.helpInfoFor(helper.getContext(), browseClass);
            } else if (helpInfo == null) {
                JavaBrowseSupport.reportError(JavaBrowseBundle.get("BROWSE_ERROR_CANNOT_BROWSE_DOC"));
            }
        }
        return helpInfo;
    }

    protected HelpInfo helpInfoFor(Context context, JavaClass browseClass) {
        try {
            String languageElement = browseClass.getQualifiedName();
            HelpInfo helpInfo = new HelpInfo(languageElement, 1);
            helpInfo.setContext(context);
            return helpInfo;
        }
        catch (Exception e) {
            JavaBrowseSupport.reportError("BROWSE_ERROR_CANNOT_BROWSE_DOC");
            return null;
        }
    }

    protected HelpInfo helpInfoFor(Context context, JavaMethod method) {
        try {
            JavaClass browseClass = method.getOwningClass();
            StringBuilder languageElement = new StringBuilder(browseClass.getQualifiedName());
            languageElement.append('#');
            languageElement.append(method.isConstructor() ? browseClass.getName() : method.getName());
            languageElement.append('(');
            String separator = "";
            for (JavaType paramType : method.getParameterTypes()) {
                languageElement.append(separator);
                languageElement.append(paramType.getQualifiedName());
                separator = ", ";
            }
            languageElement.append(')');
            HelpInfo helpInfo = new HelpInfo(languageElement.toString(), 1);
            helpInfo.setContext(context);
            return helpInfo;
        }
        catch (Exception e) {
            JavaBrowseSupport.reportError("BROWSE_ERROR_CANNOT_BROWSE_DOC");
            return null;
        }
    }

    protected HelpInfo helpInfoFor(Context context, JavaField field) {
        try {
            JavaClass browseClass = field.getOwningClass();
            StringBuilder languageElement = new StringBuilder(browseClass.getQualifiedName());
            languageElement.append("#");
            languageElement.append(field.getName());
            HelpInfo helpInfo = new HelpInfo(languageElement.toString(), 1);
            helpInfo.setContext(context);
            return helpInfo;
        }
        catch (Exception e) {
            JavaBrowseSupport.reportError("BROWSE_ERROR_CANNOT_BROWSE_DOC");
            return null;
        }
    }

    protected static void gotoOffset(Context context, int offset) {
        NavigationManager mgr = NavigationManager.getNavigationManager();
        LineNavigationPoint point = new LineNavigationPoint(context, offset, false);
        try {
            if (mgr != null) {
                mgr.navigateTo((NavigationPoint)point);
            } else {
                point.navigate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void browseInCurrentFile(JavaBrowseHelper helper, int offset) {
        Context context = helper.getContext();
        if (context != null) {
            JavaBrowseSupport.gotoOffset(context, offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NumberRange getJavaIdentifierAtOffset(JTextComponent textComponent, int offset) {
        BasicDocument document = (BasicDocument)textComponent.getDocument();
        TextBuffer textBuffer = document.getTextBuffer();
        textBuffer.readLock();
        try {
            JavaLexer lexer = new JavaLexer();
            lexer.setSkipComments(true);
            lexer.setRecognizeSQLJ(true);
            LexerToken lexerToken = lexer.createLexerToken();
            LexerDocumentRenderer renderer = (LexerDocumentRenderer)document.getDocumentRenderer();
            LexerOffsetsCache cache = renderer.getOffsetsCache();
            int searchOffset = cache.findClosestOffset((Lexer)lexer, lexerToken, offset);
            lexer.setTextBuffer((ReadTextBuffer)textBuffer);
            lexer.setPosition(searchOffset);
            int currentOffset = searchOffset;
            int bufferEnd = textBuffer.getLength();
            int token = 0;
            while (currentOffset < bufferEnd) {
                int prevToken = token;
                token = lexer.lex(lexerToken);
                if (token == 0) {
                } else {
                    int tokenStart = lexerToken.getStartOffset();
                    int tokenEnd = lexerToken.getEndOffset();
                    if (tokenStart <= offset && offset < tokenEnd) {
                        if (token == 4 || token == 136 || token == 133 || token == 124 && prevToken == 81) {
                            NumberRange numberRange = new NumberRange(tokenStart, tokenEnd);
                            return numberRange;
                        }
                    } else if (offset >= tokenStart) continue;
                }
                break;
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return null;
    }

    protected static void reportError(String errorMessage) {
        Assert.println((String)("[Browse] Error: " + errorMessage));
        String title = JavaBrowseBundle.get("BROWSE_DIALOG_ERROR_TITLE");
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)errorMessage, (String)title, null);
    }
}

