/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.browse;

import java.awt.Component;
import java.net.URL;
import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceError;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.expression.CompiledInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodReferenceExpression;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.browse.JavaBrowseBundle;
import oracle.jdeveloper.browse.JavaBrowseContext;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.Context2ParserHelper;
import oracle.jdevimpl.java.util.ExpressionFinder;
import oracle.jdevimpl.java.util.FoundSymbol;

public final class JavaBrowseHelper
extends Context2ParserHelper
implements JavaConstants {
    private final JavaBrowseContext browseContext;
    private int errorCode;
    private static final int kSearchBackwardsGuess = 500;
    private static final int ERROR_UNKNOWN = 0;
    private static final int ERROR_DECL = 1;
    private static final int ERROR_PARSE = 2;
    private static final int ERROR_RESOLVE = 3;

    public JavaBrowseHelper(JavaBrowseContext browseContext) {
        this.browseContext = browseContext;
    }

    public JavaBrowseContext getBrowseContext() {
        return this.browseContext;
    }

    @Override
    public Context getContext() {
        return this.browseContext.getContext();
    }

    @Override
    public URL getURL() {
        return this.browseContext.getURL();
    }

    public JavaManager getProvider() {
        return this.browseContext.getJavaManager();
    }

    public void acquire() {
        this.browseContext.acquire();
    }

    public void release() {
        this.browseContext.release();
    }

    private static boolean isBrowseableToken(int token) {
        return token == 4 || token == 136 || token == 133;
    }

    public boolean isBrowseable() {
        TextBuffer buffer = this.browseContext.getTextBuffer();
        if (buffer == null) {
            return false;
        }
        boolean isBrowseable = this.isJavaBrowseable(buffer);
        if (!isBrowseable) {
            isBrowseable = this.analyzeDoc() != null;
        }
        return isBrowseable;
    }

    private boolean isJavaBrowseable(TextBuffer buffer) {
        int tokenValue;
        int end;
        int start = this.browseContext.getSelectionStart();
        if (start != (end = this.browseContext.getSelectionEnd())) {
            char ch = buffer.getChar(start);
            return Character.isJavaIdentifierStart(ch) || ch == '(';
        }
        int target = start;
        int offset = start - 500;
        if (offset < 0) {
            offset = 0;
        }
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer((ReadTextBuffer)buffer);
        lexer.setPosition(offset);
        LexerToken lexerToken = lexer.createLexerToken();
        do {
            tokenValue = lexer.lex(lexerToken);
            int startOffset = lexerToken.getStartOffset();
            int endOffset = lexerToken.getEndOffset();
            if (startOffset <= target && target <= endOffset) {
                if (JavaBrowseHelper.isBrowseableToken(tokenValue)) {
                    return true;
                }
                int nextToken = lexer.lex(lexerToken);
                if (lexerToken.getStartOffset() != target) {
                    return false;
                }
                return JavaBrowseHelper.isBrowseableToken(nextToken);
            }
            if (target >= startOffset) continue;
            return false;
        } while (tokenValue != 0);
        return false;
    }

    private String analyzeTarget(FoundSymbol outSymbol) {
        int selectionEnd;
        int selectionStart;
        TextBuffer textBuffer = this.browseContext.getTextBuffer();
        if (textBuffer == null) {
            return null;
        }
        int start = this.browseContext.getSelectionStart();
        int end = this.browseContext.getSelectionEnd();
        if (start < 0 || end < 0 || end < start) {
            return null;
        }
        if (start != end) {
            selectionStart = start;
            selectionEnd = end;
        } else {
            ExpressionFinder finder = new ExpressionFinder((ReadTextBuffer)textBuffer, this.browseContext.getBraceProvider());
            FoundSymbol symbol = finder.determinePrimaryStart(end);
            if (symbol == null) {
                outSymbol.string = null;
                outSymbol.startOffset = -1;
                outSymbol.endOffset = -1;
                return null;
            }
            selectionStart = symbol.startOffset;
            selectionEnd = symbol.endOffset;
        }
        int length = selectionEnd - selectionStart;
        String target = textBuffer.getString(selectionStart, length);
        outSymbol.startOffset = selectionStart;
        outSymbol.endOffset = selectionEnd;
        outSymbol.string = target;
        return target;
    }

    private JavaHasType analyzeSearch(FoundSymbol symbol, boolean allowDecl) {
        try {
            SourceElement parent;
            CompiledInvokeExpression i;
            JavaMethod method;
            int startOffset = symbol.startOffset;
            SourceFile file = this.browseContext.getSourceFile();
            SourceElement elementAt = file.getElementAt(startOffset);
            if (elementAt == null) {
                return null;
            }
            SourceMethod declaration = JavaBrowseHelper.determineDeclaration(elementAt);
            if (declaration != null) {
                if (allowDecl) {
                    return declaration;
                }
                this.errorCode = 1;
                return null;
            }
            if (!allowDecl && elementAt.getParent() != null) {
                switch (elementAt.getParent().getSymbolKind()) {
                    case 17: {
                        if (elementAt.getSymbolKind() != 20) break;
                    }
                    case 10: {
                        if (elementAt == ((SourceVariable)elementAt.getParent()).getInitializer()) break;
                    }
                    case 3: 
                    case 13: {
                        this.errorCode = 1;
                        return null;
                    }
                }
            }
            if (elementAt.getSymbolKind() == 20) {
                int kind;
                SourceElement parent2 = elementAt.getParent();
                int n = kind = parent2 != null ? parent2.getSymbolKind() : -1;
                if (kind == 66) {
                    SourceMethodReferenceExpression methodRef = (SourceMethodReferenceExpression)parent2;
                    return methodRef.getResolvedMethod();
                }
            }
            int endOffset = symbol.endOffset;
            TextBuffer textBuffer = file.getTextBuffer();
            if (textBuffer == null) {
                return null;
            }
            String inputText = textBuffer.getString(startOffset, endOffset - startOffset);
            SourceFactory factory = file.getFactory();
            SourceExpression e = factory.createExpression(inputText);
            if (e == null) {
                this.errorCode = 2;
                return null;
            }
            if (this.selectionHasCompileErrors(file, startOffset, endOffset)) {
                this.errorCode = 3;
                return null;
            }
            SourceElement scope = elementAt;
            CallerContext context = CallerContext.createContext((SourceElement)scope, (boolean)true);
            e.setContext(context);
            JavaHasType result = e.getResolvedObject();
            if (result == null) {
                this.errorCode = 3;
                return null;
            }
            if (e instanceof CompiledInvokeExpression && (method = (i = (CompiledInvokeExpression)e).getResolvedMethod()) != null) {
                return method;
            }
            if (elementAt != null && elementAt.getSymbolKind() == 20 && (parent = elementAt.getParent()) != null && parent.getSymbolKind() == 57 && (result.getElementKind() == 5 || result.getElementKind() == 7)) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            this.errorCode = 0;
            return null;
        }
    }

    private JavaHasType analyzeDoc() {
        SourceElement elementAt;
        int endOffset;
        TextBuffer textBuffer = this.browseContext.getTextBuffer();
        if (textBuffer == null) {
            return null;
        }
        int startOffset = this.browseContext.getSelectionStart();
        if (startOffset != (endOffset = this.browseContext.getSelectionEnd())) {
            return null;
        }
        SourceFile file = this.browseContext.getSourceFile();
        if (file == null) {
            return null;
        }
        for (SourceElement sym = elementAt = file.getElementAt(startOffset); sym != null; sym = sym.getParent()) {
            switch (sym.getSymbolKind()) {
                case 74: {
                    SourceDocReference ref = (SourceDocReference)sym;
                    return ref.getResolvedObject();
                }
            }
        }
        return null;
    }

    protected JavaHasType analyze(FoundSymbol outSymbol, boolean allowDecl, boolean reportErrors) {
        int endOffset;
        long diff;
        long timeEnd;
        long timeStart;
        String target = this.analyzeTarget(outSymbol);
        if (target == null) {
            JavaHasType docResult = this.analyzeDoc();
            if (docResult != null) {
                return docResult;
            }
            if (reportErrors) {
                JavaBrowseHelper.reportError(JavaBrowseBundle.get("BROWSE_ERROR_CANNOT_FIND_TARGET"));
            }
            return null;
        }
        Assert.println((String)("[Browse] Target: " + target));
        if (target.indexOf(46) != -1 && target.indexOf(91) == -1 && target.indexOf(40) == -1 && target.indexOf(123) == -1) {
            timeStart = System.currentTimeMillis();
            JavaClass javaClass = this.browseContext.getJavaManager().getClass(target);
            timeEnd = System.currentTimeMillis();
            diff = timeEnd - timeStart;
            Assert.println((String)("[Browse] Simple resolution [ " + diff + "ms]."));
            if (javaClass != null) {
                return javaClass;
            }
        }
        timeStart = System.currentTimeMillis();
        JavaHasType item = this.analyzeSearch(outSymbol, allowDecl);
        timeEnd = System.currentTimeMillis();
        diff = timeEnd - timeStart;
        Assert.println((String)("[Browse] Full resolution [ " + diff + "ms]."));
        if (item != null) {
            return item;
        }
        int startOffset = this.browseContext.getSelectionStart();
        if (startOffset != (endOffset = this.browseContext.getSelectionEnd())) {
            this.browseContext.setSelection(endOffset, endOffset);
            return this.analyze(outSymbol, allowDecl, reportErrors);
        }
        if (reportErrors) {
            switch (this.errorCode) {
                case 1: {
                    JavaBrowseHelper.reportError(JavaBrowseBundle.get("BROWSE_ERROR_CANNOT_BROWSE_DECL"));
                    break;
                }
                case 2: {
                    JavaBrowseHelper.reportError(JavaBrowseBundle.get("BROWSE_ERROR_CANNOT_PARSE"));
                    break;
                }
                default: {
                    Object srcError = null;
                    if (srcError == null) {
                        String errorMessage = JavaBrowseBundle.format("BROWSE_ERROR_CANNOT_BROWSE_SYMBOL", target);
                        JavaBrowseHelper.reportError(errorMessage);
                        break;
                    }
                    String errorMessage = JavaBrowseBundle.format("BROWSE_ERROR_CANNOT_BROWSE_SYMBOL2", target, srcError);
                    JavaBrowseHelper.reportError(errorMessage);
                }
            }
        }
        return null;
    }

    protected static SourceMethod determineDeclaration(SourceElement elementAt) {
        block4: for (SourceElement sym = elementAt; sym != null; sym = sym.getParent()) {
            switch (sym.getSymbolKind()) {
                case 6: 
                case 19: {
                    return (SourceMethod)sym;
                }
                case 12: 
                case 20: 
                case 24: {
                    continue block4;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static void reportError(String errorMessage) {
        Assert.println((String)("[Browse] Error: " + errorMessage));
        String title = JavaBrowseBundle.get("BROWSE_DIALOG_ERROR_TITLE");
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)errorMessage, (String)title, null);
    }

    private boolean selectionHasCompileErrors(SourceFile file, int startOffset, int endOffset) {
        SourceElement thing = file.getElementContaining(startOffset, endOffset);
        if (thing == null) {
            return false;
        }
        thing.compile();
        Collection errors = file.getErrors(4, 4);
        for (SourceError error : errors) {
            if (thing.getStartOffset() != error.getStartOffset() || thing.getEndOffset() != error.getEndOffset()) continue;
            return true;
        }
        return false;
    }
}

