/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.model.Element;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ideimpl.db.explorer.model.DBObjectFolderFactory;
import oracle.ideimpl.db.explorer.model.PlSqlFragmentElement;
import oracle.javatools.db.DBLog;

class ExplorerController
implements Controller {
    ExplorerController() {
    }

    public boolean update(IdeAction action, Context context) {
        boolean retval = false;
        int cmd = action.getCommandId();
        if (cmd == ExplorerController.getAction().getCommandId() && ExplorerController.isEnabled(context)) {
            action.setEnabled(true);
            retval = true;
        }
        return retval;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        boolean retval;
        block7: {
            retval = false;
            int cmd = action.getCommandId();
            if (cmd == ExplorerController.getAction().getCommandId()) {
                PlSqlFragmentElement elem = ExplorerController.getFragElem(context);
                if (elem != null) {
                    retval = true;
                    int startOffset = elem.getStartOffset();
                    NavigationManager mgr = NavigationManager.getNavigationManager();
                    OffsetNavigationPoint point = new OffsetNavigationPoint(context, startOffset, 0);
                    point.setPreferredEditorType(null);
                    try {
                        if (mgr != null) {
                            mgr.navigateTo((NavigationPoint)point);
                            break block7;
                        }
                        point.navigate();
                    }
                    catch (Exception e) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "Error in Go to Source for pl/sql", e);
                    }
                } else if (DBObjectFolderFactory.canGoToDeclaration(context)) {
                    retval = true;
                    DBObjectFolderFactory.handleGoToDeclaration(context);
                }
            }
        }
        return retval;
    }

    static boolean isEnabled(Context context) {
        return ExplorerController.getFragElem(context) != null || DBObjectFolderFactory.canGoToDeclaration(context);
    }

    static PlSqlFragmentElement getFragElem(Context context) {
        Element elem;
        PlSqlFragmentElement retval = null;
        Element[] sel = context.getSelection();
        Element element = elem = sel != null && sel.length == 1 ? sel[0] : null;
        if (elem instanceof PlSqlFragmentElement) {
            retval = (PlSqlFragmentElement)elem;
        }
        return retval;
    }

    static IdeAction getAction() {
        return IdeActions.getGoToDeclarationAction();
    }
}

