/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.util.NoSuchElementException;
import oracle.aurora.util.Cursor;
import oracle.aurora.util.DynaHash;
import oracle.aurora.util.HashBucket;

public class DynaHashCursor
implements Cursor {
    protected DynaHash dh;
    protected HashBucket dhb;
    protected int bIdx;
    protected int idx;

    public DynaHashCursor(DynaHash dh) {
        this.reset(dh);
    }

    public void reset() {
        this.reset(this.dh);
    }

    public void reset(DynaHash dh) {
        this.dh = dh;
        this.dhb = dh.first;
        this.idx = -1;
        this.bIdx = -1;
    }

    public boolean next() {
        if (this.dhb == null) {
            return false;
        }
        ++this.idx;
        while (this.dhb != null) {
            while (++this.bIdx < this.dhb.tab.length) {
                if (this.dhb.tab[this.bIdx] == null) continue;
                if (this.dhb.tab[this.bIdx] == HashBucket.deleted) continue;
                return true;
            }
            this.dhb = this.dhb.next;
            this.bIdx = -1;
        }
        return false;
    }

    public Object get() {
        if (this.idx < 0 || this.dhb == null) {
            throw new NoSuchElementException("Cursor is not at an element");
        }
        return this.dhb.tab[this.bIdx];
    }

    public int getIndex() {
        return this.idx;
    }
}

