/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.util.Arrays;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Ide;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.file.FileSetFilter;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.HashStructure;

public final class FileSetFilters {
    private static final FileSetFilter ACCEPT_ALL_FILTER = new AcceptAllFilter();
    @GuardedBy(value="FileSetFilters.class")
    private static FileSetFilter globalFilter;

    public static FileSetFilter getAcceptAllFilter() {
        return ACCEPT_ALL_FILTER;
    }

    public static boolean isAcceptAllFilter(FileSetFilter filter) {
        return ACCEPT_ALL_FILTER.equals(filter);
    }

    public static FileSetFilter getIntersectionFilter(FileSetFilter ... filters) {
        if (filters.length == 1) {
            return filters[0];
        }
        if (filters.length == 2 && ACCEPT_ALL_FILTER == filters[0]) {
            return filters[1];
        }
        if (filters.length == 2 && ACCEPT_ALL_FILTER == filters[1]) {
            return filters[0];
        }
        boolean useIntersectedFilters = true;
        for (FileSetFilter filter : filters) {
            if (filter instanceof PatternFiltersAdapter || filter instanceof IntersectedFiltersAdapter) continue;
            useIntersectedFilters = false;
        }
        if (useIntersectedFilters) {
            IntersectedFilters intersectedFilters = null;
            for (FileSetFilter filter : filters) {
                if (filter instanceof PatternFiltersAdapter) {
                    if (intersectedFilters == null) {
                        intersectedFilters = new IntersectedFilters(((PatternFiltersAdapter)filter).getPatternFilters());
                        continue;
                    }
                    intersectedFilters = intersectedFilters.intersectWith(((PatternFiltersAdapter)filter).getPatternFilters());
                    continue;
                }
                if (!(filter instanceof IntersectedFiltersAdapter)) continue;
                intersectedFilters = intersectedFilters == null ? ((IntersectedFiltersAdapter)filter).getIntersectedFilters() : intersectedFilters.intersectWith(((IntersectedFiltersAdapter)filter).getIntersectedFilters());
            }
            return FileSetFilters.getFileSetFilter(intersectedFilters);
        }
        return new IntersectionFilter(filters);
    }

    public static FileSetFilter getUnionFilter(FileSetFilter ... filters) {
        for (FileSetFilter filter : filters) {
            if (filter != ACCEPT_ALL_FILTER) continue;
            return ACCEPT_ALL_FILTER;
        }
        return new UnionFilter(filters);
    }

    public static synchronized FileSetFilter getGlobalFilter() {
        if (globalFilter == null) {
            PatternFilters projectWorkspaceFilter = PatternFilters.getInstance((HashStructure)HashStructure.newInstance());
            projectWorkspaceFilter.addInclude("**");
            projectWorkspaceFilter.addExclude("**/*.jpr");
            projectWorkspaceFilter.addExclude("**/*.jws");
            globalFilter = FileSetFilters.getFileSetFilter(new IntersectedFilters(projectWorkspaceFilter, GlobalIgnoreList.getPatternFilters()));
        }
        return globalFilter;
    }

    public static FileSetFilter getFileSetFilter(PatternFilters filters) {
        if (filters == null || !filters.containsFilters()) {
            return ACCEPT_ALL_FILTER;
        }
        PatternFilter[] filterArray = filters.getFilters();
        if (filterArray == null || filterArray.length == 0 || filterArray.length == 1 && filterArray[0].isInclude() && "**".equals(filterArray[0].getPattern())) {
            return ACCEPT_ALL_FILTER;
        }
        return new PatternFiltersAdapter(filters);
    }

    public static FileSetFilter getFileSetFilter(IntersectedFilters filter) {
        if (filter == null) {
            return ACCEPT_ALL_FILTER;
        }
        return new IntersectedFiltersAdapter(filter);
    }

    private FileSetFilters() {
    }

    static {
        if (Ide.isRunning()) {
            GlobalIgnoreList ignore = (GlobalIgnoreList)Ide.getSettings().getData("global-ignore-list");
            ignore.addChangeListener(new ChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void stateChanged(ChangeEvent e) {
                    Class<FileSetFilters> clazz = FileSetFilters.class;
                    synchronized (FileSetFilters.class) {
                        globalFilter = null;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
    }

    private static final class IntersectedFiltersAdapter
    implements FileSetFilter {
        private final IntersectedFilters filters;

        private IntersectedFiltersAdapter(IntersectedFilters filters) {
            this.filters = filters;
        }

        private IntersectedFilters getIntersectedFilters() {
            return this.filters;
        }

        @Override
        public boolean acceptFile(String path) {
            return this.filters.isIncluded(path);
        }

        @Override
        public boolean acceptDirectory(String path) {
            TriStateBoolean tsb = this.filters.inferFromFilters(path);
            return tsb.isTrue() || tsb.isTriState();
        }

        @Override
        public String getUniqueIdentifier() {
            return this.filters.toString();
        }

        public int hashCode() {
            return this.filters.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IntersectedFiltersAdapter)) {
                return false;
            }
            IntersectedFiltersAdapter other = (IntersectedFiltersAdapter)o;
            return this.filters.equals((Object)other.filters);
        }

        public String toString() {
            return this.getUniqueIdentifier();
        }
    }

    private static final class PatternFiltersAdapter
    implements FileSetFilter {
        private final PatternFilters filters;

        private PatternFiltersAdapter(PatternFilters filters) {
            this.filters = filters;
        }

        private PatternFilters getPatternFilters() {
            return this.filters;
        }

        @Override
        public boolean acceptFile(String path) {
            return this.filters.isIncluded(path);
        }

        @Override
        public boolean acceptDirectory(String path) {
            TriStateBoolean tsb = this.filters.inferFromFilters(path);
            return tsb.isTrue() || tsb.isTriState();
        }

        @Override
        public String getUniqueIdentifier() {
            PatternFilter[] filterArray = this.filters.getFilters();
            if (filterArray != null) {
                StringBuilder buffer = new StringBuilder();
                for (PatternFilter filter : filterArray) {
                    buffer.append(filter.toStr());
                }
                return buffer.toString();
            }
            return "";
        }

        public int hashCode() {
            return this.filters.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PatternFiltersAdapter)) {
                return false;
            }
            PatternFiltersAdapter other = (PatternFiltersAdapter)o;
            return this.filters.equals((Object)other.filters);
        }

        public String toString() {
            return this.getUniqueIdentifier();
        }
    }

    private static final class UnionFilter
    implements FileSetFilter {
        private final FileSetFilter[] filters;

        private UnionFilter(FileSetFilter ... filters) {
            this.filters = filters;
        }

        @Override
        public boolean acceptFile(String path) {
            for (FileSetFilter filter : this.filters) {
                if (!filter.acceptFile(path)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean acceptDirectory(String path) {
            for (FileSetFilter filter : this.filters) {
                if (filter.acceptDirectory(path)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getUniqueIdentifier() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.filters.length; ++i) {
                builder.append(this.filters[i].getUniqueIdentifier());
                if (i >= this.filters.length - 1) continue;
                builder.append("||");
            }
            return builder.toString();
        }

        public int hashCode() {
            int hashCode = 17;
            for (FileSetFilter filter : this.filters) {
                hashCode = 31 * hashCode + filter.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnionFilter)) {
                return false;
            }
            UnionFilter other = (UnionFilter)o;
            return Arrays.equals(this.filters, other.filters);
        }

        public String toString() {
            return this.getUniqueIdentifier();
        }
    }

    private static final class IntersectionFilter
    implements FileSetFilter {
        private final FileSetFilter[] filters;

        private IntersectionFilter(FileSetFilter ... filters) {
            this.filters = filters;
        }

        @Override
        public boolean acceptFile(String path) {
            for (FileSetFilter filter : this.filters) {
                if (filter.acceptFile(path)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean acceptDirectory(String path) {
            for (FileSetFilter filter : this.filters) {
                if (filter.acceptDirectory(path)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getUniqueIdentifier() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.filters.length; ++i) {
                builder.append(this.filters[i].getUniqueIdentifier());
                if (i >= this.filters.length - 1) continue;
                builder.append("&&");
            }
            return builder.toString();
        }

        public int hashCode() {
            int hashCode = 17;
            for (FileSetFilter filter : this.filters) {
                hashCode = 31 * hashCode + filter.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IntersectionFilter)) {
                return false;
            }
            IntersectionFilter other = (IntersectionFilter)o;
            return Arrays.equals(this.filters, other.filters);
        }

        public String toString() {
            return this.getUniqueIdentifier();
        }
    }

    private static final class AcceptAllFilter
    implements FileSetFilter {
        private AcceptAllFilter() {
        }

        @Override
        public boolean acceptFile(String path) {
            return true;
        }

        @Override
        public boolean acceptDirectory(String path) {
            return true;
        }

        @Override
        public String getUniqueIdentifier() {
            return "**";
        }

        public String toString() {
            return this.getUniqueIdentifier();
        }
    }
}

