/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.wizard.UpdatePageConditions;

public final class UpdateWizardModel {
    private final UpdateManager _manager;
    private LocalUpdateBundle _localBundle;
    private List _allCenters;
    private Collection<UpdateInfo> _selectedUpdates;
    private Map _agreedLicenses = new HashMap();
    private boolean _installForEveryone = true;
    private Map _downloadedUpdates;
    private boolean _skipSource = false;
    private String _extensionID = null;
    private Collection<String> _extensionIDs = null;
    private volatile boolean _wizardIsCancelled;
    public static final String PROP_WIZARD_CANCELLED = "wizardCancelled";
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    public UpdateWizardModel(UpdateManager mgr) {
        this._manager = mgr;
    }

    UpdatePageConditions getConditions() {
        return new UpdatePageConditions(this.isLocal(), this.isLicense(), this.getSelectedUpdates());
    }

    public synchronized void setForcedCenters(List centers) {
        this._skipSource = true;
        this._allCenters = centers;
    }

    public void setRequestedExtensionID(String extensionID) {
        this._extensionID = extensionID;
    }

    public String getRequestedExtensionID() {
        return this._extensionID;
    }

    public void setRequestedExtensionIDs(Collection<String> _extensionIDs) {
        this._extensionIDs = _extensionIDs;
    }

    public Collection<String> getRequestedExtensionIDs() {
        return this._extensionIDs;
    }

    public boolean isSourceSkipped() {
        return this._skipSource;
    }

    private boolean isLocal() {
        return this._localBundle != null;
    }

    private boolean isLicense() {
        return !this.getUpdatesRequiringAgreement().isEmpty();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener pcl) {
        this._changeSupport.addPropertyChangeListener(propertyName, pcl);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener pcl) {
        this._changeSupport.removePropertyChangeListener(propertyName, pcl);
    }

    public synchronized void setDownloadedUpdates(Map downloadedUpdates) {
        this._downloadedUpdates = downloadedUpdates;
    }

    public synchronized Map getDownloadedUpdates() {
        return this._downloadedUpdates;
    }

    public synchronized UpdateManager getUpdateManager() {
        return this._manager;
    }

    public synchronized List getAllUpdateCenters() {
        if (this._allCenters == null) {
            this._allCenters = new ArrayList();
            for (UpdateCenter center : this.getUpdateManager().getUpdateCenters()) {
                UpdateCenter clone = center.createClone();
                if (this._extensionID != null || this._extensionIDs != null) {
                    clone.setEnabledChangedByJDev(clone.getMasterId().startsWith("oracle.ide.webupdate"));
                }
                this._allCenters.add(clone);
            }
        }
        return this._allCenters;
    }

    public synchronized void setLocalBundle(LocalUpdateBundle localBundle) {
        this._localBundle = localBundle;
    }

    public synchronized LocalUpdateBundle getLocalBundle() {
        return this._localBundle;
    }

    public synchronized List getSelectedCenters() {
        ArrayList<UpdateCenter> l = new ArrayList<UpdateCenter>(this._allCenters.size());
        for (UpdateCenter c : this._allCenters) {
            if (!c.isEnabled()) continue;
            l.add(c);
        }
        return Collections.unmodifiableList(l);
    }

    public synchronized void setSelectedUpdates(Collection<UpdateInfo> selectedUpdates) {
        this._selectedUpdates = selectedUpdates;
    }

    public synchronized Collection getSelectedUpdates() {
        if (this._localBundle != null) {
            return Collections.unmodifiableCollection(this._localBundle.getBundle().getUpdates());
        }
        return this._selectedUpdates;
    }

    public synchronized boolean isLicenseAgreed(UpdateInfo update) {
        if (update.getClickThroughURL() == null) {
            return true;
        }
        Boolean bAgreed = (Boolean)this._agreedLicenses.get(update.getID());
        return bAgreed == null ? false : bAgreed;
    }

    public synchronized void setLicenseAgreed(UpdateInfo update, boolean agreed) {
        this._agreedLicenses.put(update.getID(), agreed);
    }

    public synchronized List getUpdatesRequiringAgreement() {
        ArrayList<UpdateInfo> updates = new ArrayList<UpdateInfo>();
        for (UpdateInfo thisUpdate : this.getSelectedUpdates()) {
            if (this.isLicenseAgreed(thisUpdate)) continue;
            updates.add(thisUpdate);
        }
        return updates;
    }

    public synchronized void setInstallForEveryone(boolean installForEveryone) {
        this._installForEveryone = installForEveryone;
    }

    public synchronized boolean isInstallForEveryone() {
        return this._installForEveryone;
    }

    public boolean isWizardCancelled() {
        return this._wizardIsCancelled;
    }

    public void setWizardCancelled(boolean cancelled) {
        boolean oldValue = this._wizardIsCancelled;
        this._wizardIsCancelled = cancelled;
        this._changeSupport.firePropertyChange(PROP_WIZARD_CANCELLED, oldValue, cancelled);
    }

    boolean hasRequestedExtensions() {
        return this._extensionID != null || this._extensionIDs != null && !this._extensionIDs.isEmpty();
    }
}

