/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.webupdate.InstallProgressMonitor;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateInstaller;
import oracle.javatools.ui.table.GenericTable;

public class InstallProgressPanel
extends JPanel {
    private JEWTDialog parent;
    private JPanel buttonPanel;
    private InstallProgressMonitor ipm;
    private DefaultListModel listModel;

    public InstallProgressPanel(JEWTDialog parent, Map<UpdateInstaller, List<UpdateInfo>> noRestartUninstalls, Map<UpdateInstaller, List<AbstractMap.SimpleImmutableEntry<UpdateInfo, File>>> noRestartInstalls) {
        this.parent = parent;
        this.setLayout(new GridBagLayout());
        this.initListModel(noRestartUninstalls, noRestartInstalls);
        JList updatesList = new JList(this.listModel);
        updatesList.setCellRenderer(new InstallListCellRenderer());
        JScrollPane jsp = new JScrollPane(updatesList);
        final JButton jbCancel = new JButton();
        ResourceUtils.resButton((AbstractButton)jbCancel, (String)UpdateArb.getString(223));
        jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (InstallProgressPanel.this.ipm != null) {
                    InstallProgressPanel.this.ipm.setCancelled(true);
                    jbCancel.setEnabled(false);
                }
            }
        });
        JButton jbClose = new JButton();
        ResourceUtils.resButton((AbstractButton)jbClose, (String)UpdateArb.getString(224));
        jbClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                InstallProgressPanel.this.parent.closeDialog(true);
            }
        });
        JPanel jpCancel = new JPanel();
        jpCancel.add(jbCancel);
        jpCancel.setLayout(new GridBagLayout());
        jpCancel.add((Component)jbCancel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jpClose = new JPanel();
        jpClose.setLayout(new GridBagLayout());
        jpClose.add((Component)jbClose, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jpClose.add(jbClose);
        this.buttonPanel = new JPanel(new CardLayout());
        this.buttonPanel.add((Component)jpCancel, UpdateArb.getString(223));
        this.buttonPanel.add((Component)jpClose, UpdateArb.getString(224));
        this.add((Component)jsp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public JPanel getButtonCards() {
        return this.buttonPanel;
    }

    private void initListModel(Map<UpdateInstaller, List<UpdateInfo>> noRestartUninstalls, Map<UpdateInstaller, List<AbstractMap.SimpleImmutableEntry<UpdateInfo, File>>> noRestartInstalls) {
        Object item;
        Vector<Object> rowData;
        List<Object> uis;
        InstallStatusTableModel tableModel;
        this.listModel = new DefaultListModel();
        if (noRestartUninstalls != null) {
            for (UpdateInstaller installer : noRestartUninstalls.keySet()) {
                tableModel = new InstallStatusTableModel();
                uis = noRestartUninstalls.get(installer);
                for (Object ui : uis) {
                    rowData = new Vector<Object>();
                    rowData.add(((UpdateInfo)ui).getID());
                    rowData.add((Object)InstallProgressMonitor.InstallStatus.WAITING_TO_UNINSTALL);
                    rowData.add("");
                    tableModel.addRow(rowData);
                }
                item = new InstallItem(installer.getInstallerName(), tableModel);
                this.listModel.addElement(item);
            }
        }
        if (noRestartInstalls != null) {
            for (UpdateInstaller installer : noRestartInstalls.keySet()) {
                tableModel = new InstallStatusTableModel();
                uis = noRestartInstalls.get(installer);
                for (Object ui : uis) {
                    rowData = new Vector();
                    rowData.add(((UpdateInfo)((AbstractMap.SimpleImmutableEntry)ui).getKey()).getID());
                    rowData.add((Object)InstallProgressMonitor.InstallStatus.WAITING_TO_INSTALL);
                    rowData.add("");
                    tableModel.addRow(rowData);
                }
                item = new InstallItem(installer.getInstallerName(), tableModel);
                this.listModel.addElement(item);
            }
        }
    }

    public void setStatus(String id, InstallProgressMonitor.InstallStatus status, String message) {
        boolean valueSet = false;
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            Object item = this.listModel.getElementAt(i);
            if (!(item instanceof InstallItem)) continue;
            InstallItem ii = (InstallItem)item;
            InstallStatusTableModel istm = ii.getInstallStatusTableModel();
            for (int j = 0; j < istm.getRowCount(); ++j) {
                InstallProgressMonitor.InstallStatus currStatus = (InstallProgressMonitor.InstallStatus)((Object)istm.getValueAt(j, 2));
                if (!istm.getValueAt(j, 1).equals(id) || currStatus != InstallProgressMonitor.InstallStatus.WAITING_TO_INSTALL && currStatus != InstallProgressMonitor.InstallStatus.INSTALLING && currStatus != InstallProgressMonitor.InstallStatus.WAITING_TO_UNINSTALL && currStatus != InstallProgressMonitor.InstallStatus.UNINSTALLING) continue;
                istm.setValueAt((Object)status, j, 0);
                istm.setValueAt((Object)status, j, 2);
                istm.setValueAt(message, j, 3);
                valueSet = true;
                break;
            }
            if (!valueSet) continue;
            this.listModel.setElementAt(ii, i);
            break;
        }
    }

    public void setProgressMonitor(InstallProgressMonitor ipm) {
        this.ipm = ipm;
    }

    private static class InstallItem {
        private String installerName;
        private InstallStatusTableModel tableModel;

        public InstallItem(String installerName, InstallStatusTableModel tableModel) {
            this.installerName = installerName;
            this.tableModel = tableModel;
        }

        public String getInstallerName() {
            return this.installerName;
        }

        public InstallStatusTableModel getInstallStatusTableModel() {
            return this.tableModel;
        }
    }

    private static class InstallListCellRenderer
    implements ListCellRenderer {
        private InstallListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel jpInstallList = new JPanel(new GridBagLayout());
            if (value instanceof InstallItem) {
                InstallItem installItem = (InstallItem)value;
                JLabel jlInstallerName = new JLabel(installItem.getInstallerName());
                GenericTable jtInstallStatus = new GenericTable((TableModel)installItem.getInstallStatusTableModel());
                jtInstallStatus.setDefaultRenderer(Object.class, new InstallStatusTableCellRenderer());
                jtInstallStatus.getColumnModel().getColumn(0).setPreferredWidth(50);
                jtInstallStatus.getColumnModel().getColumn(1).setPreferredWidth(200);
                jtInstallStatus.getColumnModel().getColumn(2).setPreferredWidth(150);
                jtInstallStatus.getColumnModel().getColumn(3).setPreferredWidth(300);
                jpInstallList.add((Component)jlInstallerName, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                jpInstallList.add((Component)jtInstallStatus, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                ResourceUtils.setComponentName((Object)this, (Component)jtInstallStatus, (String)("jtInstallStatus_" + index));
            }
            return jpInstallList;
        }

        private static class InstallStatusTableCellRenderer
        implements TableCellRenderer {
            private InstallStatusTableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                switch (column) {
                    case 0: {
                        if (!(value instanceof InstallProgressMonitor.InstallStatus)) break;
                        InstallProgressMonitor.InstallStatus is = (InstallProgressMonitor.InstallStatus)((Object)value);
                        return new JLabel(is.getIcon());
                    }
                    case 1: {
                        return new JLabel(value.toString());
                    }
                    case 2: {
                        if (!(value instanceof InstallProgressMonitor.InstallStatus)) break;
                        InstallProgressMonitor.InstallStatus is = (InstallProgressMonitor.InstallStatus)((Object)value);
                        return new JLabel(is.toString());
                    }
                    case 3: {
                        return new JLabel(value.toString());
                    }
                }
                return new JLabel();
            }
        }
    }

    private static class InstallStatusTableModel
    extends DefaultTableModel {
        private InstallStatusTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return ((Vector)this.dataVector.get(row)).get(1);
            }
            return ((Vector)this.dataVector.get(row)).get(column - 1);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Vector rowVector = (Vector)this.dataVector.elementAt(row);
            if (column == 0) {
                rowVector.setElementAt(value, 1);
            } else {
                rowVector.setElementAt(value, column - 1);
            }
            this.fireTableCellUpdated(row, column);
        }
    }
}

