/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.time;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class IlvCalendarUtil {
    private static final int a = 588829;

    private IlvCalendarUtil() {
    }

    public static Date min(Date date, Date date2) {
        return date.before(date2) ? date : date2;
    }

    public static Date max(Date date, Date date2) {
        return date.after(date2) ? date : date2;
    }

    public static int compareEra(Calendar calendar, Calendar calendar2) {
        if (calendar.getClass() != calendar2.getClass()) {
            throw new IllegalArgumentException("Cannot compare calendars of dissimilar classes: " + calendar + ", " + calendar2);
        }
        return calendar.get(0) - calendar2.get(0);
    }

    public static int compareYear(Calendar calendar, Calendar calendar2) {
        int n2 = IlvCalendarUtil.compareEra(calendar, calendar2);
        if (n2 != 0) {
            return n2;
        }
        return calendar.get(1) - calendar2.get(1);
    }

    public static int compareMonth(Calendar calendar, Calendar calendar2) {
        int n2 = IlvCalendarUtil.compareYear(calendar, calendar2);
        if (n2 != 0) {
            return n2;
        }
        return calendar.get(2) - calendar2.get(2);
    }

    public static int compareDay(Calendar calendar, Calendar calendar2) {
        int n2 = IlvCalendarUtil.compareYear(calendar, calendar2);
        if (n2 != 0) {
            return n2;
        }
        return calendar.get(6) - calendar2.get(6);
    }

    public static int julianDay(GregorianCalendar gregorianCalendar) {
        int n2 = gregorianCalendar.get(0);
        int n3 = gregorianCalendar.get(1);
        assert (n2 == 1 || n2 == 0);
        if (n2 == 0) {
            n3 = -n3;
        }
        int n4 = gregorianCalendar.get(2) + 1;
        int n5 = gregorianCalendar.get(5);
        int n6 = n3;
        if (n3 < 0) {
            ++n6;
        }
        int n7 = n4;
        if (n4 > 2) {
            ++n7;
        } else {
            --n6;
            n7 += 13;
        }
        double d2 = Math.floor(365.25 * (double)n6) + Math.floor(30.6001 * (double)n7) + (double)n5 + 1720995.0;
        if (n5 + 31 * (n4 + 12 * n3) >= 588829) {
            int n8 = (int)(0.01 * (double)n6);
            d2 += (double)(2 - n8) + 0.25 * (double)n8;
        }
        return (int)Math.floor(d2);
    }

    public static int julianDay(Calendar calendar) {
        GregorianCalendar gregorianCalendar;
        if (calendar instanceof GregorianCalendar) {
            gregorianCalendar = (GregorianCalendar)calendar;
        } else {
            gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(calendar.getTime());
        }
        return IlvCalendarUtil.julianDay(gregorianCalendar);
    }

    public static int elapsedDays(Calendar calendar, Calendar calendar2) {
        if (IlvCalendarUtil.compareYear(calendar, calendar2) == 0) {
            return calendar2.get(6) - calendar.get(6);
        }
        return IlvCalendarUtil.julianDay(calendar2) - IlvCalendarUtil.julianDay(calendar);
    }

    public static void secondFloor(Calendar calendar) {
        calendar.set(14, 0);
    }

    public static void minuteFloor(Calendar calendar) {
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void hourFloor(Calendar calendar) {
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void halfDayFloor(Calendar calendar) {
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void dayFloor(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void weekFloor(Calendar calendar) {
        int n2;
        int n3 = calendar.get(1);
        int n4 = calendar.get(6);
        int n5 = calendar.get(7);
        int n6 = n5 - (n2 = calendar.getFirstDayOfWeek());
        if (n6 > 0) {
            n4 -= n6;
        } else if (n6 < 0) {
            n4 -= 7 + n6;
        }
        calendar.clear();
        boolean bl = calendar.isLenient();
        if (!bl) {
            calendar.setLenient(true);
        }
        calendar.set(1, n3);
        calendar.set(6, n4);
        if (!bl) {
            n3 = calendar.get(1);
            calendar.setLenient(false);
        }
    }

    public static void monthFloor(Calendar calendar) {
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void yearFloor(Calendar calendar) {
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }
}

