/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.java2d.internal;

public class IlvMath {
    private IlvMath() {
    }

    public static int calcLinearSolution(double d2, double d3, double[] dArray) {
        if (d2 == 0.0) {
            if (d3 == 0.0) {
                return -1;
            }
            return 0;
        }
        dArray[0] = -d3 / d2;
        return 1;
    }

    public static int calcQuadSolution(double d2, double d3, double d4, double[] dArray) {
        if (d2 == 0.0) {
            return IlvMath.calcLinearSolution(d3, d4, dArray);
        }
        double d5 = d3 * d3 - 4.0 * d2 * d4;
        if (d5 < 0.0) {
            return 0;
        }
        if (d5 == 0.0) {
            dArray[0] = -d3 / (2.0 * d2);
            return 1;
        }
        double d6 = Math.sqrt(d5);
        dArray[0] = (d6 - d3) / (2.0 * d2);
        dArray[1] = (-d6 - d3) / (2.0 * d2);
        return 2;
    }

    public static int calcCubicSolution(double d2, double d3, double d4, double d5, double[] dArray) {
        if (d2 == 0.0) {
            return IlvMath.calcQuadSolution(d3, d4, d5, dArray);
        }
        double d6 = 0.3333333333333333;
        double d7 = d3 / (3.0 * d2);
        double d8 = 3.0 * d2 * d2;
        double d9 = (3.0 * d2 * d4 - d3 * d3) / d8;
        double d10 = (2.0 * d3 * d3 * d3 - 9.0 * d2 * d3 * d4 + 9.0 * d8 * d5) / (9.0 * d8 * d2);
        if (d9 == 0.0) {
            double d11 = d10 >= 0.0 ? 1.0 : -1.0;
            dArray[0] = -d11 * Math.pow(d11 * d10, d6) - d7;
            return 1;
        }
        double d12 = d9 * d9 * d9 / 27.0;
        double d13 = d10 * d10 / 4.0;
        double d14 = d12 + d13;
        if (d14 < 0.0) {
            double d15 = Math.sqrt(-d12);
            double d16 = Math.acos(-d10 / (2.0 * d15));
            double d17 = d15 >= 0.0 ? 1.0 : -1.0;
            double d18 = 2.0 * d17 * Math.pow(d17 * d15, d6);
            dArray[0] = d18 * Math.cos(d16 / 3.0) - d7;
            dArray[1] = d18 * Math.cos((d16 + Math.PI * 2) / 3.0) - d7;
            dArray[2] = d18 * Math.cos((d16 + Math.PI * 4) / 3.0) - d7;
            return 3;
        }
        double d19 = d10 > 0.0 ? d12 / (Math.sqrt(d14) + d10 / 2.0) : Math.sqrt(d14) - d10 / 2.0;
        double d20 = d19 >= 0.0 ? 1.0 : -1.0;
        double d21 = d20 * Math.pow(d20 * d19, d6);
        if (d21 == 0.0) {
            d20 = d10 >= 0.0 ? 1.0 : -1.0;
            dArray[0] = -d20 * Math.pow(d20 * d10, d6) - d7;
            return 1;
        }
        double d22 = -d9 / (3.0 * d21);
        if (d21 == d22) {
            dArray[0] = d21 + d22 - d7;
            dArray[1] = -0.5 * (d21 + d22) - d7;
            return 2;
        }
        dArray[0] = d21 + d22 - d7;
        return 1;
    }

    public static int calcPolynomialSolution(int n2, double[] dArray, double[] dArray2) {
        while (n2 > 0 && dArray[n2] == 0.0) {
            --n2;
        }
        switch (n2) {
            case 0: {
                return dArray[0] == 0.0 ? -1 : 0;
            }
            case 1: {
                return IlvMath.calcLinearSolution(dArray[1], dArray[0], dArray2);
            }
            case 2: {
                return IlvMath.calcQuadSolution(dArray[2], dArray[1], dArray[0], dArray2);
            }
            case 3: {
                return IlvMath.calcCubicSolution(dArray[3], dArray[2], dArray[1], dArray[0], dArray2);
            }
        }
        return IlvMath.a(n2, dArray, -1.7976931348623157E308, Double.MAX_VALUE, dArray2);
    }

    public static int calcPolynomialSolution(int n2, double[] dArray, double d2, double d3, double[] dArray2) {
        while (n2 > 0 && dArray[n2] == 0.0) {
            --n2;
        }
        switch (n2) {
            case 0: {
                return dArray[0] == 0.0 ? -1 : 0;
            }
            case 1: {
                return IlvMath.a(IlvMath.calcLinearSolution(dArray[1], dArray[0], dArray2), dArray2, d2, d3);
            }
            case 2: {
                return IlvMath.a(IlvMath.calcQuadSolution(dArray[2], dArray[1], dArray[0], dArray2), dArray2, d2, d3);
            }
            case 3: {
                return IlvMath.a(IlvMath.calcCubicSolution(dArray[3], dArray[2], dArray[1], dArray[0], dArray2), dArray2, d2, d3);
            }
        }
        return IlvMath.a(n2, dArray, d2, d3, dArray2);
    }

    private static int a(int n2, double[] dArray, double d2, double d3) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!(dArray[i2] >= d2) || !(dArray[i2] <= d3)) continue;
            dArray[n3++] = dArray[i2];
        }
        return n3;
    }

    private static int a(int n2, double[] dArray, double d2, double d3, double[] dArray2) {
        assert (n2 > 0);
        assert (dArray[n2] != 0.0);
        double d4 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d4 = Math.max(d4, Math.abs(dArray[i2]));
        }
        double d5 = d4 / Math.abs(dArray[n2]) + 1.0;
        if (d2 < -d5) {
            d2 = -d5;
        }
        if (d3 > d5) {
            d3 = d5;
        }
        if (d2 < d3) {
            int n3;
            int n4;
            int n5;
            double[][] dArrayArray;
            if (dArray.length > n2 + 1) {
                double[] dArray3 = new double[n2 + 1];
                System.arraycopy(dArray, 0, dArray3, 0, n2 + 1);
                dArray = dArray3;
            }
            while (true) {
                dArrayArray = new double[n2 + 1][];
                n5 = 0;
                dArrayArray[n5++] = dArray;
                double[] dArray4 = new double[n2];
                for (n4 = 0; n4 < n2; ++n4) {
                    dArray4[n4] = dArray[n4 + 1] * (double)(n4 + 1);
                }
                dArrayArray[n5++] = dArray4;
                while ((dArray4 = IlvMath.b(dArrayArray[n5 - 2], dArrayArray[n5 - 1])).length != 0) {
                    dArrayArray[n5++] = dArray4;
                }
                if (dArrayArray[n5 - 1].length <= 1) break;
                dArray = IlvMath.a(dArray, dArrayArray[n5 - 1]);
                n2 = dArray.length - 1;
                switch (n2) {
                    case 1: {
                        return IlvMath.a(IlvMath.calcLinearSolution(dArray[1], dArray[0], dArray2), dArray2, d2, d3);
                    }
                    case 2: {
                        return IlvMath.a(IlvMath.calcQuadSolution(dArray[2], dArray[1], dArray[0], dArray2), dArray2, d2, d3);
                    }
                    case 3: {
                        return IlvMath.a(IlvMath.calcCubicSolution(dArray[3], dArray[2], dArray[1], dArray[0], dArray2), dArray2, d2, d3);
                    }
                }
            }
            int n6 = 0;
            n4 = IlvMath.a(dArrayArray, n5, d2);
            if (n4 < 0) {
                n4 = -1 - n4;
                dArray2[n6++] = d2;
            }
            if ((n3 = IlvMath.a(dArrayArray, n5, d3)) < 0 && (n3 = -1 - n3) < n4) {
                dArray2[n6++] = d3;
                ++n3;
            }
            return IlvMath.a(dArrayArray, n5, d2, n4, d3, n3, n6, dArray2);
        }
        if (d2 == d3) {
            if (IlvMath.a(dArray, d2) == 0.0) {
                dArray2[0] = d2;
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private static int a(double[][] dArray, int n2, double d2, int n3, double d3, int n4, int n5, double[] dArray2) {
        if (n3 > n4) {
            double d4 = (d2 + d3) * 0.5;
            if (d2 < d4 && d4 < d3) {
                int n6;
                int n7;
                int n8 = n7 = IlvMath.a(dArray, n2, d4);
                if (n7 < 0) {
                    n8 = n7 = -1 - n7;
                    if (n7 >= n4 && n7 < n3) {
                        dArray2[n5++] = d4;
                        n8 = n7 + 1;
                    }
                }
                if (n8 > n3) {
                    n6 = n8 - n3;
                    n7 -= n6;
                    n8 -= n6;
                }
                if (n7 < n4) {
                    n6 = n4 - n7;
                    n7 += n6;
                    n8 += n6;
                }
                n5 = IlvMath.a(dArray, n2, d2, n3, d4, n8, n5, dArray2);
                n5 = IlvMath.a(dArray, n2, d4, n7, d3, n4, n5, dArray2);
            } else {
                dArray2[n5++] = d4;
            }
        }
        return n5;
    }

    private static int a(double[][] dArray, int n2, double d2) {
        boolean bl = dArray[n2 - 1][0] < 0.0;
        int n3 = 0;
        for (int i2 = n2 - 2; i2 >= 1; --i2) {
            boolean bl2;
            double d3 = IlvMath.a(dArray[i2], d2);
            if (d3 == 0.0) continue;
            boolean bl3 = bl2 = d3 < 0.0;
            if (bl2 != bl) {
                ++n3;
            }
            bl = bl2;
        }
        double d4 = IlvMath.a(dArray[0], d2);
        if (d4 != 0.0) {
            boolean bl4;
            boolean bl5 = bl4 = d4 < 0.0;
            if (bl4 != bl) {
                ++n3;
            }
            bl = bl4;
            return n3;
        }
        return -1 - n3;
    }

    private static double a(double[] dArray, double d2) {
        int n2 = dArray.length - 1;
        double d3 = dArray[n2];
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            d3 = d3 * d2 + dArray[i2];
        }
        return d3;
    }

    private static double[] a(double[] dArray, double[] dArray2) {
        int n2;
        int n3 = dArray2.length - 1;
        double[] dArray3 = new double[n2 + 1];
        System.arraycopy(dArray, 0, dArray3, 0, n2 + 1);
        double[] dArray4 = new double[n2 - n3 + 1];
        for (n2 = dArray.length - 1; n2 >= n3; --n2) {
            double d2;
            dArray4[n2 - n3] = d2 = dArray3[n2] / dArray2[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = i2 + n2 - n3;
                dArray3[n4] = dArray3[n4] - d2 * dArray2[i2];
            }
        }
        return dArray4;
    }

    private static double[] b(double[] dArray, double[] dArray2) {
        int n2;
        int n3 = dArray2.length - 1;
        double[] dArray3 = new double[n2 + 1];
        System.arraycopy(dArray, 0, dArray3, 0, n2 + 1);
        for (n2 = dArray.length - 1; n2 >= n3; --n2) {
            double d2 = dArray3[n2] / dArray2[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = i2 + n2 - n3;
                dArray3[n4] = dArray3[n4] - d2 * dArray2[i2];
            }
        }
        while (n2 >= 0 && dArray3[n2] == 0.0) {
            --n2;
        }
        double[] dArray4 = new double[n2 + 1];
        for (int i3 = 0; i3 <= n2; ++i3) {
            dArray4[i3] = -dArray3[i3];
        }
        return dArray4;
    }
}

