/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class IlvImageUtil {
    public static Image getImageFromFile(Class clazz, String string) throws IOException {
        int n2;
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException(clazz + ".getResourceAsStream(" + string + ") returns null");
        }
        byte[][] byArrayArray = new byte[1][];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byArrayArray[0] = new byte[1024];
        while ((n2 = bufferedInputStream.read(byArrayArray[0])) > 0) {
            byteArrayOutputStream.write(byArrayArray[0], 0, n2);
        }
        bufferedInputStream.close();
        byteArrayOutputStream.flush();
        byArrayArray[0] = byteArrayOutputStream.toByteArray();
        if (byArrayArray[0] == null) {
            throw new IOException(clazz.getName() + "/" + string + " not found.");
        }
        if (byArrayArray[0].length == 0) {
            throw new IOException("warning: " + string + " is zero-length");
        }
        return Toolkit.getDefaultToolkit().createImage(byArrayArray[0]);
    }

    public static Image loadImageFromFile(Class clazz, String string) throws IOException {
        return IlvImageUtil.a(IlvImageUtil.getImageFromFile(clazz, string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createBufferedImage(Image image, int n2) {
        Object object;
        if (image == null) {
            return null;
        }
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        if (n3 < 0 || n4 < 0) {
            object = new MediaTracker(new Component(){});
            ((MediaTracker)object).addImage(image, 0);
            try {
                ((MediaTracker)object).waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            finally {
                ((MediaTracker)object).removeImage(image);
            }
            n3 = image.getWidth(null);
            n4 = image.getHeight(null);
        }
        if (n3 <= 0 || n4 <= 0) {
            return null;
        }
        object = new BufferedImage(n3, n4, n2);
        Graphics graphics = ((BufferedImage)object).getGraphics();
        if (graphics == null) {
            return null;
        }
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        return object;
    }

    public static Image loadImage(URL uRL) {
        return IlvImageUtil.a(Toolkit.getDefaultToolkit().getImage(uRL));
    }

    public static Image loadImage(String string) {
        Image image = null;
        try {
            URL uRL = new File(string).toURL();
            image = IlvImageUtil.loadImage(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return image;
    }

    public static BufferedImage loadImage(String string, int n2) {
        BufferedImage bufferedImage = null;
        try {
            URL uRL = new File(string).toURL();
            bufferedImage = IlvImageUtil.loadImage(uRL, n2);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return bufferedImage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BufferedImage loadImage(URL uRL, int n2) {
        block6: {
            BufferedImage bufferedImage;
            BufferedImage bufferedImage2;
            block5: {
                if (uRL == null) {
                    throw new IllegalArgumentException("URL of image is null");
                }
                bufferedImage2 = null;
                String string = uRL.toString().toLowerCase();
                if (string.endsWith(".jpg")) break block5;
                if (!string.endsWith(".jpeg")) break block6;
            }
            if ((bufferedImage = IlvImageUtil.a(uRL)) == null) return bufferedImage2;
            if (bufferedImage.getType() == n2) return bufferedImage;
            return IlvImageUtil.createBufferedImage(bufferedImage, n2);
        }
        Image image = IlvImageUtil.loadImage(uRL);
        if (image == null) {
            return null;
        }
        BufferedImage bufferedImage = IlvImageUtil.createBufferedImage(image, n2);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized BufferedImage a(URL uRL) {
        BufferedImage bufferedImage = null;
        if (uRL != null) {
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)inputStream);
                bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
            }
            catch (IOException iOException) {
                bufferedImage = null;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (bufferedImage != null && (bufferedImage.getWidth() <= 0 || bufferedImage.getHeight() <= 0)) {
                bufferedImage = null;
            }
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image a(Image image) {
        if (image != null) {
            MediaTracker mediaTracker = new MediaTracker(new Component(){});
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                mediaTracker.removeImage(image);
                image = null;
            }
            finally {
                if (image != null) {
                    mediaTracker.removeImage(image);
                }
                if (mediaTracker.isErrorAny()) {
                    image = null;
                }
                if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                    image = null;
                }
            }
        }
        return image;
    }

    private IlvImageUtil() {
    }
}

