/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.servlet.internal;

import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.util.servlet.internal.IlvServletUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class IlvManagerServletUtil
extends IlvServletUtil {
    public static IlvRect getTileBBoxParameter(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView, IlvRect ilvRect) throws ServletException {
        IlvRect ilvRect2 = new IlvRect();
        String string = httpServletRequest.getParameter("tile");
        if (string == null) {
            throw new ServletException("No bbox or tile parameter");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ServletException("bad tile " + string);
        }
        String string2 = stringTokenizer.nextToken();
        float f2 = Float.parseFloat(string2);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ServletException("bad tile " + string);
        }
        string2 = stringTokenizer.nextToken();
        int n2 = Integer.parseInt(string2);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ServletException("bad tile " + string);
        }
        string2 = stringTokenizer.nextToken();
        int n3 = Integer.parseInt(string2);
        ilvRect2 = new IlvRect(ilvRect.x + (float)n2 * f2, ilvRect.y + (float)n3 * f2, f2, f2);
        return ilvRect2;
    }

    public static IlvRect getBBoxParameter(HttpServletRequest httpServletRequest) throws ServletException {
        return IlvManagerServletUtil.getBBoxParameter(httpServletRequest, "bbox");
    }

    public static IlvRect getBBoxParameter(HttpServletRequest httpServletRequest, String string) throws ServletException {
        IlvRect ilvRect = new IlvRect();
        String string2 = IlvServletUtil.getStringParameter(httpServletRequest, string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
        try {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ServletException("bad bbox " + string2);
            }
            String string3 = stringTokenizer.nextToken();
            ilvRect.x = Float.parseFloat(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ServletException("bad bbox y");
            }
            string3 = stringTokenizer.nextToken();
            ilvRect.y = Float.parseFloat(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ServletException("bad bbox w");
            }
            string3 = stringTokenizer.nextToken();
            ilvRect.width = Float.parseFloat(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ServletException("bad bbox h");
            }
            string3 = stringTokenizer.nextToken();
            ilvRect.height = Float.parseFloat(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServletException("bad bbox " + string2, (Throwable)numberFormatException);
        }
        return ilvRect;
    }

    public static IlvTransformer getTransformer(IlvRect ilvRect, int n2, int n3) {
        IlvTransformer ilvTransformer = new IlvTransformer();
        IlvTransformer.computeTransformer(ilvRect, new IlvRect(0.0f, 0.0f, n2, n3), ilvTransformer);
        if (Double.isInfinite(ilvTransformer.zoomFactor())) {
            return new IlvTransformer();
        }
        return ilvTransformer;
    }

    private static Color a(String string) throws NumberFormatException {
        Color color = null;
        if (string != null) {
            string.trim();
            int n2 = Integer.decode(string);
            color = new Color(n2);
        }
        if (color != null) {
            return color;
        }
        throw new NumberFormatException("bad color " + string);
    }

    public static Color getOptionalColorParameter(HttpServletRequest httpServletRequest, String string, Color color) throws ServletException {
        String string2 = httpServletRequest.getParameter(string);
        if (string2 == null || string2.length() == 0) {
            return color;
        }
        try {
            return IlvManagerServletUtil.a(string2);
        }
        catch (Exception exception) {
            throw new ServletException("bad color parameter: " + string + ": " + string2, (Throwable)exception);
        }
    }

    public static String[] getLayerParameter(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("layer");
        if (string == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void setVisibleLayers(IlvManagerView ilvManagerView, String[] stringArray, IlvManagerLayer[] ilvManagerLayerArray) {
        int n2;
        Vector<IlvManagerLayer> vector = new Vector<IlvManagerLayer>(ilvManagerLayerArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n3;
            String string = stringArray[i2];
            IlvManagerLayer ilvManagerLayer = null;
            for (n3 = 0; n3 < ilvManagerLayerArray.length; ++n3) {
                if (ilvManagerLayerArray[n3].getName() == null || !ilvManagerLayerArray[n3].getName().equals(string)) continue;
                ilvManagerLayer = ilvManagerLayerArray[n3];
                break;
            }
            if (ilvManagerLayer == null) {
                try {
                    n3 = Integer.parseInt(string);
                    if (n3 >= 0 && n3 < ilvManagerLayerArray.length) {
                        ilvManagerLayer = ilvManagerLayerArray[n3];
                    }
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("bad layer : " + string);
                }
            }
            if (ilvManagerLayer == null) {
                throw new IllegalArgumentException("bad layer : " + string);
            }
            vector.addElement(ilvManagerLayer);
        }
        Object[] objectArray = new IlvManagerLayer[vector.size()];
        vector.copyInto(objectArray);
        for (n2 = 0; n2 < ilvManagerLayerArray.length; ++n2) {
            ilvManagerView.getManager().setVisible(ilvManagerView, ilvManagerLayerArray[n2].getIndex(), false, false);
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            ilvManagerView.getManager().setVisible(ilvManagerView, ((IlvManagerLayer)objectArray[n2]).getIndex(), true, false);
        }
    }
}

