/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.form.internal;

import ilog.views.appframe.form.IlvFormException;
import ilog.views.appframe.form.IlvFormReaderContext;
import ilog.views.appframe.form.internal.FormUtils;
import ilog.views.appframe.form.internal.PropertyIntrospector;
import ilog.views.appframe.form.internal.io.IlvFormReaderException;
import java.awt.Color;
import java.awt.Font;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class AttributeValueConverter {
    private static IntegerConvert a = null;
    private static StringConvert b = null;
    private static FloatConvert c = null;
    private static DoubleConvert d = null;
    private static ShortConvert e = null;
    private static ByteConvert f = null;
    private static LongConvert g = null;
    private static BooleanConvert h = null;
    private static ColorConvert i = null;
    private static FontConvert j = null;

    public Object convertFromText(Element element, String string, Object object, IlvFormReaderContext ilvFormReaderContext) throws IlvFormException {
        Attr attr = element.getAttributeNode(string);
        if (attr == null) {
            return object;
        }
        try {
            return this.convertFromText(attr.getValue(), ilvFormReaderContext);
        }
        catch (Exception exception) {
            throw new IlvFormReaderException(ilvFormReaderContext, "Form.Parsing.CannotConvertIntoType", attr.getValue(), this.getTypeName(), string, element.getTagName(), exception);
        }
    }

    public Object convertFromText(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
        try {
            return this.doConvertFromText(string, ilvFormReaderContext);
        }
        catch (Exception exception) {
            Object object;
            if (ilvFormReaderContext != null && !string.equals(object = ilvFormReaderContext.getString(string))) {
                return this.doConvertFromText((String)object, ilvFormReaderContext);
            }
            object = PropertyIntrospector.IsFieldAccessor(string, ilvFormReaderContext);
            if (object != null) {
                return ((PropertyIntrospector.FieldPropertyAccessor)object).getValueFromText(null, string, ilvFormReaderContext);
            }
            throw exception;
        }
    }

    protected abstract String getTypeName();

    protected abstract Object doConvertFromText(String var1, IlvFormReaderContext var2) throws Exception;

    public static int ConvertToInt(Element element, String string, int n2, IlvFormReaderContext ilvFormReaderContext) throws IlvFormException {
        if (a == null) {
            a = new IntegerConvert();
        }
        Integer n3 = (Integer)a.convertFromText(element, string, new Integer(n2), ilvFormReaderContext);
        return n3;
    }

    public static Object ConvertToValue(String string, Class clazz, IlvFormReaderContext ilvFormReaderContext) throws Exception {
        AttributeValueConverter attributeValueConverter = null;
        if (String.class.equals((Object)clazz)) {
            if (b == null) {
                b = new StringConvert();
            }
            attributeValueConverter = b;
        } else if (Integer.class.equals((Object)clazz) || Integer.TYPE.equals(clazz)) {
            if (a == null) {
                a = new IntegerConvert();
            }
            attributeValueConverter = a;
        } else if (Float.class.equals((Object)clazz) || Float.TYPE.equals(clazz)) {
            if (c == null) {
                c = new FloatConvert();
            }
            attributeValueConverter = c;
        } else if (Double.class.equals((Object)clazz) || Double.TYPE.equals(clazz)) {
            if (d == null) {
                d = new DoubleConvert();
            }
            attributeValueConverter = d;
        } else if (Short.class.equals((Object)clazz) || Short.TYPE.equals(clazz)) {
            if (e == null) {
                e = new ShortConvert();
            }
            attributeValueConverter = e;
        } else if (Long.class.equals((Object)clazz) || Long.TYPE.equals(clazz)) {
            if (g == null) {
                g = new LongConvert();
            }
            attributeValueConverter = g;
        } else if (Byte.class.equals((Object)clazz) || Byte.TYPE.equals(clazz)) {
            if (f == null) {
                f = new ByteConvert();
            }
            attributeValueConverter = f;
        } else if (Boolean.class.equals((Object)clazz) || Boolean.TYPE.equals(clazz)) {
            if (h == null) {
                h = new BooleanConvert();
            }
            attributeValueConverter = h;
        } else if (Color.class.equals((Object)clazz)) {
            if (i == null) {
                i = new ColorConvert();
            }
            attributeValueConverter = i;
        } else if (Font.class.equals((Object)clazz)) {
            if (j == null) {
                j = new FontConvert();
            }
            attributeValueConverter = j;
        }
        return attributeValueConverter == null ? null : attributeValueConverter.convertFromText(string, ilvFormReaderContext);
    }

    public static int ConvertToInt(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
        if (a == null) {
            a = new IntegerConvert();
        }
        Integer n2 = (Integer)a.convertFromText(string, ilvFormReaderContext);
        return n2;
    }

    public static float ConvertToFloat(Element element, String string, float f2, IlvFormReaderContext ilvFormReaderContext) throws IlvFormException {
        if (c == null) {
            c = new FloatConvert();
        }
        Float f3 = (Float)c.convertFromText(element, string, new Float(f2), ilvFormReaderContext);
        return f3.floatValue();
    }

    public static float ConvertToFloat(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
        if (c == null) {
            c = new FloatConvert();
        }
        Float f2 = (Float)c.convertFromText(string, ilvFormReaderContext);
        return f2.floatValue();
    }

    public static double ConvertToDouble(Element element, String string, double d2, IlvFormReaderContext ilvFormReaderContext) throws IlvFormException {
        if (d == null) {
            d = new DoubleConvert();
        }
        Double d3 = (Double)d.convertFromText(element, string, new Double(d2), ilvFormReaderContext);
        return d3;
    }

    public static double ConvertToDouble(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
        if (d == null) {
            d = new DoubleConvert();
        }
        Double d2 = (Double)d.convertFromText(string, ilvFormReaderContext);
        return d2;
    }

    public static short ConvertToShort(Element element, String string, short s2, IlvFormReaderContext ilvFormReaderContext) throws IlvFormException {
        if (e == null) {
            e = new ShortConvert();
        }
        Double d2 = (Double)e.convertFromText(element, string, new Short(s2), ilvFormReaderContext);
        return d2.shortValue();
    }

    public static short ConvertToShort(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
        if (e == null) {
            e = new ShortConvert();
        }
        Short s2 = (Short)e.convertFromText(string, ilvFormReaderContext);
        return s2;
    }

    public static byte ConvertToByte(Element element, String string, byte by, IlvFormReaderContext ilvFormReaderContext) throws IlvFormException {
        if (f == null) {
            f = new ByteConvert();
        }
        Byte by2 = (Byte)f.convertFromText(element, string, new Byte(by), ilvFormReaderContext);
        return by2;
    }

    public static byte ConvertToByte(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
        if (f == null) {
            f = new ByteConvert();
        }
        Byte by = (Byte)f.convertFromText(string, ilvFormReaderContext);
        return by;
    }

    public static long ConvertToLong(Element element, String string, long l2, IlvFormReaderContext ilvFormReaderContext) throws IlvFormException {
        if (g == null) {
            g = new LongConvert();
        }
        Long l3 = (Long)g.convertFromText(element, string, new Long(l2), ilvFormReaderContext);
        return l3;
    }

    public static long ConvertToLong(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
        if (g == null) {
            g = new LongConvert();
        }
        Long l2 = (Long)g.convertFromText(string, ilvFormReaderContext);
        return l2;
    }

    public static boolean ConvertToBoolean(Element element, String string, boolean bl, IlvFormReaderContext ilvFormReaderContext) throws IlvFormException {
        if (h == null) {
            h = new BooleanConvert();
        }
        Boolean bl2 = (Boolean)h.convertFromText(element, string, bl ? Boolean.TRUE : Boolean.FALSE, ilvFormReaderContext);
        return bl2;
    }

    public static boolean ConvertToBoolean(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
        if (h == null) {
            h = new BooleanConvert();
        }
        Boolean bl = (Boolean)h.convertFromText(string, ilvFormReaderContext);
        return bl;
    }

    public static Color ConvertToColor(Element element, String string, Color color, IlvFormReaderContext ilvFormReaderContext) throws IlvFormException {
        if (i == null) {
            i = new ColorConvert();
        }
        return (Color)i.convertFromText(element, string, color, ilvFormReaderContext);
    }

    public static Color ConvertToColor(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
        if (i == null) {
            i = new ColorConvert();
        }
        return (Color)i.convertFromText(string, ilvFormReaderContext);
    }

    public static Font ConvertToFont(Element element, String string, Font font, IlvFormReaderContext ilvFormReaderContext) throws IlvFormException {
        if (j == null) {
            j = new FontConvert();
        }
        return (Font)j.convertFromText(element, string, font, ilvFormReaderContext);
    }

    public static Font ConvertToFont(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
        if (j == null) {
            j = new FontConvert();
        }
        return (Font)j.convertFromText(string, ilvFormReaderContext);
    }

    private static class FontConvert
    extends AttributeValueConverter {
        private FontConvert() {
        }

        protected String getTypeName() {
            return "Font";
        }

        protected Object doConvertFromText(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
            return FormUtils.DecodeFont(string);
        }
    }

    private static class ColorConvert
    extends AttributeValueConverter {
        private ColorConvert() {
        }

        protected String getTypeName() {
            return "Color";
        }

        protected Object doConvertFromText(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
            return FormUtils.DecodeColor(string);
        }
    }

    private static class BooleanConvert
    extends AttributeValueConverter {
        private BooleanConvert() {
        }

        protected String getTypeName() {
            return "Boolean";
        }

        protected Object doConvertFromText(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
            if ("true".compareToIgnoreCase(string) == 0) {
                return Boolean.TRUE;
            }
            if ("false".compareToIgnoreCase(string) == 0) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("");
        }
    }

    private static class LongConvert
    extends AttributeValueConverter {
        private LongConvert() {
        }

        protected String getTypeName() {
            return "Long";
        }

        protected Object doConvertFromText(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
            return new Long(Long.parseLong(string));
        }
    }

    private static class ByteConvert
    extends AttributeValueConverter {
        private ByteConvert() {
        }

        protected String getTypeName() {
            return "Byte";
        }

        protected Object doConvertFromText(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
            return new Byte(Byte.parseByte(string));
        }
    }

    private static class ShortConvert
    extends AttributeValueConverter {
        private ShortConvert() {
        }

        protected String getTypeName() {
            return "Short";
        }

        protected Object doConvertFromText(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
            return new Short(Short.parseShort(string));
        }
    }

    private static class DoubleConvert
    extends AttributeValueConverter {
        private DoubleConvert() {
        }

        protected String getTypeName() {
            return "Double";
        }

        protected Object doConvertFromText(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
            return new Double(Double.parseDouble(string));
        }
    }

    private static class FloatConvert
    extends AttributeValueConverter {
        private FloatConvert() {
        }

        protected String getTypeName() {
            return "Float";
        }

        protected Object doConvertFromText(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
            return new Float(Float.parseFloat(string));
        }
    }

    private static class StringConvert
    extends AttributeValueConverter {
        private StringConvert() {
        }

        protected String getTypeName() {
            return "String";
        }

        protected Object doConvertFromText(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
            return string;
        }
    }

    private static class IntegerConvert
    extends AttributeValueConverter {
        private IntegerConvert() {
        }

        protected String getTypeName() {
            return "Integer";
        }

        protected Object doConvertFromText(String string, IlvFormReaderContext ilvFormReaderContext) throws Exception {
            return new Integer(Integer.parseInt(string));
        }
    }
}

