/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.event;

import ilog.views.appframe.event.ActionHandler;
import ilog.views.appframe.event.MessageEvent;
import ilog.views.appframe.event.MessageListener;
import java.awt.event.ActionEvent;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.Action;

class IlvBeanMessageListener
implements MessageListener,
ActionHandler {
    protected Object object;
    protected HashMap propertyDescriptors;
    protected HashMap mapper = null;

    public IlvBeanMessageListener(Object object) {
        this.setObject(object);
    }

    public void receiveMessage(MessageEvent messageEvent) {
        this.invoke(this.getMethodName(messageEvent.getMessageName()), messageEvent.getMessageParameters());
    }

    public boolean isProcessingAction(String string) {
        return this.getMethod(this.getMethodName(string)) != null;
    }

    public boolean updateAction(Action action) {
        Object object;
        Method method = this.getMethod(this.getMethodName((String)action.getValue("ActionCommandKey")));
        if (method == null) {
            return false;
        }
        try {
            object = method.invoke(this.object, action);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println(this.getClass().getName() + ": can not invoke method of name " + action.getValue("ActionCommandKey"));
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(this.getClass().getName() + ": can not access method of name " + action.getValue("ActionCommandKey"));
            return false;
        }
        return object == null ? false : (Boolean)object;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.invoke(this.getMethodName(actionEvent.getActionCommand()), new Object[]{actionEvent});
    }

    public boolean setObject(Object object) {
        this.object = object;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (Exception exception) {
            this.propertyDescriptors = null;
            return false;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null || propertyDescriptorArray.length == 0) {
            this.propertyDescriptors = null;
            return true;
        }
        this.propertyDescriptors = new HashMap(propertyDescriptorArray.length);
        for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
            this.propertyDescriptors.put(propertyDescriptorArray[i2].getName(), propertyDescriptorArray[i2]);
        }
        return true;
    }

    public void map(String string, String string2) {
        if (this.mapper == null) {
            if (string2 == null) {
                return;
            }
            this.mapper = new HashMap();
        }
        if (string2 == null) {
            this.mapper.remove(string);
        } else {
            this.mapper.put(string, string2);
        }
    }

    public String getMethodName(String string) {
        String string2 = null;
        if (this.mapper != null) {
            string2 = (String)this.mapper.get(string);
        }
        return string2 == null ? string : string2;
    }

    protected Method getMethod(String string) {
        PropertyDescriptor propertyDescriptor;
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor = this.propertyDescriptors == null ? null : (PropertyDescriptor)this.propertyDescriptors.get(string);
        if (propertyDescriptor == null) {
            try {
                return this.object.getClass().getMethod(string, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println(this.getClass().getName() + ": no method found with the name " + string);
                return null;
            }
        }
        return propertyDescriptor.getWriteMethod();
    }

    protected Object invoke(String string, Object[] objectArray) {
        Object object;
        Method method = this.getMethod(string);
        try {
            object = method.invoke(this.object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println(this.getClass().getName() + ": can not invoke method of name " + string);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(this.getClass().getName() + ": can not access method of name " + string);
            return null;
        }
        return object;
    }
}

