/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmRootSchema;

public abstract class UtilityBase {
    public static final String JDBC_URL_PROPERTY_NAME = "url";
    public static final String USER_ID_PROPERTY_NAME = "user";
    public static final String PASSWORD_PROPERTY_NAME = "password";
    public static final String TRACE = "trace";
    public static final String DML = "dml";

    protected static Properties parseCommandLineProperties(String[] stringArray) {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; i += 2) {
            if (i + 1 == stringArray.length) {
                throw new IllegalArgumentException("Command-line arguments must be specified in the form -<PropertyName> <PropertyValue>, with name and value separated by whitespace.");
            }
            properties.put(stringArray[i].substring(1), stringArray[i + 1]);
        }
        properties.put("MetadataReaderMode", "11_ONLY");
        return properties;
    }

    protected static OracleConnection connect(Properties properties) throws SQLException {
        Statement statement;
        String string = (String)properties.get(JDBC_URL_PROPERTY_NAME);
        if (null == string) {
            throw new IllegalArgumentException("Must specifiy -url");
        }
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection connection = DriverManager.getConnection(string, properties);
        String string2 = (String)properties.get(TRACE);
        if ("YES".equalsIgnoreCase(string2)) {
            statement = connection.createStatement();
            statement.execute("ALTER SESSION SET EVENTS='10046 trace name context forever, level 4'");
            statement.execute("ALTER SESSION SET TIMED_STATISTICS=TRUE");
            statement.execute("ALTER SESSION SET \"_XSOLAPI_DML_TRACE\"=TRUE");
            statement.execute("ALTER SESSION SET EVENTS='37377 trace name context forever, level 4'");
        }
        if (null != (string2 = (String)properties.get(DML))) {
            statement = connection.createStatement();
            statement.execute("ALTER SESSION SET \"_XSOLAPI_DML_TRACE\"=" + string2);
        }
        System.out.println("Connected");
        if ("YES".equalsIgnoreCase((String)properties.get("pause"))) {
            System.out.println("Execution paused. Press return to continue.");
            try {
                System.in.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (OracleConnection)connection;
    }

    protected static DataProvider createDataProvider(OracleConnection oracleConnection, Properties properties) throws SQLException {
        DataProvider dataProvider = new DataProvider(null, properties);
        dataProvider.createSession(oracleConnection);
        System.out.println("Create OLAP API Session");
        return dataProvider;
    }

    protected static MdmDatabaseSchema getDatabaseSchema(MdmMetadataProvider mdmMetadataProvider, Properties properties) {
        MdmRootSchema mdmRootSchema = (MdmRootSchema)mdmMetadataProvider.getRootSchema();
        String string = (String)properties.get(USER_ID_PROPERTY_NAME);
        MdmDatabaseSchema mdmDatabaseSchema = mdmRootSchema.getDatabaseSchema(string.toUpperCase());
        return mdmDatabaseSchema;
    }

    protected static void printResultSet(ResultSet resultSet) throws SQLException {
        int n;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        for (n = 1; n <= n2; ++n) {
            UtilityBase.printColumnHeader(resultSetMetaData, n);
        }
        System.out.println();
        UtilityBase.printHeaderSep(resultSetMetaData);
        System.out.println();
        while (resultSet.next()) {
            for (n = 1; n <= n2; ++n) {
                UtilityBase.printColumnValue(resultSet, resultSetMetaData, n);
            }
            System.out.println();
        }
    }

    protected static void dumpSQL(OracleConnection oracleConnection, String string, String string2) throws SQLException {
        Statement statement = oracleConnection.createStatement();
        System.out.println(string2);
        ResultSet resultSet = statement.executeQuery(string);
        UtilityBase.printResultSet(resultSet);
        resultSet.close();
        statement.close();
    }

    private static void printColumnHeader(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        String string = resultSetMetaData.getColumnLabel(n);
        UtilityBase.printColumnString(resultSetMetaData, n, string);
    }

    private static void printHeaderSep(ResultSetMetaData resultSetMetaData) throws SQLException {
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            int n;
            if (i > 1) {
                System.out.print(" ");
            }
            if ((n = resultSetMetaData.getColumnDisplaySize(i)) > 30) {
                n = 30;
            }
            if (n < resultSetMetaData.getColumnLabel(i).length()) {
                n = resultSetMetaData.getColumnLabel(i).length();
            }
            for (int j = 0; j < n; ++j) {
                System.out.print("-");
            }
        }
    }

    private static void printColumnValue(ResultSet resultSet, ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        UtilityBase.printColumnString(resultSetMetaData, n, resultSet.getString(n));
    }

    private static void printColumnString(ResultSetMetaData resultSetMetaData, int n, String string) throws SQLException {
        if (string == null) {
            string = "<null>";
        }
        System.out.print(string);
        int n2 = resultSetMetaData.getColumnDisplaySize(n);
        if (n2 > 30) {
            n2 = 30;
        }
        if (n2 < resultSetMetaData.getColumnLabel(n).length()) {
            n2 = resultSetMetaData.getColumnLabel(n).length();
        }
        int n3 = n2 - string.length();
        if (n < resultSetMetaData.getColumnCount()) {
            ++n3;
        }
        for (int i = 0; i < n3; ++i) {
            System.out.print(" ");
        }
    }
}

