/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.metadata.mdm.MdmBaseObjectVisitor;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmDimensionMemberInfo;
import oracle.olapi.metadata.mdm.MdmInvalidValueException;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasureDimension;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmValueConverter;
import oracle.olapi.metadata.mdm.MdmValueHierarchy;

class MdmODBOValueConverter
extends MdmBaseObjectVisitor
implements MdmValueConverter {
    MdmODBOValueConverter() {
    }

    private String wrap(String string) {
        return "[" + string + "]";
    }

    @Override
    public String convertLocalValueToUniqueValue(MdmMetadataProvider mdmMetadataProvider, MdmLevel mdmLevel, String string) {
        MdmMeasureDimension mdmMeasureDimension = mdmMetadataProvider.getRootSchema().getMeasureDimension();
        if (mdmLevel.getPrimaryDimension() == mdmMeasureDimension) {
            return string;
        }
        return mdmLevel.getID() + "." + this.wrap(string);
    }

    @Override
    public String convertLocalValueToUniqueValue(MdmMetadataProvider mdmMetadataProvider, MdmValueHierarchy mdmValueHierarchy, String string) {
        return mdmValueHierarchy.getID() + "." + this.wrap(string);
    }

    String[] extractLocalValue(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (string.endsWith("]")) {
            int n4;
            int n5 = 1;
            int n6 = n4 = string.length() - 1;
            do {
                if ((n6 = string.lastIndexOf(91, n4 - 1)) < (n4 = string.lastIndexOf(93, n4 - 1))) {
                    ++n5;
                    continue;
                }
                --n5;
                n4 = n6;
            } while (n5 > 0 && n4 > 0);
            n = n6 - 1;
            n3 = n6 + 1;
            n2 = string.length() - 1;
        } else {
            n = string.lastIndexOf(46);
            n3 = n + 1;
            n2 = string.length();
        }
        if (n < 0 || string.charAt(n) != '.') {
            throw new MdmInvalidValueException("Invalid format for MDX unique-value string '" + string + "'.");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n3, n2);
        String[] stringArray = new String[]{string2, string3};
        return stringArray;
    }

    @Override
    public void convertUniqueValueToMemberInfo(MdmMetadataProvider mdmMetadataProvider, String string, MdmDimensionMemberInfo mdmDimensionMemberInfo) throws MdmInvalidValueException, MetadataNotFoundException {
        String[] stringArray = this.extractLocalValue(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        MdmObject mdmObject = null;
        if (string2.endsWith("MEASURES") || string2.endsWith("[MEASURES]")) {
            MdmMeasureDimension mdmMeasureDimension = mdmMetadataProvider.getRootSchema().getMeasureDimension();
            mdmObject = mdmMeasureDimension.getDefaultHierarchy();
            if (mdmObject instanceof MdmLevelHierarchy) {
                mdmObject = (MdmObject)((MdmLevelHierarchy)mdmObject).getLevels().get(0);
            }
            string3 = string;
        } else {
            mdmObject = mdmMetadataProvider.getMetadataObject(string2);
        }
        if (mdmObject == null) {
            throw new MetadataNotFoundException("Cannot find object with ID '" + string2 + "'.");
        }
        mdmDimensionMemberInfo.populate(mdmObject, string3, string);
    }

    @Override
    public void convertUniqueValueToMemberInfo(MdmPrimaryDimension mdmPrimaryDimension, String string, MdmDimensionMemberInfo mdmDimensionMemberInfo) throws MdmInvalidValueException, MetadataNotFoundException {
        this.convertUniqueValueToMemberInfo(mdmPrimaryDimension.getMetadataProvider(), string, mdmDimensionMemberInfo);
    }

    @Override
    public MdmDimensionMemberInfo convertUniqueValueToMemberInfo(MdmDimension mdmDimension, String string) throws MdmInvalidValueException, MetadataNotFoundException {
        MdmDimensionMemberInfo mdmDimensionMemberInfo = new MdmDimensionMemberInfo(mdmDimension.getMetadataProvider(), string);
        this.convertUniqueValueToMemberInfo(mdmDimension.getPrimaryDimension(), string, mdmDimensionMemberInfo);
        return mdmDimensionMemberInfo;
    }
}

