/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAWObject;
import oracle.olapi.metadata.conversion.LegacyXMLBaseObject;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLExternalSourceExpression;
import oracle.olapi.syntax.Query;

abstract class LegacyXMLMappingGroup
extends LegacyXMLBaseObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[0];

    protected LegacyXMLMappingGroup(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    final LegacyXMLAWObject getAWObject() {
        return (LegacyXMLAWObject)this.getContainedByObject();
    }

    final Query getQuery() {
        Query query = null;
        List<LegacyXMLExternalSourceExpression> list = this.getSourceExpressions();
        if (null != list) {
            for (LegacyXMLExternalSourceExpression legacyXMLExternalSourceExpression : list) {
                Query query2 = legacyXMLExternalSourceExpression.getSourceColumnsQuery();
                if (null != query) continue;
                query = query2;
            }
        }
        return query;
    }

    protected abstract List<LegacyXMLExternalSourceExpression> getSourceExpressions();

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        Query query = null;
        List<LegacyXMLExternalSourceExpression> list = this.getSourceExpressions();
        if (null != list) {
            for (LegacyXMLExternalSourceExpression legacyXMLExternalSourceExpression : list) {
                if (!legacyXMLExternalSourceExpression.validate(legacyXMLConverter, false)) {
                    return false;
                }
                Query query2 = legacyXMLExternalSourceExpression.getSourceColumnsQuery();
                if (null == query) {
                    query = query2;
                    continue;
                }
                if (null != query && query.toSyntax().equals(query2.toSyntax())) continue;
                legacyXMLConverter.reportError("UnsupportedSourceColumnsConversion", this.getID());
            }
        }
        return true;
    }

    @Override
    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        List<LegacyXMLExternalSourceExpression> list = this.getSourceExpressions();
        if (null == list || list.size() == 0) {
            return super.getBaseConvertOrderNumber(legacyXMLConverter);
        }
        int n = -1;
        for (LegacyXMLExternalSourceExpression legacyXMLExternalSourceExpression : list) {
            int n2 = legacyXMLExternalSourceExpression.getConvertOrderNumber(legacyXMLConverter, false);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }
}

