/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.replay;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.express.olapi.replay.InvalidSourceNodeException;
import oracle.express.olapi.replay.NullSourceNodeException;
import oracle.express.olapi.replay.SourceNodeNotFoundException;
import oracle.express.olapi.replay.XMLDocumentFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

abstract class NodeContext {
    protected Node _node;
    protected XMLDocumentFactory _factory;
    protected String _nodeName;

    public NodeContext(Node node, XMLDocumentFactory xMLDocumentFactory) throws NullSourceNodeException {
        if (node == null) {
            throw new NullSourceNodeException(this.getClass());
        }
        this._node = node;
        this._factory = xMLDocumentFactory;
        this._nodeName = this._node.getNodeName();
        if ("".equals(this._nodeName)) {
            this._nodeName = null;
        }
    }

    public String getNodeName() {
        return this._nodeName;
    }

    public String getAttributeByName(String string) {
        try {
            Attr attr = (Attr)this._node.getAttributes().getNamedItem(string);
            return attr.getValue();
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public final String getID() {
        return this.getAttributeByName("id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        String string = "";
        try {
            for (Node node = this._node.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 3) continue;
                string = ((Text)node).getData();
            }
        }
        catch (Exception exception) {}
        finally {
            return string;
        }
    }

    public boolean isType(String string) {
        return this._nodeName.equals(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getNodeName());
        String string = this.getID();
        if (string != null && string.length() != 0) {
            stringBuffer.append(':').append(string);
        }
        return stringBuffer.toString();
    }

    public NodeContext find(String string) throws SourceNodeNotFoundException {
        try {
            Node node = this._factory.selectNodes(this._node, string).item(0);
            return this.createNode(node);
        }
        catch (Exception exception) {
            throw new SourceNodeNotFoundException(this.getClass(), this, string, exception);
        }
    }

    public NodeContext findDefinition() throws SourceNodeNotFoundException {
        NodeContext nodeContext = this.find("//Definition[@id='" + this.getID() + "']");
        return nodeContext;
    }

    public int getChildrenCount() {
        return this._node.getChildNodes().getLength();
    }

    public Enumeration getChildEnumeration() {
        return new ChildEnumeration();
    }

    public NodeContext getFirstChild() throws SourceNodeNotFoundException {
        try {
            return this.createNode(this._node.getFirstChild());
        }
        catch (Exception exception) {
            throw new SourceNodeNotFoundException(this.getClass(), "firstChild", exception);
        }
    }

    public NodeContext getNextSibling() throws SourceNodeNotFoundException {
        try {
            return this.createNode(this._node.getNextSibling());
        }
        catch (Exception exception) {
            throw new SourceNodeNotFoundException(this.getClass(), "nextSibling", exception);
        }
    }

    public abstract Object create() throws InvalidSourceNodeException;

    protected abstract NodeContext createNode(Node var1) throws InvalidSourceNodeException, NullSourceNodeException;

    private class ChildEnumeration
    implements Enumeration {
        private int _length;
        private int _current;
        private NodeList _list;

        public ChildEnumeration() {
            this._list = NodeContext.this._node.getChildNodes();
            this._length = this._list.getLength();
            this._current = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this._current < this._length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() throws NoSuchElementException {
            NodeContext nodeContext = null;
            try {
                Node node = this._list.item(this._current++);
                nodeContext = NodeContext.this.createNode(node);
            }
            catch (NullPointerException nullPointerException) {
                throw new NoSuchElementException();
            }
            catch (NullSourceNodeException nullSourceNodeException) {
                throw new NoSuchElementException();
            }
            catch (InvalidSourceNodeException invalidSourceNodeException) {
            }
            finally {
                if (this._current >= this._length) {
                    this._list = null;
                }
            }
            return nodeContext;
        }
    }
}

