/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import java.math.BigDecimal;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiStreamable;
import oracle.express.idl.util.OlapiTracer;
import oracle.sql.NUMBER;

public class NUMBERHelper {
    private NUMBERHelper() {
    }

    public static NUMBER SQL2Java(InterfaceStub interfaceStub, BigDecimal bigDecimal) {
        OlapiTracer.enter("NUMBERHelper.SQL2Java");
        NUMBER nUMBER = null;
        try {
            nUMBER = new NUMBER(bigDecimal);
            OlapiTracer.log("sqlnum = " + bigDecimal + ", jnum = " + nUMBER.stringValue());
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("NUMBERHelper.SQL2Java");
        return nUMBER;
    }

    public static BigDecimal Java2SQL(InterfaceStub interfaceStub, NUMBER nUMBER) {
        OlapiTracer.enter("NUMBERHelper.Java2SQL");
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = NUMBER.toBigDecimal((byte[])nUMBER.toBytes());
            OlapiTracer.log("jnum = " + nUMBER.stringValue() + ", sqlnum = " + bigDecimal);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("NUMBERHelper.Java2SQL");
        return bigDecimal;
    }

    public static NUMBER SQL2Java(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable) {
        OlapiTracer.enter("NUMBERHelper.SQL2Java");
        NUMBER nUMBER = null;
        try {
            byte[] byArray = new byte[olapiStreamable.read()];
            byte by = (byte)olapiStreamable.read();
            olapiStreamable.read(byArray);
            if (1 == by) {
                byArray[0] = (byte)(byArray[0] | 0x80);
            }
            nUMBER = new NUMBER(byArray);
            OlapiTracer.log("jnumber = " + nUMBER.stringValue());
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("NUMBERHelper.SQL2Java");
        return nUMBER;
    }

    public static void Java2SQL(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable, NUMBER nUMBER) {
        OlapiTracer.enter("NUMBERHelper.Java2SQL");
        OlapiTracer.log("jnumber = " + nUMBER.stringValue());
        try {
            byte[] byArray = nUMBER.toBytes();
            olapiStreamable.write(byArray.length);
            if (byArray[0] >= 0) {
                olapiStreamable.write(0);
            } else {
                olapiStreamable.write(1);
                byArray[0] = (byte)(byArray[0] & 0x7F);
            }
            olapiStreamable.write(byArray);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("NUMBERHelper.Java2SQL");
    }
}

