/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.controls.IActionUpdater;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.grid.EditableGridController;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTable;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.GridCellUpdateInfo;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdater;
import oracle.dbtools.raptor.controls.grid.RaptorEditableGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.controls.grid.ResultSetGridColumn;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpSystem;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.icons.OracleIcons;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.CHAR;

public class IdentifierMappingPanel2
extends JPanel
implements IActionUpdater {
    private JScrollPane m_scrollPane = null;
    private DBObject m_dbObject = null;
    private Toolbar m_toolbar = null;
    private EditableResultSetTable m_grid = null;
    protected String DEFAULT_ALL_CHANGES_CMD = "impanel.all.default";
    protected String DEFAULT_SELECT_CHANGES_CMD = "impanel.select.default";
    int DEFAULT_ALL_CHANGES_ID = Ide.findOrCreateCmdID((String)this.DEFAULT_ALL_CHANGES_CMD);
    int DEFAULT_SELECT_CHANGES_ID = Ide.findOrCreateCmdID((String)this.DEFAULT_SELECT_CHANGES_CMD);
    IdeAction DEFAULT_ALL_ACTION = IdeAction.get((int)this.DEFAULT_ALL_CHANGES_ID, null, (String)MigrationAddinArb.getString("IDENT_ALL_DEFAULT"), null, null, (Icon)OracleIcons.getIcon((String)"default_activity.png"), null, (boolean)false);
    IdeAction DEFAULT_SELECT_ACTION = IdeAction.get((int)this.DEFAULT_SELECT_CHANGES_ID, null, (String)MigrationAddinArb.getString("IDENT_SEL_DEFAULT"), null, null, (Icon)OracleIcons.getIcon((String)"redo.png"), null, (boolean)false);
    private String m_table_alias = "T";
    private String m_view_alias = "V";
    public final String TABLE_ALIAS = "T.";
    public final String VIEW_ALIAS = "V.";
    private final Integer QUALIFIEDNAME = 0;
    private final Integer SRC_TYPE = 1;
    private final Integer ORIGINAL_IDENTIFIER = 2;
    private final Integer NEW_IDENTIFIER = 3;
    private final Integer TRANSFORMED = 4;
    private final String TRANSFORMED_VALUE = "Y";
    private List<String> m_uneditCols = new ArrayList<String>();
    private IMController _controller = null;
    private IMContextMenuItems _cm = null;

    public IdentifierMappingPanel2(DBObject dBObject) {
        this.m_dbObject = dBObject;
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_convertionIdentifierMap_html");
    }

    public void init() {
        this.m_toolbar = new Toolbar();
        this.m_grid = new EditableResultSetTable((IActionUpdater)this);
        this.m_grid.setInsertAllowed(false);
        this.m_grid.setDeleteAllowed(false);
        this._controller = new IMController(this.m_grid.getController());
        this._cm = new IMContextMenuItems();
        this.m_grid.addLocalContextMenuListener((GridContextMenuItem)this._cm);
        String string = null;
        try {
            string = this.buildSql();
        }
        catch (Exception exception) {
            return;
        }
        DBObject dBObject = DBObject.getDBObjectForName((String)"MD_DERIVATIVES", (String)this.m_dbObject.getConnectionName());
        this.m_grid.setQuery(this.m_dbObject.getConnectionName(), string, null, null, dBObject, this.m_uneditCols, null);
        this.m_grid.registerGridUpdater((IRaptorGridUpdater)new IMGridUpdater(new EditableResultSetTableModel.DataTabGridUpdater(this.m_grid.getGridModel())));
        this.m_grid.getGridModel().setDataIntegrityColumnNames(Arrays.asList("T.ROWID", "T.ORA_ROWSCN"));
        try {
            this.m_grid.open(new RaptorEditableGridTaskWrapper("Opening Identifier Mapping Panel", IRaptorTaskRunMode.MODAL, false, null, null, null, null));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        this._controller.addToolBarActions(this.m_toolbar);
        this.m_scrollPane = new JScrollPane((Component)this.m_grid, 22, 30);
        this.setLayout(new BorderLayout());
        this.m_scrollPane.setBorder(BorderFactory.createEmptyBorder());
        JViewport jViewport = new JViewport();
        jViewport.setView(this.m_grid.getRowHeader());
        jViewport.setPreferredSize(this.m_grid.getRowHeader().getMaximumSize());
        this.m_scrollPane.setRowHeader(jViewport);
        this.add((Component)this.m_toolbar, "North");
        this.add((Component)this.m_scrollPane, "Center");
    }

    public void cleanUp() {
        this.m_grid.closeModel();
    }

    public void updateActions() {
        View.updateToolbarActions((Toolbar)this.m_toolbar);
    }

    public void save() {
        if (this.m_grid.isChanged()) {
            this.m_grid.save();
        }
    }

    private final String buildSql() throws Exception {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(this.QUALIFIEDNAME, "QUALIFIEDNAME");
        hashMap.put(this.SRC_TYPE, "SRC_TYPE");
        hashMap.put(this.ORIGINAL_IDENTIFIER, "ORIGINAL_IDENTIFIER");
        hashMap.put(this.NEW_IDENTIFIER, "NEW_IDENTIFIER");
        hashMap.put(this.TRANSFORMED, "TRANSFORMED");
        String string = this.getCaptureId(this.m_dbObject);
        String string2 = "/* + INDEX_COMBINE ";
        string2 = string2 + "(" + this.m_table_alias + " " + "MD_DERIVATIVES_PERF_IDX MD_DERIVATIVES_PERF_IDX1 MD_DERIVATIVES_PERF_IDX2 MD_DERIVATIVES_PERF_IDX3) */";
        String string3 = "SELECT " + string2 + " ";
        string3 = string3 + "V." + (String)hashMap.get(this.QUALIFIEDNAME) + ", ";
        string3 = string3 + "T." + (String)hashMap.get(this.SRC_TYPE) + ", ";
        string3 = string3 + "T." + (String)hashMap.get(this.ORIGINAL_IDENTIFIER) + ", ";
        string3 = string3 + "T." + (String)hashMap.get(this.NEW_IDENTIFIER) + ", ";
        string3 = string3 + "T." + (String)hashMap.get(this.TRANSFORMED) + " FROM MD_DERIVATIVES " + this.m_table_alias + ", " + "MGV_ALL_DETAILS " + this.m_view_alias;
        string3 = string3 + " WHERE V.CONNID = " + string + " AND " + "T." + "DERIVED_CONNECTION_ID_FK = " + string;
        string3 = string3 + " AND V.CAPTUREDORCONVERTED = 'CAPTURED' AND V.OBJTYPE = ";
        string3 = string3 + "T.SRC_TYPE AND V.OBJID = T.SRC_ID AND ";
        string3 = string3 + "T.DERIVATIVE_REASON = 'SCRATCH'";
        this.m_uneditCols.add((String)hashMap.get(this.QUALIFIEDNAME));
        this.m_uneditCols.add((String)hashMap.get(this.SRC_TYPE));
        this.m_uneditCols.add((String)hashMap.get(this.ORIGINAL_IDENTIFIER));
        this.m_uneditCols.add((String)hashMap.get(this.TRANSFORMED));
        return string3;
    }

    private String getCaptureId(DBObject dBObject) throws Exception {
        String string = null;
        String string2 = null;
        String string3 = dBObject.getObjectName();
        Connection connection = dBObject.getConnection();
        String string4 = "select distinct CONNNAME, CONNID from MGV_ALL_DETAILS";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        boolean bl = false;
        while (resultSet.next()) {
            string = resultSet.getString(1);
            string2 = resultSet.getString(2);
            if (!string.equals(string3)) continue;
            bl = true;
            break;
        }
        statement.close();
        return string2;
    }

    public int getNewIdentifierColumn() {
        return this.NEW_IDENTIFIER;
    }

    public void generateDefaultNewIdentifiers() {
        try {
            EditableResultSetTableModel editableResultSetTableModel = this.m_grid.getGridModel();
            if (editableResultSetTableModel != null) {
                // empty if block
            }
            editableResultSetTableModel.fetchAllRows(true);
            int n = editableResultSetTableModel.getRowCount();
            for (int i = 0; i < n; ++i) {
                String string;
                String string2 = ((CHAR)this.m_grid.getValueAt(i, this.ORIGINAL_IDENTIFIER.intValue())).getString();
                String string3 = ((CHAR)this.m_grid.getValueAt(i, this.NEW_IDENTIFIER.intValue())).getString();
                if (string3.equals(string = this.getDerivedIdentifier(string2))) continue;
                CHAR cHAR = new CHAR(string, CHAR.DEFAULT_CHARSET);
                this.m_grid.setValueAt((Object)cHAR, i, this.NEW_IDENTIFIER.intValue());
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void generateDefaultSingleNewIdentifier() {
        int n = this.m_grid.getSelectedRow();
        if (n >= 0) {
            try {
                if (this.m_grid.isCellSelected(n, this.NEW_IDENTIFIER.intValue())) {
                    String string;
                    String string2 = ((CHAR)this.m_grid.getValueAt(n, this.ORIGINAL_IDENTIFIER.intValue())).stringValue();
                    String string3 = this.m_grid.getValueAt(n, this.NEW_IDENTIFIER.intValue()).toString();
                    if (!string3.equals(string = this.getDerivedIdentifier(string2))) {
                        CHAR cHAR = new CHAR(string, CHAR.DEFAULT_CHARSET);
                        this.m_grid.setValueAt((Object)cHAR, n, this.NEW_IDENTIFIER.intValue());
                    }
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    private String getDerivedIdentifier(String string) throws Exception {
        Connection connection;
        String string2 = null;
        if (this.m_dbObject != null && (connection = this.m_dbObject.getConnection()) != null) {
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call ?:= MIGRATION_TRANSFORMER.TRANSFORM_IDENTIFIER(?)}");
            oracleCallableStatement.registerOutParameter(1, 12);
            oracleCallableStatement.setString(2, string);
            oracleCallableStatement.execute();
            string2 = oracleCallableStatement.getString(1);
            oracleCallableStatement.close();
        }
        return string2;
    }

    private class IMContextMenuItems
    extends GridContextMenuItem {
        IMContextMenuItems() {
            IdentifierMappingPanel2.this.DEFAULT_ALL_ACTION.addController((Controller)this);
            IdentifierMappingPanel2.this.DEFAULT_SELECT_ACTION.addController((Controller)this);
        }

        protected boolean canShow(ContextMenu contextMenu) {
            boolean bl;
            boolean bl2 = bl = this._table != null && this._table.isEditable() && !this._table.isVerticalDisplay();
            if (bl && this._table instanceof EditableResultSetTable && this._table == IdentifierMappingPanel2.this.m_grid) {
                bl = true;
            }
            return bl;
        }

        protected void createAndShowMenu(ContextMenu contextMenu) {
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)IdentifierMappingPanel2.this.DEFAULT_ALL_ACTION);
            contextMenu.add((Component)jMenuItem);
            JMenuItem jMenuItem2 = contextMenu.createMenuItem((ToggleAction)IdentifierMappingPanel2.this.DEFAULT_SELECT_ACTION);
            contextMenu.add((Component)jMenuItem2);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return IdentifierMappingPanel2.this._controller.handleEvent(ideAction, context);
        }

        public boolean update(IdeAction ideAction, Context context) {
            return IdentifierMappingPanel2.this._controller.update(ideAction, context);
        }
    }

    private class IMGridUpdater
    implements IRaptorGridUpdater {
        IRaptorGridUpdater superUpdater = null;

        public IMGridUpdater(EditableResultSetTableModel.DataTabGridUpdater dataTabGridUpdater) {
            this.superUpdater = dataTabGridUpdater;
        }

        public int insertRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            return 0;
        }

        public int deleteRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            return 0;
        }

        public int updateRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            if (this.superUpdater != null) {
                return this.superUpdater.updateRows(string, list, iRaptorTaskProgressUpdater, list2);
            }
            return 0;
        }

        public GridCellUpdateInfo cellUpdated(String string, RaptorGridRowModel raptorGridRowModel, int n, int n2, Object object) {
            ResultSetGridColumn resultSetGridColumn;
            EditableResultSetTableModel editableResultSetTableModel = IdentifierMappingPanel2.this.m_grid.getGridModel();
            if (editableResultSetTableModel != null && (resultSetGridColumn = (ResultSetGridColumn)editableResultSetTableModel.getGridColumns().get(n2)).getOriginal().equals("NEW_IDENTIFIER")) {
                Object object2;
                List list = editableResultSetTableModel.getGridColumns();
                int n3 = -1;
                int n4 = -1;
                int n5 = -1;
                for (int i = 0; i < list.size(); ++i) {
                    object2 = (ResultSetGridColumn)list.get(i);
                    if (object2.getOriginal().equals("ORIGINAL_IDENTIFIER")) {
                        n3 = i;
                        continue;
                    }
                    if (object2.getOriginal().equals("NEW_IDENTIFIER")) {
                        n4 = i;
                        continue;
                    }
                    if (!object2.getOriginal().equals("TRANSFORMED")) continue;
                    n5 = i;
                }
                String string2 = null;
                object2 = null;
                String string3 = null;
                try {
                    Object object3;
                    if (n3 != -1 && (object3 = editableResultSetTableModel.getValueAt(n, n3)) != null) {
                        string2 = ((CHAR)object3).getString();
                    }
                    if (n4 != -1 && (object3 = editableResultSetTableModel.getValueAt(n, n4)) != null) {
                        object2 = DataTypesUtil.stringValue((Object)object3, (Connection)IdentifierMappingPanel2.this.m_dbObject.getConnection());
                    }
                    if (n4 != -1 && (object3 = editableResultSetTableModel.getValueAt(n, n5)) != null) {
                        string3 = ((CHAR)object3).getString();
                    }
                    if (!object2.equals(string2)) {
                        object3 = new CHAR("Y", CHAR.DEFAULT_CHARSET);
                        if (string3 == null || !string3.equals(object3)) {
                            editableResultSetTableModel.setValueAt(object3, n, n5);
                        }
                    } else {
                        object3 = new CHAR("", CHAR.DEFAULT_CHARSET);
                        editableResultSetTableModel.setValueAt(object3, n, n5);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public void setGridInfo(EditableGridInfo editableGridInfo) {
        }
    }

    class IMController
    implements Controller {
        private EditableGridController _super = null;
        private boolean _cmAdded = false;

        public IMController(EditableGridController editableGridController) {
            this._super = editableGridController;
            IdentifierMappingPanel2.this.DEFAULT_ALL_ACTION.addController((Controller)this);
            IdentifierMappingPanel2.this.DEFAULT_SELECT_ACTION.addController((Controller)this);
        }

        public void addToolBarActions(Toolbar toolbar) {
            toolbar.add((ToggleAction)IdentifierMappingPanel2.this.DEFAULT_ALL_ACTION);
            IdentifierMappingPanel2.this.DEFAULT_ALL_ACTION.addController((Controller)this);
            toolbar.add((ToggleAction)IdentifierMappingPanel2.this.DEFAULT_SELECT_ACTION);
            IdentifierMappingPanel2.this.DEFAULT_SELECT_ACTION.addController((Controller)this);
            this._super.addToolBarActions(toolbar);
        }

        public void addContextMenuActions(ContextMenu contextMenu) {
            if (!this._cmAdded) {
                this._cmAdded = true;
                Context context = contextMenu.getContext();
                JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)IdentifierMappingPanel2.this.DEFAULT_ALL_ACTION);
                contextMenu.add((Component)jMenuItem);
                jMenuItem = contextMenu.createMenuItem((ToggleAction)IdentifierMappingPanel2.this.DEFAULT_SELECT_ACTION);
                contextMenu.add((Component)jMenuItem);
                this._super.addContextMenuActions(contextMenu);
            }
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (this._super.getGrid() == null) {
                return false;
            }
            if (this._super.getGrid() != IdentifierMappingPanel2.this.m_grid) {
                return false;
            }
            int n = ideAction.getCommandId();
            if (this.isDefaultCommand(n)) {
                IdentifierMappingPanel2.this.generateDefaultNewIdentifiers();
            } else if (this.isDefaultSingleCommand(n)) {
                IdentifierMappingPanel2.this.generateDefaultSingleNewIdentifier();
            } else {
                return this._super.handleEvent(ideAction, context);
            }
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (this._super.getGrid() == null) {
                return false;
            }
            if (this._super.getGrid() != IdentifierMappingPanel2.this.m_grid) {
                return false;
            }
            if (this._super.getGrid().getGridModel() == null) {
                return false;
            }
            if (this._super.getGrid().getGridModel().isBusy()) {
                return false;
            }
            int n = ideAction.getCommandId();
            if (this.isDefaultCommand(n)) {
                ideAction.setEnabled(!this._super.getGrid().isChanged());
            } else if (this.isDefaultSingleCommand(n)) {
                ideAction.setEnabled(this._super.getGrid().isCellSelected(this._super.getGrid().getSelectedRow(), IdentifierMappingPanel2.this.getNewIdentifierColumn()));
            } else {
                this._super.update(ideAction, context);
            }
            return true;
        }

        boolean isDefaultCommand(int n) {
            return n == IdentifierMappingPanel2.this.DEFAULT_ALL_CHANGES_ID;
        }

        boolean isDefaultSingleCommand(int n) {
            return n == IdentifierMappingPanel2.this.DEFAULT_SELECT_CHANGES_ID;
        }
    }
}

